<?php

/**
 *
 * PHP Pro Bid $Id$ QaVadC7jMDcZ/v4SBbFfzeJ57q3Cid6Cm7gRpeQnmlE=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * members module - offers management controller
 * (buyer, seller can access these actions)
 *
 * browse offers
 * delete invoices
 */

namespace Members\Controller;

use Members\Controller\Action\AbstractAction,
    Members\Form,
    Ppb\Service,
    Cube\Paginator;

class Offers extends AbstractAction
{

    /**
     *
     * offers service
     *
     * @var \Ppb\Service\Offers
     */
    protected $_offers;

    /**
     *
     * offer types to display ('selling', 'buying')
     *
     * @var string
     */
    protected $_type;

    public function init()
    {
        $this->_offers = new Service\Offers();
        $this->_type = $this->getRequest()->getParam('type', 'selling');
    }

    /**
     * TODO: move these actions in a new separate Offers controller (which will have the browse, accept, decline and later counter offer actions)
     */
    public function Browse()
    {
        $filter = $this->getRequest()->getParam('filter', 'all');
        $keywords = $this->getRequest()->getParam('keywords');
        $listingId = $this->getRequest()->getParam('listing_id');


        $table = $this->_offers->getTable();
        $select = $table->getAdapter()->select()
            ->from(array('o' => 'offers'), '*')
            ->join(array('l' => 'listings'), 'l.id = o.listing_id', 'l.user_id AS seller_id')
            ->order('o.created_at DESC');

        switch ($this->_type) {
            case 'buying':
                $select->where('o.user_id = ?', $this->_user['id']);
                break;
            default:
                $select->where('l.user_id = ?', $this->_user['id']);
                break;
        }

        if ($listingId) {
            $select->where('l.id = ?', $listingId);
        }

        if (!empty($keywords)) {
            $params = '%' . str_replace(' ', '%', $keywords) . '%';
            $select->where('l.name LIKE ?', $params);
        }

        if (in_array($filter, array('pending', 'accepted', 'declined', 'withdrawn'))) {
            $select->where('o.status = ?', $filter);
        }

        $paginator = new Paginator(
            new Paginator\Adapter\DbTableSelect($select, $table));


        $pageNumber = $this->getRequest()->getParam('page');
        $paginator->setPageRange(5)
            ->setItemCountPerPage(10)
            ->setCurrentPageNumber($pageNumber);

        return array(
            'controller' => ($this->_type == 'selling') ? 'Selling' : 'Buying',
            'filter'     => $filter,
            'keywords'   => $keywords,
            'listingId'  => $listingId,
            'type'       => $this->_type,
            'paginator'  => $paginator,
            'messages'   => $this->_flashMessenger->getMessages(),
            'params'     => $this->getRequest()->getParams(),
        );
    }

    public function Accept()
    {
        /** @var \Ppb\Db\Table\Row\Offer $offer */
        $offer = $this->_offers->findBy('id', (int)$this->getRequest()->getParam('id'));
        $result = $offer->accept();

        $translate = $this->getTranslate();

        if ($result === true) {
            $this->_flashMessenger->setMessage(array(
                'msg'   => sprintf($translate->_("Offer #%s has been accepted."), $offer['id']),
                'class' => 'alert-success',
            ));
        }
        else {
            $this->_flashMessenger->setMessage(array(
                'msg'   => $this->_("There was an error in accepting the offer: there is not enough "
                        . "quantity available or you are not the owner of the item."),
                'class' => 'alert-danger',
            ));
        }

        $this->_helper->redirector()->redirect('browse');
    }

    public function Decline()
    {
        /** @var \Ppb\Db\Table\Row\Offer $offer */
        $offer = $this->_offers->findBy('id', (int)$this->getRequest()->getParam('id'));
        $result = $offer->decline();

        $translate = $this->getTranslate();

        if ($result === true) {
            $this->_flashMessenger->setMessage(array(
                'msg'   => sprintf($translate->_("Offer #%s has been declined."), $offer['id']),
                'class' => 'alert-success',
            ));
        }
        else {
            $this->_flashMessenger->setMessage(array(
                'msg'   => $this->_("Error: the offer cannot be declined."),
                'class' => 'alert-danger',
            ));
        }

        $this->_helper->redirector()->redirect('browse');
    }

    public function Withdraw()
    {
        /** @var \Ppb\Db\Table\Row\Offer $offer */
        $offer = $this->_offers->findBy('id', (int)$this->getRequest()->getParam('id'));
        $result = $offer->withdraw();

        $translate = $this->getTranslate();

        if ($result === true) {
            $this->_flashMessenger->setMessage(array(
                'msg'   => sprintf($translate->_("Offer #%s has been withdrawn."), $offer['id']),
                'class' => 'alert-success',
            ));
        }
        else {
            $this->_flashMessenger->setMessage(array(
                'msg'   => $this->_("Error: the offer cannot be withdrawn."),
                'class' => 'alert-danger',
            ));
        }

        $this->_helper->redirector()->redirect('browse');
    }

}
