<?php

/**
 *
 * PHP Pro Bid $Id$ vjzRvJCog5PB0tGpbuna3r7wIaopffczi9Nuwc2SXlI=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * offer status view helper class
 */

namespace Listings\View\Helper;

use Cube\View\Helper\AbstractHelper,
    Ppb\Db\Table\Row\Offer as OfferModel;

class OfferStatus extends AbstractHelper
{

    /**
     *
     * offer status helper
     *
     * @param \Ppb\Db\Table\Row\Offer $offer
     *
     * @return string
     */
    public function offerStatus(OfferModel $offer)
    {
        $output = array();

        $translate = $this->getTranslate();

        switch ($offer->status) {
            case OfferModel::STATUS_ACCEPTED:
                $output[] = '<span class="label label-success">' . $translate->_(OfferModel::$statuses[OfferModel::STATUS_ACCEPTED]) . '</span>';
                break;
            case OfferModel::STATUS_DECLINED:
                $output[] = '<span class="label label-declined">' . $translate->_(OfferModel::$statuses[OfferModel::STATUS_DECLINED]) . '</span>';
                break;
            case OfferModel::STATUS_PENDING:
                $output[] = '<span class="label label-pending">' . $translate->_(OfferModel::$statuses[OfferModel::STATUS_PENDING]) . '</span>';
                break;
            case OfferModel::STATUS_WITHDRAWN:
                $output[] = '<span class="label label-withdrawn">' . $translate->_(OfferModel::$statuses[OfferModel::STATUS_WITHDRAWN]) . '</span>';
                break;
            default:
                $output[] = '<span class="label">' . $translate->_('n/a') . '</span>';
                break;
        }

        return implode(' ', $output);
    }

}

