<?php

/**
 * 
 * PHP Pro Bid $Id$ VVXw7xvDsytQoZp09dgvLCpT+BYONfcwghnE3MREyMQ=
 * 
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2013 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 * 
 * @version     7.0
 */
/**
 * listing status view helper class
 */

namespace Listings\View\Helper;

use Cube\View\Helper\AbstractHelper,
    Ppb\Db\Table\Row\Listing as ListingModel;

class ListingStatus extends AbstractHelper
{

    /**
     * 
     * listing status helper
     * 
     * @param \Ppb\Db\Table\Row\Listing $listing
     * @param boolean $detailed
     * @return string|\Listings\View\Helper\ListingStatus
     */
    public function listingStatus(ListingModel $listing, $detailed = true)
    {
        $output = array();

        if (!$listing instanceof ListingModel) {
            throw new \InvalidArgumentException("The ListingStatus view helper requires an object of type \Ppb\Db\Table\Row\Listing");
        }

        if ($listing['draft']) {
            $output[] = '<span class="label label-draft">Draft</span>';
        }
        else {
            if ($detailed === true) {
                if (!$listing['approved']) {
                    $output[] = '<span class="label">Unapproved</span>';
                }
                else if ($listing['active'] == -1) {
                    $output[] = '<span class="label label-important">Admin Suspended</span>';
                }
                else if ($listing['active'] == 0) {
                    $output[] = '<span class="label label-warning">Suspended</span>';
                }
                else {
                    $output[] = '<span class="label label-success">Active</span>';
                }
            }

            switch ($listing->fetchStatus()) {
                case ListingModel::SCHEDULED:
                    $output[] = '<span class="label label-scheduled">Scheduled</span>';
                    break;
                case ListingModel::CLOSED:
                    $output[] = '<span class="label label-closed">Closed</span>';
                    break;
                case ListingModel::OPEN:
                    $output[] = '<span class="label label-open">Open</span>';
                    break;
            }

            if ($detailed === true) {
                if ($listing['deleted']) {
                    $output[] = '<span class="label label-inverse">Deleted</span>';
                }
            }
        }


        return implode('<br>', $output);
    }

}

