<?php

/**
 *
 * PHP Pro Bid $Id$ lbD8QvXOfULcKz3R+OxPG2Wxbgy3GpIuNqmi+uhZYSU=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * shopping cart drop-down button/menu view helper class
 */

namespace Listings\View\Helper;

use Cube\View\Helper\AbstractHelper,
    Cube\Controller\Front,
    Ppb\Service,
    Ppb\Db\Table\Row\User as UserModel;

class CartDropdown extends AbstractHelper
{

    /**
     *
     * settings array
     *
     * @var array
     */
    protected $_settings;

    public function __construct(array $settings)
    {
        $this->setSettings($settings);
    }

    /**
     *
     * set settings array
     *
     * @param array $settings
     *
     * @return $this
     */
    public function setSettings(array $settings)
    {
        $this->_settings = $settings;

        return $this;
    }

    /**
     *
     * generate cart dropdown button/menu
     *
     * @return null|string
     */
    public function cartDropdown()
    {
        $output = null;

        if ($this->_settings['enable_shopping_cart']) {
            $view = $this->getView();
            $bootstrap = Front::getInstance()->getBootstrap();
            /** @var \Cube\Session $session */
            $session = $bootstrap->getResource('session');
            $userToken = $session->getCookie(UserModel::USER_TOKEN);

            $translate = $this->getTranslate();

            $currenciesService = new Service\Table\Currencies();
            $salesService = new Service\Sales();

            $sales = $salesService->fetchAll(
                $salesService->getTable()->select()
                    ->where('pending = ?', 1)
                    ->where('user_token = ?', strval($userToken))
                    ->order(array('updated_at DESC', 'created_at DESC'))
            );

            $nbItems = $price = 0;

            $output = '<div class="shopping-cart-dropdown dropdown-menu">';

            if (count($sales) > 0) {
                /** @var \Ppb\Db\Table\Row\Sale $sale */
                foreach ($sales as $sale) {

                    $output .= '
                        <div class="table-responsive">
                            <table class="table table-condensed">
                                <thead>
                                <tr>
                                    <th class="size-small"></th>
                                    <th>' . $translate->_('Item Description') . '</th>
                                    <th class="size-mini">' . $translate->_('Qty') . '</th>
                                    <th class="size-mini">' . $translate->_('Subtotal') . '</th>
                                </tr>
                                </thead>
                                <tbody>';

                    $salesListings = $sale->findDependentRowset('\Ppb\Db\Table\SalesListings');

                    /** @var \Ppb\Db\Table\Row\SaleListing $saleListing */
                    foreach ($salesListings as $saleListing) {
                        $nbItems++;

                        /** @var \Ppb\Db\Table\Row\Listing $listing */
                        $listing = $saleListing->findParentRow('\Ppb\Db\Table\Listings');

                        $price += $currenciesService->convertAmount($saleListing['quantity'] * $saleListing['price'], $sale['currency'], $this->_settings['currency']);

                        $link = $view->url($listing->link());
                        $output .= '
                            <tr>
                                <td><a href="' . $link . '">' . $view->thumbnail($listing->getMainImage(), 50, true, array('alt' => $listing['name'])) . '</a></td>
                                <td><a href="' . $link . '">' . $listing['name'] . '</a></td>
                                <td>' . $saleListing['quantity'] . '</td>
                                <td>' . $view->amount(($saleListing['quantity'] * $saleListing['price']), $sale['currency']) . '</td>
                            </tr>';
                    }

                    $output .= '
                                <tr>
                                    <td colspan="2"></td>
                                    <td><strong>' . $translate->_('Total') . '</strong></td>
                                    <td>' . $view->amount($sale->calculateTotal(true, false), $sale['currency']) . '</td>
                                </tr>
                                <tr>
                                    <td colspan="4">
                                        <div class="pull-right">
                                            <a href="' . $view->url(array('module' => 'listings', 'controller' => 'cart', 'action' => 'index', 'id' => $sale['id'])) . '"
                                               class="btn btn-default btn-sm">' . $translate->_('View Cart') . '</a>
                                            <a href="' . $view->url(array('module' => 'listings', 'controller' => 'cart', 'action' => 'checkout', 'id' => $sale['id'])) . '"
                                               class="btn btn-default btn-sm">' . $translate->_('Checkout') . '</a>
                                        </div>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>';
                }
            }
            else {
                $output .= '
                    <div class="text-center">
                        <small>' . $translate->_('The shopping cart is empty.') . '</small>
                    </div>';
            }

            $output .= '</div>';

            $output = sprintf(
                    '<button id="open_shopping_cart" class="open_button" dropdown-toggle" data-toggle="dropdown">
											<b class="title">My Cart</b>
											<span>' . $translate->_('Cart') . '%s%s</span>
										</button>',
                    ($price > 0) ? ' &middot; ' . $view->amount($price) : '',
                    ($nbItems) ? ' (' . $nbItems . ')' : '')
                . $output;

        }

        return $output;
    }


}
