<?php

/**
 *
 * PHP Pro Bid $Id$ m819In2zFNrTrxrtzLnkmCthq+wtQPjVyOQfbI4z0Vo=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * make offer ranges view helper class
 */

namespace Listings\View\Helper;

use Cube\View\Helper\AbstractHelper,
    Cube\Controller\Front,
    Ppb\Service;

class BrowsePageTitle extends AbstractHelper
{

    /**
     *
     * categories service object
     *
     * @var \Ppb\Service\Table\Relational\Categories
     */
    protected $_categories;

    /**
     *
     * class constructor
     */
    public function __construct()
    {
        $this->setCategories();
    }

    /**
     *
     * get categories table service
     *
     * @return \Ppb\Service\Table\Relational\Categories
     */
    public function getCategories()
    {
        return $this->_categories;
    }

    /**
     *
     * set categories table service
     *
     * @param \Ppb\Service\Table\Relational\Categories $categories
     *
     * @return \Listings\View\Helper\BrowsePageTitle
     */
    public function setCategories(Service\Table\Relational\Categories $categories = null)
    {
        if (!$categories instanceof Service\Table\Relational\Categories) {
            $categories = new Service\Table\Relational\Categories();
        }

        $this->_categories = $categories;

        return $this;
    }

    /**
     *
     * browse page title view helper
     *
     * @return string
     */
    public function browsePageTitle()
    {
        $output = null;

        $request = Front::getInstance()->getRequest();

        $show = $request->getParam('show');

        if ($show == 'store') {
            $show = null;
        }

        $translate = $this->getTranslate();

        if (empty($show)) {
            if ($keywords = $request->getParam('keywords')) {
                $output .= $translate->_('Search') . ' "' . $keywords . '" ';
            }

            $view = $this->getView();

            if ($parentId = $request->getParam('parent_id')) {
                $breadcrumbs = array();
                foreach ($this->_categories->getBreadcrumbs($parentId) as $key => $value) {
                    $url = $view->url(array('category_name' => $value, 'parent_id' => $key), null, true, array('category_slug', 'page', 'submit'));
                    $breadcrumbs[] = '<a href="' . $url . '">' . $value . '</a>';
                }

                $breadcrumbs = implode(' > ', $breadcrumbs);
                if (!empty($output)) {
                    $output .= ' ' . $translate->_('in') . ' ' . $breadcrumbs;
                }
                else {
                    $listingTypes = array_filter((array)$request->getParam('listing_type'));
                    if (count($listingTypes) == 1) {
                        if (in_array('auction', $listingTypes)) {
                            $output .= $translate->_('Auctions from') . ' ' . $breadcrumbs;
                        }
                        else if (in_array('product', $listingTypes)) {
                            $output .= $translate->_('Products from') . ' ' . $breadcrumbs;
                        }
                    }
                    else {
                        $output .= $translate->_('Listings from') . ' ' . $breadcrumbs;
                    }
                }
            }
        }

        if (empty($output)) {
            switch ($show) {
                case 'featured':
                    $output = $translate->_('Featured Listings');
                    break;
                case 'recent':
                    $output = $translate->_('Recent Listings');
                    break;
                case 'ending':
                    $output = $translate->_('Ending Soon Listings');
                    break;
                case 'popular':
                    $output = $translate->_('Popular Listings');
                    break;
                case 'other-items':
                    $output = $translate->_('Other Items');
                    $username = $request->getParam('username');
                    if (!empty($username)) {
                        $output .= ' ' . sprintf(
                                $translate->_("from '%s'"),
                                $username);
                    }
                    break;

                case 'discounted':
                    $output = $translate->_('Discounted Listings');
                    break;
                default:
                    $output = $translate->_('Browse Listings');
                    break;
            }
        }

        return $output;
    }

}

