<?php

/**
 *
 * PHP Pro Bid $Id$ qmFV8j5YO7KBmwQohZ/1iVrW0c17UZTQGts05Gx7IrM=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.3
 */
/**
 * listing owner notifications emails generator class
 */

namespace Listings\Model\Mail;

use Ppb\Model\BaseMail,
    Ppb\Db\Table\Row\Offer as OfferModel,
    Ppb\Db\Table\Row\Listing as ListingModel,
    Ppb\Db\Table\Row\Bid as BidModel,
    Ppb\Db\Table\Row\User as UserModel,
    Cube\Controller\Request\AbstractRequest;

class BuyerNotification extends BaseMail
{

    /**
     *
     * offer declined buyer notification
     *
     * @param ListingModel $listing
     * @param OfferModel $offer
     *
     * @return $this
     */
    public function offerDeclined(ListingModel $listing, OfferModel $offer)
    {
        $user = $offer->findParentRow('\Ppb\Db\Table\Users');

        $this->setData(array(
            'listing' => $listing,
            'offer'   => $offer,
            'link'    => array('module' => 'members', 'controller' => 'offers', 'action' => 'browse', 'type' => 'buying'),
        ));

        $translate = $this->_mail->getTranslate();

        $this->_mail->setFrom($this->_settings['admin_email'], $this->_settings['email_admin_title'])
            ->setTo($user->getData('email'))
            ->setSubject(
                sprintf($translate->_('%s - Offer Declined'), $listing['name']));

        $this->_view->headerMessage = $this->_('Offer Declined by Seller');
        $this->_view->clearContent()
            ->process(__DIR__ . '/../../../../view/emails/buyer-offer-declined.phtml');

        return $this;
    }

    /**
     *
     * offer accepted buyer notification
     *
     * @param ListingModel $listing
     * @param OfferModel $offer
     *
     * @return $this
     */
    public function offerAccepted(ListingModel $listing, OfferModel $offer)
    {
        $user = $offer->findParentRow('\Ppb\Db\Table\Users');

        $this->setData(array(
            'listing' => $listing,
            'offer'   => $offer,
            'link'    => array('module' => 'members', 'controller' => 'offers', 'action' => 'browse', 'type' => 'buying'),
        ));

        $translate = $this->_mail->getTranslate();

        $this->_mail->setFrom($this->_settings['admin_email'], $this->_settings['email_admin_title'])
            ->setTo($user->getData('email'))
            ->setSubject(
                sprintf($translate->_('%s - Offer Accepted'), $listing['name']));

        $this->_view->headerMessage = $this->_('Offer Accepted by Seller');
        $this->_view->clearContent()
            ->process(__DIR__ . '/../../../../view/emails/buyer-offer-accepted.phtml');

        return $this;
    }

    /**
     *
     * outbid bidder notification
     *
     * @param ListingModel $listing
     * @param BidModel $bid
     *
     * @return $this
     */
    public function outbid(ListingModel $listing, BidModel $bid)
    {
        $user = $bid->findParentRow('\Ppb\Db\Table\Users');

        $this->setData(array(
            'listing' => $listing,
            'bid'     => $bid,
            'link'    => array('module' => 'members', 'controller' => 'buying', 'action' => 'bids'),
        ));

        $translate = $this->_mail->getTranslate();

        $this->_mail->setFrom($this->_settings['admin_email'], $this->_settings['email_admin_title'])
            ->setTo($user->getData('email'))
            ->setSubject(
                sprintf($translate->_('%s - Outbid Notification'), $listing['name']));

        $this->_view->headerMessage = $this->_('Outbid Notification');
        $this->_view->clearContent()
            ->process(__DIR__ . '/../../../../view/emails/buyer-outbid.phtml');

        return $this;
    }

    /**
     *
     *
     * @param ListingModel $listing
     * @param UserModel    $user
     * @param string       $email
     * @param string       $message
     *
     * @return $this
     */
    public function emailFriend(ListingModel $listing, UserModel $user, $email, $message)
    {
        $this->setData(array(
            'listing' => $listing,
            'user'    => $user,
            'message' => nl2br($message),
        ));

        $translate = $this->_mail->getTranslate();

        $this->_mail->setFrom($this->_settings['admin_email'], $this->_settings['email_admin_title'])
            ->setReplyTo($user->getData('email'))
            ->setTo($email)
            ->setSubject(
                sprintf($translate->_('%s has sent you this listing from %s'), $user->getData('username'), $this->_settings['sitename']));

        $this->_view->headerMessage = $this->_('Check out this Listing');
        $this->_view->clearContent()
            ->process(__DIR__ . '/../../../../view/emails/email-friend.phtml');

        return $this;
    }
}