<?php

/**
 *
 * PHP Pro Bid $Id$ Xt48iLrbdOW5acQFK2PWePdkdSJ4mstXreCDfgNf0GY=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * listing search form
 */

namespace Listings\Form;

use Ppb\Model\Elements,
    Ppb\Form\AbstractBaseForm;

class Search extends AbstractBaseForm
{

    /**
     *
     * search elements model
     *
     * @var \Ppb\Model\Elements\Search
     */
    protected $_model;

    /**
     *
     * class constructor
     *
     * @param string|array                $formId         the id of the form, used by the form elements model
     * @param string                      $action         the form's action
     * @param \Ppb\Db\Table\Row\User|null $store          in case we are searching in a store
     * @param \Cube\Db\Select             $listingsSelect listings select object, used for counters display
     */
    public function __construct($formId = null, $action = null, $store = null, $listingsSelect = null)
    {
        parent::__construct($action);

        $this->setTitle('Listings Search');

        if (is_array($formId)) {
            $this->_includedForms = array_merge($this->_includedForms, $formId);
        }
        else if ($formId !== null) {
            array_push($this->_includedForms, $formId);
        }

        $this->setMethod(self::METHOD_GET);
        $this->_model = new Elements\Search($formId);
        $this->_model->setStore($store)
            ->setListingsSelect($listingsSelect);

        $this->addElements(
            $this->_model->getElements());

        $this->addSubmitElement('Search', 'search_submit');

        $this->setPartial(__DIR__ . '/../../../view/forms/search.phtml');
    }

    public function generateBasicForm()
    {
        // temporary
        $this->getElement('search_submit')
            ->clearAttributes()
            ->setAttributes(array(
                'class' => 'btn btn-primary',
            ));


        $this->setPartial(__DIR__ . '/../../../view/forms/basic-search.phtml');

        return $this;
    }

    /**
     *
     * set the data of the submitted form
     * plus add the data in the search model
     *
     * @param array $data form data
     *
     * @return \Listings\Form\Search
     */

    /**
     *
     * @param array $data
     *
     * @return $this
     */
    public function setData(array $data = null)
    {
        $this->_model->setData($data);
        $this->addElements(
            $this->_model->getElements());

        $this->addSubmitElement('Search', 'search_submit');

        parent::setData($data);

        return $this;
    }

}