<?php

/**
 *
 * PHP Pro Bid $Id$ lsJfuIGq2doRnXegjT2K+0Y2Q6BMHAAvwjq4IGDnaA4=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.2
 */
/**
 * listing bid / buy / make offer form
 */

namespace Listings\Form;

use Ppb\Form\AbstractBaseForm,
    Cube\Validate,
    Cube\Controller\Front,
    Ppb\Service\UsersAddressBook,
    Ppb\Db\Table\Row\User as UserModel,
    Ppb\Db\Table\Row\Listing as ListingModel;

class Purchase extends AbstractBaseForm
{

    const BTN_SUBMIT = 'submit_purchase';

    /**
     *
     * submit buttons values
     *
     * @var array
     */
    protected $_buttons = array(
        self::BTN_SUBMIT => 'Proceed',
    );

    /**
     *
     * class constructor
     *
     * @param \Ppb\Db\Table\Row\Listing $listing listing model
     * @param \Ppb\Db\Table\Row\User    $buyer   buyer user model
     * @param string                    $type    the type of form to be created (bid|buy|offer)
     * @param string                    $action  the form's action
     */
    public function __construct(ListingModel $listing, UserModel $buyer, $type, $action = null)
    {
        parent::__construct($action);
        $this->setMethod(self::METHOD_POST);

        $translate = $this->getTranslate();

        $title = null;
        $amountLabel = null;

        switch ($type) {
            case 'bid':
                $title = $translate->_('Confirm Bid');
                $amountLabel = $translate->_('Bid Amount');
                break;
            case 'buy':
                $title = $translate->_('Confirm Purchase');
                break;
            case 'offer':
                $title = $translate->_('Confirm Offer');
                $amountLabel = $translate->_('Offer Amount');
                break;
        }
        $this->setTitle($title);

        if (in_array($type, array('bid', 'offer'))) {
            $amount = $this->createElement('text', 'amount');
            $amount->setLabel($amountLabel)
                ->setAttributes(array(
                    'placeholder' => $listing['currency'],
                    'class'       => 'form-control input-mini',
                ))
                ->addValidator(new Validate\Numeric())
                ->setRequired();


            if ($type == 'bid') {
                $amount->addValidator(
                    new Validate\GreaterThan(array($listing->minimumBid(), true, true)));
            }
            else if ($type == 'offer') {
                $amount->addValidator(
                    new Validate\GreaterThan(array($listing['make_offer_min'], true, true)));
                if ($listing['make_offer_max'] > 0) {
                    $amount->addValidator(
                        new Validate\LessThan(array($listing['make_offer_max'], true)));
                }
            }

            $this->addElement($amount);
        }

        if (in_array($type, array('buy'))) {
            $settings = $this->getSettings();

            if ($settings['enable_shipping']) {
                $usersAddressBook = new UsersAddressBook();
                $multiOptions = $usersAddressBook->getMultiOptions($buyer);

                $shippingAddress = $this->createElement('select', 'shipping_address_id');
                $shippingAddress->setLabel('Select Shipping Address')
                    ->setAttributes(array(
                        'class'    => 'form-control',
                        'onchange' => 'this.form.submit();'
                    ))
                    ->setMultiOptions($multiOptions)
                    ->setRequired();

                $this->addElement($shippingAddress);

                $quantity = Front::getInstance()->getRequest()->getParam('quantity');

                /** @var \Ppb\Form\Element\PostageMethod $postageMethod */
                $postageMethod = $this->createElement('\Ppb\Form\Element\PostageMethod', 'postage_id');
                $postageMethod->setLabel('Select Postage Method')
                    ->setAttributes(array(
                        'class' => 'form-control input-medium'
                    ))
                    ->setShippingModel(array($listing['id'] => $quantity), $buyer['country'], $buyer['zip_code'])
                    ->setRequired();

                $this->addElement($postageMethod);

                if ($listing[\Ppb\Model\Shipping::FLD_INSURANCE] > 0) {
                    $insuranceCheckbox = $this->createElement('checkbox', 'apply_insurance');
                    $insuranceCheckbox->setLabel('Apply Insurance')
                        ->setMultiOptions(
                            array(1 => null));

                    $this->addElement($insuranceCheckbox);
                }
            }

            $quantity = $this->createElement('text', 'quantity');
            $quantity->setLabel('Enter Quantity')
                ->setAttributes(array(
                    'class' => 'form-control input-mini',
                ))
                ->setRequired()
                ->addValidator(
                    new Validate\LessThan(array($listing->getAvailableQuantity(), true)))
                ->addValidator(
                    new Validate\GreaterThan(array(1, true, true)));
            $this->addElement($quantity);

            $voucherCode = $this->createElement('hidden', 'voucher_code');
            $this->addElement($voucherCode);
        }

        $this->addSubmitElement($this->_buttons[self::BTN_SUBMIT], self::BTN_SUBMIT);

        $this->setPartial(__DIR__ . '/../../../view/forms/purchase.phtml');
    }

}