<?php

/**
 *
 * PHP Pro Bid $Id$ 4v3Y9xbOARIg9AJXcNLih6O4LcgfLNsOof9Ohx01hTU=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.3
 */
/**
 * email to friend form
 */

namespace Listings\Form;

use Ppb\Form\AbstractBaseForm,
    Cube\Validate,
    Ppb\Validate\MultipleEmails as MultipleEmailsValidate;

class EmailFriend extends AbstractBaseForm
{

    const BTN_SUBMIT = 'email_friend';

    /**
     *
     * submit buttons values
     *
     * @var array
     */
    protected $_buttons = array(
        self::BTN_SUBMIT => 'Send',
    );

    /**
     *
     * class constructor
     *
     * @param string $action the form's action
     */
    public function __construct($action = null)
    {
        parent::__construct($action);

        $this->setMethod(self::METHOD_POST);

        $translate = $this->getTranslate();

        $email = $this->createElement('textarea', 'emails');
        $email->setLabel('Email Addresses')
            ->setAttributes(array(
                'rows'        => 4,
                'class'       => 'form-control',
                'placeholder' => $translate->_('You can add multiple email addresses, separated by commas.'),
            ))
            ->setRequired()
            ->addValidator(
                new MultipleEmailsValidate());

        $this->addElement($email);

        $settings = $this->getSettings();

        if ($settings['enable_recaptcha'] && $settings['recaptcha_email_friend']) {
            $captcha = new \Ppb\Form\Element\ReCaptcha();
            $captcha->setLabel('Captcha Code');

            $this->addElement($captcha);
        }

        $content = $this->createElement('textarea', 'message');
        $content->setLabel('Message')
            ->setAttributes(array(
                'rows'        => 4,
                'class'       => 'form-control',
                'placeholder' => $translate->_('Enter an optional message to be included in the email.'),
            ))
            ->setRequired()
            ->addValidator(
                new Validate\NoHtml());

        $this->addElement($content);

        $this->addSubmitElement($this->_buttons[self::BTN_SUBMIT], self::BTN_SUBMIT);

        $this->setPartial(__DIR__ . '/../../../view/forms/email-friend.phtml');
    }

}