<?php

/**
 *
 * PHP Pro Bid $Id$ Xt48iLrbdOW5acQFK2PWePdkdSJ4mstXreCDfgNf0GY=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */

namespace Listings\Controller;

use Ppb\Controller\Action\AbstractAction,
    Cube\Controller\Front,
    Ppb\Service,
    Listings\Form;

class Search extends AbstractAction
{

    /**
     *
     * view object
     *
     * @var \Cube\View
     */
    protected $_view;

    /**
     *
     * search form action
     *
     * @var string
     */
    protected $_formAction;

    public function init()
    {
        $this->_view = Front::getInstance()->getBootstrap()->getResource('view');
        $this->_formAction = $this->_view->url(
            array('module' => 'listings', 'controller' => 'browse', 'action' => 'index'));
    }

    public function Advanced()
    {
        $form = new Form\Search(array('advanced', 'item'), $this->_formAction);

        return array(
            'form'     => $form,
            'headline' => $form->getTitle(),
        );
    }

    public function Basic()
    {
        $storeId = $this->getRequest()->getParam('store_id');
        $listingsSelect = $this->getRequest()->getParam('listings_select');
        $store = null;

        if ($storeId) {
            $usersService = new Service\Users();
            $store = $usersService->findBy('id', $storeId);
        }

        $form = new Form\Search(array('basic', 'item'), null, $store, $listingsSelect);
        $form->setData(
            $this->getRequest()->getParams())
            ->generateBasicForm();

        return array(
            'form' => $form,
        );
    }

    public function Stores()
    {
        $form = new Form\Search(array('stores'));
        $form->setData(
            $this->getRequest()->getParams())
            ->generateBasicForm();

        return array(
            'form' => $form,
        );
    }

}

