<?php

/**
 *
 * PHP Pro Bid $Id$ bor6Ivek71AFA55f5JCic69cm2axa+Sal5J8NOB5kLM=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * installation form
 */

namespace Install\Form;

use Install\Model\Elements,
    Ppb\Form\AbstractBaseForm,
    Cube\Validate;

class Install extends AbstractBaseForm
{

    /**
     *
     * install elements model
     *
     * @var \Install\Model\Elements\Install
     */
    protected $_model;

    public function __construct($formId = null, $action = null)
    {
        parent::__construct($action);

        $this->setTitle('Installation');

        if (is_array($formId)) {
            $this->_includedForms = array_merge($this->_includedForms, $formId);
        }
        else if ($formId !== null) {
            array_push($this->_includedForms, $formId);
        }

        $this->setMethod(self::METHOD_POST);

        $this->_model = new Elements\Install($formId);

        $this->addElements(
            $this->_model->getElements());

        if (count($this->getElements()) > 0) {
            $this->addSubmitElement();
            $this->getElement('submit')
                ->addAttribute('class', 'btn-loading-modal');
            $this->setPartial(__DIR__ . '/../../../view/forms/generic-horizontal.phtml');
        }
    }

    /**
     *
     * override setData() method
     *
     * @param array $data
     *
     * @return array
     */
    public function setData(array $data = null)
    {
        $this->_model->setData($data);
        $this->addElements(
            $this->_model->getElements());

        if (count($this->getElements()) > 0) {
            $this->addSubmitElement();
            $this->getElement('submit')
                ->addAttribute('class', 'btn-loading-modal');
        }

        $translate = $this->getTranslate();

        if ($this->hasElement('admin_password')) {
            $passwordConfirmValidator = new Validate\Identical();
            $passwordConfirmValidator->setStrict()
                ->setVariableName($translate->_('Confirm Password'));

            if (isset($data['admin_password_confirm'])) {
                $passwordConfirmValidator->setVariableValue($data['admin_password_confirm']);
            }

            $password = $this->getElement('admin_password')
                ->addValidator($passwordConfirmValidator);

            $this->addElement($password);
        }

        parent::setData($data);

        return $this;
    }

}

