<?php

/**
 *
 * PHP Pro Bid $Id$ lIk8zTeNz2b3bCS1uFwIztpXL1HyFnpYEAwOja9soVc=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.3
 */
/**
 * install controller
 */

namespace Install\Controller;

use Ppb\Controller\Action\AbstractAction,
    Cube\Controller\Front,
    Cube\Controller\Request,
    Cube\Authentication\Authentication,
    Ppb\Authentication\Adapter,
    Install\Form,
    Install\Model,
    Ppb\Db\Table,
    Ppb\Service,
    Cube\Session;

class Index extends AbstractAction
{

    /**
     * installer session namespace
     */
    const SESSION_NAMESPACE = 'PpbInstaller';
    const SESSION_SECRET = 'PpbInstallerSecret';

    /**
     *
     * sql files to be parsed on a new installation
     *
     * @var array
     */
    protected $_sqlFiles = array(
        '7.0' => 'stock-7.0.sql',
        '7.1' => '7.1-update.sql',
        '7.2' => '7.2-update.sql',
        '7.3' => '7.3-update.sql',
    );

    /**
     *
     * check if we have a successful database connection
     *
     * @var bool
     */
    protected $_connected;

    public function init()
    {
        $this->_connected = Front::getInstance()->getBootstrap()->getResource('connected');

        $installMessagesSession = new Session(array(
            'namespace' => self::SESSION_NAMESPACE,
            'secret'    => self::SESSION_SECRET,
        ));
        $this->_flashMessenger->setSession($installMessagesSession);
    }

    public function Index()
    {
        $formId = ($this->_connected) ? 'upgraded' : 'install';

        $form = new Form\Install($formId);

        if ($this->getRequest()->isPost()) {
            $form->setData($this->getRequest()->getParams());

            if ($form->isValid() === true) {
                if (!$this->_connected) {
                    // we have a fresh installation
                    // edit global.config.php - add db connection data and session namespace/secret
                    $globalConfigPath = __DIR__ . '/../../../../../config/global.config.php';
                    $adminModuleConfigPath = __DIR__ . '/../../../../Admin/config/module.config.php';

                    $dbHost = $this->getRequest()->getParam('db_host');
                    $dbName = $this->getRequest()->getParam('db_name');
                    $dbUsername = $this->getRequest()->getParam('db_username');
                    $dbPassword = $this->getRequest()->getParam('db_password');
                    $tablesPrefix = $this->getRequest()->getParam('tables_prefix');

                    $sessionNamespace = $this->getRequest()->getParam('session_namespace');
                    $sessionSecret = $this->getRequest()->getParam('session_secret');

                    $adminEmail = $this->getRequest()->getParam('admin_email');

                    $string = file_get_contents($globalConfigPath);
                    $string = str_replace(
                        array(
                            '%DB_HOST%',
                            '%DB_NAME%',
                            '%DB_USERNAME%',
                            '%DB_PASSWORD%',
                            '%TABLES_PREFIX%',
                            '%SESSION_NAMESPACE%',
                            '%SESSION_SECRET%',
                        ),
                        array(
                            $dbHost,
                            $dbName,
                            $dbUsername,
                            $dbPassword,
                            $tablesPrefix,
                            $sessionNamespace,
                            $sessionSecret
                        ), $string);
                    file_put_contents($globalConfigPath, $string);

                    // edit admin/module.config.php - add session namespace/secret
                    $string = file_get_contents($adminModuleConfigPath);
                    $string = str_replace(
                        array(
                            '%ADMIN_SESSION_NAMESPACE%',
                            '%ADMIN_SESSION_SECRET%'
                        ),
                        array(
                            'Admin' . $sessionNamespace,
                            'Admin' . $sessionSecret,
                        ), $string);
                    file_put_contents($adminModuleConfigPath, $string);

                    $parser = new Model\Parser();

                    $parser->addPlaceholder('{%TABLE_PREFIX%}', $tablesPrefix)
                        ->addPlaceholder('%SITE_NAME%', $this->getRequest()->getParam('site_name'))
                        ->addPlaceholder('%SITE_PATH%', $this->getRequest()->getParam('site_path'))
                        ->addPlaceholder('%ADMIN_EMAIL%', $adminEmail)
                        ->addPlaceholder('%MOD_REWRITE_URLS%', ((\Ppb\Utility::checkModRewrite()) ? '1' : '0'))
                        ->setDbCredentials(array(
                            'host'     => $dbHost,
                            'dbname'   => $dbName,
                            'username' => $dbUsername,
                            'password' => $dbPassword,
                            'prefix'   => $tablesPrefix,
                        ))
                        ->stopOnError();

                    $result = true;
                    foreach ($this->_sqlFiles as $fileName) {
                        $parser->setFilePath(__DIR__ . '/../../../../../SQL/' . $fileName);
                        $result = $parser->parse(true);

                        if (!$result) {
                            $this->_flashMessenger->setMessage(array(
                                'msg'   => $parser->getErrors(),
                                'class' => 'alert-danger',
                            ));

                            $this->_helper->redirector()->redirect('failed');
                        }
                    }

                    if ($result) {
                        $usersTable = new Table\Users();
                        $usersTable->setAdapter($parser->getAdapter())
                            ->setPrefix($tablesPrefix);

                        // create admin user
                        $usersService = new Service\Users();
                        $salt = date('U', time());
                        $adminPassword = $usersService->hashPassword($this->getRequest()->getParam('admin_password'), $salt);

                        $usersTable->insert(array(
                            'username'       => $this->getRequest()->getParam('admin_username'),
                            'password'       => $adminPassword,
                            'salt'           => $salt,
                            'email'          => $adminEmail,
                            'active'         => 1,
                            'approved'       => 1,
                            'mail_activated' => 1,
                            'payment_status' => 'confirmed',
                            'role'           => Service\Users::ADMIN_ROLE_PRIMARY,
                        ));

                        // populate tables if required by admin
                        if ($this->getRequest()->getParam('populate_tables')) {
                            $parser->setFilePath(__DIR__ . '/../../../../../SQL/7.0-sample-data.sql')
                                ->clearPlaceholders()
                                ->addPlaceholder('{%TABLE_PREFIX%}', $tablesPrefix)
                                ->parse(true);
                        }

                        $this->_helper->redirector()->redirect('success');
                    }
                }
                else {
                    $this->_helper->redirector()->redirect('failed');
                }
            }
            else {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $form->getMessages(),
                    'class' => 'alert-danger',
                ));
            }
        }

        return array(
            'form'      => $form,
            'messages'  => $this->_flashMessenger->getMessages(),
            'connected' => $this->_connected,
        );
    }


    public function Success()
    {
        return array(
            'messages' => $this->_flashMessenger->getMessages(),
        );
    }

    public function Failed()
    {
        return array(
            'messages' => $this->_flashMessenger->getMessages(),
        );
    }

    public function Importer()
    {
        $form = null;
        $submitted = false;
        if (!$this->_connected) {
            $this->_flashMessenger->setMessage(array(
                'msg'   => $this->_('Fatal Error: Could not connect to the database.'),
                'class' => 'alert-danger',
            ));
        }
        else {
            $form = new Form\Install('v6_importer');

            $submitted = false;

            if ($this->getRequest()->isPost()) {
                $form->setData($this->getRequest()->getParams());

                if ($form->isValid() === true) {
                    // first we check for valid admin login details
                    $adapter = new Adapter(array(
                        'username' => $this->getRequest()->getParam('licensing_username'),
                        'password' => $this->getRequest()->getParam('licensing_password'),
                    ));

                    $authentication = Authentication::getInstance();

                    $authentication->authenticate($adapter);

                    if ($authentication->hasIdentity()) {
                        $submitted = true;

                        $parser = new Model\Parser();
                        $parser->setFilePath(__DIR__ . '/../../../../../SQL/6.x-importer.sql');

                        $oldTablesPrefix = $this->getRequest()->getParam('v6_tables_prefix');

                        $options = Front::getInstance()->getOptions();
                        /** @var \Cube\Db\Adapter\PDO\Mysql $dbAdapter */
                        $dbAdapter = Front::getInstance()->getBootstrap()->getResource('db');
                        $adapterConfig = $dbAdapter->getConfig();
                        $parser->setAdapter($dbAdapter)
                            ->addPlaceholder('{%NEW_PREFIX%}', $adapterConfig['prefix'])
                            ->addPlaceholder('{%OLD_PREFIX%}', $oldTablesPrefix)
                            ->stopOnError();

                        $result = $parser->parse(true);

                        if (!$result) {
                            $this->_flashMessenger->setMessage(array(
                                'msg'   => $parser->getErrors(),
                                'class' => 'alert-danger',
                            ));

                            $this->_helper->redirector()->redirect('failed');
                        }
                        else {
                            /* post import operations */
                            // convert custom_fields_data box_value fields to serialized data.
                            $customFieldsService = new Service\CustomFields();
                            $customFields = $customFieldsService->fetchAll(
                                $customFieldsService->getTable()->select()
                                    ->where('LOCATE("[]", multiOptions) > 0')
                            );

                            /** @var \Cube\Db\Table\Row $customField */
                            foreach ($customFields as $customField) {
                                $array = explode('[]', $customField['multiOptions']);
                                $multiOptions = array(
                                    'key'   => $array,
                                    'value' => $array,
                                );
                                $customField->save(array(
                                    'multiOptions' => serialize($multiOptions),
                                ));
                            }

                            // update payment_gateways table - id, site_fees and direct_payment fields
                            $statement = $dbAdapter->query("SELECT * FROM `" . $oldTablesPrefix . "payment_gateways`");
                            $rows = $statement->fetchAll(\Cube\Db::FETCH_ASSOC);

                            $paymentGatewaysTable = new Table\PaymentGateways();
                            foreach ($rows as $row) {
                                $pgName = $row['name'];
                                switch ($row['name']) {
                                    case 'Worldpay':
                                        $pgName = 'WorldPay';
                                        break;
                                    case '2Checkout':
                                        $pgName = 'TCheckout';
                                        break;
                                    case 'Protx':
                                        $pgName = 'SagePay';
                                        break;
                                    case 'Authorize.net':
                                        $pgName = 'AuthorizeNet';
                                        break;
                                    case 'Test Mode':
                                        $pgName = 'PaymentSimulator';
                                        break;
                                    case 'Amazon':
                                        $pgName = 'AmazonPayments';
                                        break;
                                    case 'Moneybookers':
                                        $pgName = 'Skrill';
                                        break;
                                }

                                $paymentGatewaysTable->update(array(
                                    'id'             => $row['pg_id'],
                                    'site_fees'      => $row['checked'],
                                    'direct_payment' => $row['dp_enabled'],
                                ), "name='{$pgName}'");
                            }

                            // update direct_payment methods

                            $this->_flashMessenger->setMessage(array(
                                'msg'   => $this->_('The import has been completed successfully.'),
                                'class' => 'alert-success',
                            ));
                        }

                        $form->clearElements();
                        $authentication->clearIdentity();
                    }
                    else {
                        $this->_flashMessenger->setMessage(array(
                            'msg'   => $this->_('The authentication has failed.'),
                            'class' => 'alert-danger',
                        ));
                    }

                }
                else {
                    $this->_flashMessenger->setMessage(array(
                        'msg'   => $form->getMessages(),
                        'class' => 'alert-danger',
                    ));
                }
            }
        }

        return array(
            'form'      => $form,
            'messages'  => $this->_flashMessenger->getMessages(),
            'submitted' => $submitted,
            'connected' => $this->_connected,
        );
    }

    public function Upgrade()
    {
        $form = null;
        $submitted = false;
        if (!$this->_connected) {
            $this->_flashMessenger->setMessage(array(
                'msg'   => $this->_('Fatal Error: Could not connect to the database.'),
                'class' => 'alert-danger',
            ));
        }
        else {
            $form = new Form\Install('upgrade');

            $submitted = false;

            if ($this->getRequest()->isPost()) {
                $form->setData($this->getRequest()->getParams());

                if ($form->isValid() === true) {
                    // first we check for valid admin login details
                    $adapter = new Adapter(array(
                        'username' => $this->getRequest()->getParam('licensing_username'),
                        'password' => $this->getRequest()->getParam('licensing_password'),
                    ));

                    $authentication = Authentication::getInstance();

                    $authentication->authenticate($adapter);

                    if ($authentication->hasIdentity()) {
                        // first delete all files from the /cache/ folder
                        $cacheFiles = glob(__DIR__ . '/../../../../../cache/*');
                        foreach ($cacheFiles as $cacheFile) {
                            if (is_file($cacheFile))
                                @unlink($cacheFile);
                        }

                        $submitted = true;

                        $parser = new Model\Parser();

                        $options = Front::getInstance()->getOptions();
                        /** @var \Cube\Db\Adapter\PDO\Mysql $dbAdapter */
                        $dbAdapter = Front::getInstance()->getBootstrap()->getResource('db');
                        $adapterConfig = $dbAdapter->getConfig();
                        $parser->setAdapter($dbAdapter)
                            ->addPlaceholder('{%TABLE_PREFIX%}', $adapterConfig['prefix'])
                            ->addPlaceholder('%MOD_REWRITE_URLS%', ((\Ppb\Utility::checkModRewrite()) ? '1' : '0'))
                            ->stopOnError();

                        $result = true;
                        $currentVersion = doubleval($this->getRequest()->getParam('current_version'));

                        foreach ($this->_sqlFiles as $version => $fileName) {
                            $version = doubleval($version);
                            if ($version > $currentVersion) {

                                $parser->setFilePath(__DIR__ . '/../../../../../SQL/' . $fileName);
                                $result = $parser->parse(true);

                                if (!$result) {
                                    $this->_flashMessenger->setMessage(array(
                                        'msg'   => $parser->getErrors(),
                                        'class' => 'alert-danger',
                                    ));

                                    $this->_helper->redirector()->redirect('failed');
                                }
                            }
                        }

                        if ($result) {
                            $this->_helper->redirector()->redirect('success');
                        }

                        $form->clearElements();
                        $authentication->clearIdentity();
                    }
                    else {
                        $this->_flashMessenger->setMessage(array(
                            'msg'   => $this->_('The authentication has failed.'),
                            'class' => 'alert-danger',
                        ));
                    }

                }
                else {
                    $this->_flashMessenger->setMessage(array(
                        'msg'   => $form->getMessages(),
                        'class' => 'alert-danger',
                    ));
                }
            }
        }

        return array(
            'form'      => $form,
            'messages'  => $this->_flashMessenger->getMessages(),
            'submitted' => $submitted,
            'connected' => $this->_connected,
        );
    }

    public function ActivateLicense()
    {
        if ($this->getRequest()->getParam('option') == 'invalid-license') {
            $this->_flashMessenger->setMessage(array(
                'msg'   => $this->_('The license key for this domain is invalid.'),
                'class' => 'alert-danger',
            ));
        }

        $form = null;
        $submitted = false;
        if (!$this->_connected) {
            $this->_flashMessenger->setMessage(array(
                'msg'   => $this->_('Fatal Error: Could not connect to the database.'),
                'class' => 'alert-danger',
            ));
        }
        else {
            $form = new Form\Install('licensing');

            $submitted = false;

            if ($this->getRequest()->isPost()) {
                $form->setData($this->getRequest()->getParams());

                if ($form->isValid() === true) {
                    // first we check for valid admin login details
                    $adapter = new Adapter(array(
                        'username' => $this->getRequest()->getParam('licensing_username'),
                        'password' => $this->getRequest()->getParam('licensing_password'),
                    ));

                    $authentication = Authentication::getInstance();

                    $authentication->authenticate($adapter);

                    if ($authentication->hasIdentity()) {
                        $submitted = true;

                        $settingsService = new Service\Settings();

                        $settingsService->save(array(
                            'license_key'       => urlencode($this->getRequest()->getParam('license_key')),
                        ));

                        $this->_flashMessenger->setMessage(array(
                            'msg'   => $this->_('The license activation key has been saved.'),
                            'class' => 'alert-success',
                        ));

                        $form->clearElements();
                        $authentication->clearIdentity();
                    }
                    else {
                        $this->_flashMessenger->setMessage(array(
                            'msg'   => $this->_('The authentication has failed.'),
                            'class' => 'alert-danger',
                        ));
                    }

                }
                else {
                    $this->_flashMessenger->setMessage(array(
                        'msg'   => $form->getMessages(),
                        'class' => 'alert-danger',
                    ));
                }
            }
        }

        return array(
            'form'      => $form,
            'messages'  => $this->_flashMessenger->getMessages(),
            'submitted' => $submitted,
            'connected' => $this->_connected,
        );
    }
}
