<?php

/**
 * install module bootstrap
 */
/**
 * @version 7.3
 */

namespace Install;

use Cube\Application\Bootstrap as ApplicationBootstrap,
    Ppb\View\Helper,
    Ppb\Service;
use Cube\Controller\Front;

class Bootstrap extends ApplicationBootstrap
{
    protected $_settings;

    protected $_connected = false;

    protected function _initConnected()
    {
        $this->bootstrap('db');
        $db = $this->getResource('db');

        if ($db instanceof \Cube\Db\Adapter\AbstractAdapter) {
            /** @var \Cube\Db\Adapter\PDO\Mysql $db */
            try {
                $this->_connected = $db->canConnect();
            }
            catch (\Exception $e) {

            }
        }

        return $this->_connected;
    }

    protected function _initSettings()
    {
        if ($this->_connected === true) {
            $settingsService = new Service\Settings();

            try {
                $this->_settings = $settingsService->get();
            }
            catch (\Exception $e) {
            }
        }

        return $this->_settings;
    }

    protected function _initControllerPlugins()
    {
        $front = $this->getResource('FrontController');

        $front->registerPlugin(
            new Controller\Plugin\InstallerEnabled());
    }

    protected function _initModRewrite()
    {
        $modRewriteSetting = (isset($this->_settings['mod_rewrite_urls'])) ? $this->_settings['mod_rewrite_urls'] : 0;

        if (!\Ppb\Utility::checkModRewrite() && !$modRewriteSetting) {
            \Ppb\Utility::activateStandardRouter();
        }
    }

    protected function _initViewHelpers()
    {
        $dateFormat = '%m/%d/%Y %H:%M:%S';
        $sitePath = (!empty($this->_settings['site_path'])) ? $this->_settings['site_path'] : '/';

        $view = $this->getResource('view');
        $view->setHelper('request', new Helper\Request())
            ->setHelper('url', new Helper\Url($sitePath))
            ->setHelper('date', new Helper\Date($dateFormat))
            ->setHelper('liveTime', new Helper\LiveTime($dateFormat))
            ->setHelper('thumbnail', new Helper\Thumbnail());

        $view->script()
            ->addHeaderCode('<!--[if lt IE 9]> <script type="text/javascript" src="' . $view->baseUrl . '/js/html5shiv.min.js"></script><![endif]-->')
            ->addHeaderCode('<link href="' . $view->baseUrl . '/css/bootstrap.min.css" rel="stylesheet" type="text/css">')
            ->addHeaderCode('<link href="' . $view->baseUrl . '/css/font-awesome.min.css" media="screen" rel="stylesheet" type="text/css">')
            ->addHeaderCode('<link href="' . $view->baseUrl . '/js/colorbox/colorbox.css" media="screen" rel="stylesheet" type="text/css">')
            ->addHeaderCode('<link href="' . $view->baseUrl . '/css/style.css" rel="stylesheet" type="text/css">')
            ->addHeaderCode('<!--[if lt IE 9]><link href="' . $view->baseUrl . '/css/style.ie.css" media="all" rel="stylesheet" type="text/css"><![endif]-->')
            ->addHeaderCode('<link href="' . $view->baseUrl . '/img/favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon">');

        /* add javascript plugins */
        $view->script()->addBodyCode('<script type="text/javascript" src="' . $view->baseUrl . '/js/jquery.min.js"></script>')
            ->addBodyCode('<script type="text/javascript" src="' . $view->baseUrl . '/js/bootstrap.min.js"></script>')
            ->addBodyCode('<script type="text/javascript" src="' . $view->baseUrl . '/js/masonry.pkgd.min.js"></script>')
            ->addBodyCode('<script type="text/javascript" src="' . $view->baseUrl . '/js/bootbox.min.js"></script>')
            ->addBodyCode('<script type="text/javascript" src="' . $view->baseUrl . '/js/colorbox/jquery.colorbox-min.js"></script>')
            ->addBodyCode('<script type="text/javascript" src="' . $view->baseUrl . '/js/cookie.js"></script>')
            ->addBodyCode('<script type="text/javascript" src="' . $view->baseUrl . '/js/global.js"></script>')
            ->addBodyCode('<!--[if lt IE 9]> <script type="text/javascript" src="' . $view->baseUrl . '/js/respond.min.js"></script><![endif]-->')
            ->addBodyCode('<!--[if lt IE 10]> <script type="text/javascript" src="' . $view->baseUrl . '/js/placeholders.jquery.min.js"></script><![endif]-->');
    }
}