<?php

/**
 *
 * PHP Pro Bid $Id$ BdTR2lBjeLHamxGVaLK73aS7em4epwZ2/8j3E2ckRgo=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.3
 */
/**
 * custom pages controller
 * - will not be available with direct routing
 */

namespace App\Controller;

use Ppb\Controller\Action\AbstractAction,
    Cube\Controller\Front,
    Ppb\Service,
    App\Form;

class Pages extends AbstractAction
{

    public function Contact()
    {
        $form = new Form\Contact();

        if (count($this->_user) > 0) {
            $fullName = Front::getInstance()->getBootstrap()->getResource('view')->userDetails($this->_user)->displayFullName();
            $form->setData(array(
                'name'  => $fullName,
                'email' => $this->_user->getData('email'),
            ));
        }


        if ($form->isPost(
            $this->getRequest())
        ) {
            $form->setData($this->getRequest()->getParams());

            if ($form->isValid() === true) {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $this->_('The email has been sent successfully.'),
                    'class' => 'alert-success',
                ));

                $form->clearElements();

                $mail = new \Admin\Model\Mail\Admin();
                $mail->contact($this->getRequest())->send();
            }
            else {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $form->getMessages(),
                    'class' => 'alert-danger',
                ));
            }
        }

        return array(
            'form'     => $form,
            'messages' => $this->_flashMessenger->getMessages(),
        );
    }

    public function SiteFees()
    {
        $categoryId = $this->getRequest()->getParam('category_id');
        $tab = $this->getRequest()->getParam('tab', 'general');

        $translate = $this->getTranslate();

        $tabs['general'] = array(
            'name' => $this->_('General'),
        );

        if ($this->_settings['enable_auctions'] || $this->_settings['enable_products']) {
            $tabs['listings'] = array(
                'name' => $this->_('Listings'),
            );
        }

        if ($this->_settings['enable_stores']) {
            $tabs['stores'] = array(
                'name' => $this->_('Stores'),
            );
        }

        $selectFeesCategories = "parent_id IS NULL AND custom_fees='1'";

        $storesSubscriptions = null;
        $fees = array();

        switch ($tab) {
            case 'listings':
                $services = array(
                    'ListingSetup',
                    'SaleTransaction',
                );

                $selectFeesCategories .= " AND enable_auctions='1'";
                
                foreach ($services as $name) {
                    $serviceName = '\\Ppb\\Service\\Fees\\' . $name;
                    /** @var \Ppb\Service\Fees $service */
                    $service = new $serviceName();

                    $select = $service->getTable()->select()
                        ->where('name IN (?)', array_keys($service->getFees()))
                        ->where('type = ?', 'default')
                        ->order(array('name ASC', 'tier_from ASC'));

                    if ($categoryId) {
                        $select->where('category_id = ?', $categoryId);
                    }
                    else {
                        $select->where('category_id is null');
                    }

                    $rowset = $service->fetchAll($select);

                    $feesArray = $service->getFees();
                    foreach ($rowset as $row) {
                        $row['desc'] = $feesArray[$row['name']];
                        $fees[] = $row;
                    }
                }

                break;
            case 'stores':
                $storesSubscriptionsService = new Service\Table\StoresSubscriptions();
                $storesSubscriptions = $storesSubscriptionsService->getMultiOptions();
                break;

            default:
                $services = array(
                    'UserSignup',
                    'UserVerification',
                );

                foreach ($services as $name) {
                    $serviceName = '\\Ppb\\Service\\Fees\\' . $name;
                    /** @var \Ppb\Service\Fees $service */
                    $service = new $serviceName();

                    $rowset = $service->fetchAll(
                        $service->getTable()->select()
                            ->where('category_id is null')
                            ->where('name IN (?)', array_keys($service->getFees())));

                    $feesArray = $service->getFees();
                    foreach ($rowset as $row) {
                        $row['desc'] = $feesArray[$row['name']];
                        $fees[] = $row;
                    }
                }

                break;
        }

        $categoriesService = new Service\Table\Relational\Categories();
        $categoriesMultiOptions = $categoriesService->getMultiOptions($selectFeesCategories, null,
            $translate->_('Default'));

        return array(
            'categoryId'             => $categoryId,
            'tabs'                   => $tabs,
            'tab'                    => $tab,
            'categoriesMultiOptions' => $categoriesMultiOptions,
            'fees'                   => $fees,
            'storesSubscriptions'    => $storesSubscriptions,
        );
    }

}

