<?php

/**
 *
 * PHP Pro Bid $Id$ iG6pvnlG5iJaVxPdR0BwMuItUFASdiCsqQgb9h1fhos=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.3
 */
/**
 * async controller
 */

namespace App\Controller;

use Ppb\Controller\Action\AbstractAction,
    Cube\View,
    Cube\Db\Table\AbstractTable,
    Cube\Navigation\Page\AbstractPage,
    Ppb\Service;

class Async extends AbstractAction
{

    /**
     *
     * view object
     *
     * @var \Cube\View
     */
    protected $_view;

    public function init()
    {
        $this->_view = new View();
    }

    public function SelectCategory()
    {
        $id = $this->getRequest()->getParam('id', 0);
        $option = $this->getRequest()->getParam('option');
        $storeId = $this->getRequest()->getParam('storeId');
        $categoriesDisplay = $this->getRequest()->getParam('categoriesDisplay');

        $refresh = false;

        $categoriesService = new Service\Table\Relational\Categories();

        $categoriesSelect = $categoriesService->getTable()
            ->select()
            ->order(array('parent_id ASC', 'order_id ASC', 'name ASC'));

        $categoriesTableColumns = array_values($categoriesService->getTable()->info(AbstractTable::COLS));

        if (in_array($categoriesDisplay, $categoriesTableColumns)) {
            $categoriesSelect->where("$categoriesDisplay = ?", 1);
        }
        else {
            $categoriesSelect->where('enable_auctions = ?', 1);
        }

        if ($storeId) {
            $categoriesSelect->where("user_id is null OR user_id = '{$storeId}'");

            $usersService = new Service\Users();
            $storeCategories = $usersService->findBy('id', $storeId)
                ->getStoreSettings('store_categories');

            if ($storeCategories) {
                $categoriesSelect->where("parent_id is not null OR id IN (" . implode(', ', $storeCategories) . ")")
                    ->order('parent_id ASC');
            }
        }
        else {
            $categoriesSelect->where('user_id is null');
        }

        $categoriesService->setData($categoriesSelect);

        $boxes = null;

        $current = $categoriesService->getData()->findOneBy('id', $id);

        if ($option == 'change' || !$id || ($current instanceof AbstractPage && $current->hasChildren())) {
            $array = $categoriesService->getCategoriesSelectData($id);

            foreach ((array)$array as $row) {
                $boxes .= $this->_view->formElement('select', 'category_data', $row['selected'])
                    ->setMultiOptions($row['values'])
                    ->setAttributes(array(
                        'size'  => '10',
                        'class' => 'form-control input-medium category-selector'))
                    ->render();
            }
        }

        $translate = $this->getTranslate();

        $breadcrumbs = $categoriesService->getBreadcrumbs($id);

        $categoryName = implode(' :: ', array_values($breadcrumbs));

        if (empty($boxes)) {
            // TODO: this snippet might need modification as at the moment is pretty basic
            // check for refresh data
            // 1. if we have category specific custom fields
            $customFieldsService = new Service\CustomFields();
            $customFields = $customFieldsService->fetchAll(
                $customFieldsService->getTable()->select()
                    ->where('type = ?', 'item')
                    ->where('active = ?', 1)
                    ->where("category_ids != ?", '')
            );

            if (count($customFields) > 0) {
                $refresh = true;
            }
            else {
                // 2. if we have category specific fees
                $customFeesCategories = $categoriesService->fetchAll(
                    $categoriesService->getTable()->select()
                        ->where('parent_id is null')
                        ->where('custom_fees = ?', 1)
                );
                if (count($customFeesCategories) > 0) {
                    $refresh = true;
                }
            }
        }
        $data = array(
            'category_id'   => $id,
            'category_name' => ($categoryName) ? $categoryName : $translate->_('Select Category'),
            'output'        => $boxes,
            'refresh'       => $refresh,
        );

        $this->getResponse()->setHeader('Content-Type: application/json');

        $this->_view->setContent(
            json_encode($data));

        return $this->_view;
    }

    public function SelectLocation()
    {
        // action body
        $id = $this->getRequest()->getParam('id');
        $name = $this->getRequest()->getParam('name', 'state');

        $locationsService = new Service\Table\Relational\Locations();
        $locations = $locationsService->getMultiOptions($id);

        $element = null;
        if (count($locations) > 0) {
            $element = $this->_view->formElement('select', $name)
                ->setMultiOptions($locations)
                ->setAttributes(array(
                    'class' => 'form-control input-medium',
                ))
                ->render();
        }
        else {
            $element = $this->_view->formElement('text', $name)
                ->setAttributes(array(
                    'class' => 'form-control input-medium',
                ))
                ->render();
        }

        $this->getResponse()->setHeader('Content-Type: text/plain');

        $this->_view->setContent($element);

        return $this->_view;
    }

}

