<?php

/**
 *
 * Cube Framework $Id$ 92VLJk4IA99WCFgLcWJSuQ6U/KL6asHqsFEh3vX9etk=
 *
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 *
 * @version     1.0
 */
/**
 * admin login form
 */

namespace Admin\Form;

use Cube\Form;

class Login extends Form
{

    public function __construct($action = null)
    {
        parent::__construct($action);
        $this->setMethod(self::METHOD_POST);

        $translate = $this->getTranslate();

        /* username field */
        $username = $this->createElement('text', 'username');
        $username->setLabel('Username');
        $username->setAttributes(array(
            'class'       => 'form-control',
            'placeholder' => $translate->_('Username'),
        ));
        $username->setRequired();
        $this->addElement($username);

        /* password field */
        $password = $this->createElement('password', 'password');
        $password->setLabel('Password');
        $password->setAttributes(array(
            'class'       => 'form-control',
            'placeholder' => $translate->_('Password'),
        ));
        $this->addElement($password);

//        /* captcha code */
//        $captcha = $this->createElement('captcha', 'adminCaptcha');
//        $captcha->setRequired();
//        $captcha->setAttributes(array(
//            'placeholder' => 'Enter Code',
//        ));
//        $this->addElement($captcha);

        /* submit button */
        $submit = $this->createElement('submit', 'submit');
        $submit->setAttributes(array(
            'class' => 'btn btn-primary btn-lg',
        ));
        $submit->setValue('Proceed');
        $this->addElement($submit);

        $this->setPartial(__DIR__ . '/../../../view/forms/login.phtml');
    }

}

