<?php

/*
 * This is a PHP library that handles calling reCAPTCHA.
 *    - Documentation and latest version
 *          http://recaptcha.net/plugins/php/
 *    - Get a reCAPTCHA API Key
 *          https://www.google.com/recaptcha/admin/create
 *    - Discussion group
 *          http://groups.google.com/group/recaptcha
 *
 * Copyright (c) 2007 reCAPTCHA -- http://recaptcha.net
 * AUTHORS:
 *   Mike Crawford
 *   Ben Maurer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/**
 *
 * PHP Pro Bid $Id$ Okjo7B6DTKc42de3diATnvedOi6wEkF9TkwZQ1GGlM0=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.2
 */
/**
 * reCAPTCHA validator for PHP Pro Bid V7
 *
 */

namespace Ppb\Validate;

use Cube\Validate\AbstractValidate,
    Cube\Controller\Front;

class ReCaptcha extends AbstractValidate
{

    /**
     * reCAPTCHA verify server
     *
     * @var string
     */
    const VERIFY_SERVER = 'www.google.com';

    /**
     *
     * validation error message
     *
     * @var string
     */
    protected $_message = "The reCAPTCHA code is incorrect.";

    /**
     *
     * Calls an HTTP POST function to verify if the user's guess was correct
     *
     * @return bool return true if the validation is successful
     */
    public function isValid()
    {
        $settings = Front::getInstance()->getBootstrap()->getResource('settings');
        $request = Front::getInstance()->getRequest();

        $challenge = $request->getParam('recaptcha_challenge_field');
        $response = $request->getParam('recaptcha_response_field');

        if ($challenge == null || strlen($challenge) == 0 || $response == null || strlen($response) == 0) {
            return false;
        }

        $response = $this->_post(self::VERIFY_SERVER, "/recaptcha/api/verify",
            array(
                'privatekey' => $settings['recaptcha_private_key'],
                'remoteip'   => $_SERVER['REMOTE_ADDR'],
                'challenge'  => $challenge,
                'response'   => $response
            )
        );

        $answers = explode("\n", $response[1]);

        if (trim($answers[0]) == 'true') {
            return true;
        }

//        $this->_message = str_replace('%response%', $answers[1], $this->_message);
        return false;
    }


    /**
     * Submits an HTTP POST to a reCAPTCHA server
     *
     * @param string $host
     * @param string $path
     * @param array  $data
     * @param int    $port
     *
     * @return array response
     */
    protected function _post($host, $path, $data, $port = 80)
    {

        $req = $this->_encode($data);

        $http_request = "POST $path HTTP/1.0\r\n";
        $http_request .= "Host: $host\r\n";
        $http_request .= "Content-Type: application/x-www-form-urlencoded;\r\n";
        $http_request .= "Content-Length: " . strlen($req) . "\r\n";
        $http_request .= "User-Agent: reCAPTCHA/PHP\r\n";
        $http_request .= "\r\n";
        $http_request .= $req;

        $response = '';
        if (false == ($fs = @fsockopen($host, $port, $errno, $errstr, 10))) {
            die ('Could not open socket');
        }

        fwrite($fs, $http_request);

        while (!feof($fs))
            $response .= fgets($fs, 1160); // One TCP-IP packet
        fclose($fs);
        $response = explode("\r\n\r\n", $response, 2);

        return $response;
    }

    /**
     * Encodes the given data into a query string format
     *
     * @param $data - array of string elements to be encoded
     *
     * @return string - encoded request
     */
    protected function _encode($data)
    {
        $req = "";
        foreach ($data as $key => $value)
            $req .= $key . '=' . urlencode(stripslashes($value)) . '&';

        // Cut the last '&'
        $req = substr($req, 0, strlen($req) - 1);

        return $req;
    }

    protected function _recaptcha_aes_pad($val)
    {
        $block_size = 16;
        $numpad = $block_size - (strlen($val) % $block_size);

        return str_pad($val, strlen($val) + $numpad, chr($numpad));
    }

    /* Mailhide related code */

    protected function _recaptcha_aes_encrypt($val, $ky)
    {
        if (!function_exists("mcrypt_encrypt")) {
            die ("To use reCAPTCHA Mailhide, you need to have the mcrypt php module installed.");
        }
        $mode = MCRYPT_MODE_CBC;
        $enc = MCRYPT_RIJNDAEL_128;
        $val = $this->_recaptcha_aes_pad($val);

        return mcrypt_encrypt($enc, $ky, $val, $mode, "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0");
    }





}

