<?php

/**
 *
 * PHP Pro Bid $Id$ 9JId2EF8597kSHfr/wgqq+gCVK3sKYL0van7REbU3piHEDoEBvCyaAPy7eVUOOx20C+rWKYuS99KuqkzWGf0tA==
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * newsletters recipients table service class
 */


namespace Ppb\Service;

use Ppb\Db\Table\NewslettersRecipients as NewslettersRecipientsTable;

class NewslettersRecipients extends AbstractService
{

    /**
     *
     * class constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->setTable(
            new NewslettersRecipientsTable());
    }

    /**
     *
     * delete multiple recipients from the table
     *
     * @param array $ids the ids of the rows to be deleted
     * @return int     returns the number of affected rows
     */
    public function delete(array $ids)
    {
        $adapter = $this->_table->getAdapter();

        $where[] = $adapter->quoteInto('id IN (?)', $ids);

        return $this->_table->delete($where);
    }
}

