<?php

/**
 *
 * PHP Pro Bid $Id$ mqmV17tALSQdPUlFW7XX9Uxc/oaTKvwMZ6zdNAUmY1Q=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * custom fields data table service class
 *
 * IMPORTANT:
 * search serialized custom fields:
 * select * from probid_custom_fields_data where value REGEXP '"x"|"y"|"z"';
 * (maybe we will serialize all saved data)
 */

namespace Ppb\Service;

use Ppb\Db\Table;

class CustomFieldsData extends AbstractService
{

    /**
     *
     * class constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->setTable(
            new Table\CustomFieldsData());
    }

    /**
     *
     * save data in the table
     *
     * @param string|array $value   custom field value (if array it will be serialized before saving)
     * @param string       $type    custom field data type (item, user etc)
     * @param integer      $fieldId custom_fields table id
     * @param integer      $ownerId id of the column for which this data belongs to
     * @return \Ppb\Service\CustomFieldsData
     */
    public function save($value, $type, $fieldId, $ownerId)
    {
        if (is_array($value)) {
            $value = serialize($value);
        }

        $data = array(
            'value'    => $value,
            'field_id' => $fieldId,
            'owner_id' => $ownerId,
            'type'     => $type,
        );

        $select = $this->_table->select()
                ->where("field_id = ?", $fieldId)
                ->where("owner_id = ?", $ownerId)
                ->where("type = ?", $type);

        $row = $this->_table->fetchRow($select);


        if (count($row) > 0) {
            $this->_table->update($data, "id='{$row['id']}'");
        }
        else {
            $this->_table->insert($data);
        }

        return $this;
    }

    /**
     *
     * delete data from the table
     *
     * @param string  $type    custom field type
     * @param integer $ownerId the id of record that the custom field data belongs to
     * @return integer     returns the number of affected rows
     */
    public function delete($type, $ownerId)
    {
        $adapter = $this->_table->getAdapter();

        $where = $adapter->quoteInto('type = ? AND ', $type) .
                 $adapter->quoteInto('owner_id = ?', $ownerId);

        return $this->_table->delete($where);
    }

}

