<?php

/*
 * This is a PHP library that handles calling reCAPTCHA.
 *    - Documentation and latest version
 *          http://recaptcha.net/plugins/php/
 *    - Get a reCAPTCHA API Key
 *          https://www.google.com/recaptcha/admin/create
 *    - Discussion group
 *          http://groups.google.com/group/recaptcha
 *
 * Copyright (c) 2007 reCAPTCHA -- http://recaptcha.net
 * AUTHORS:
 *   Mike Crawford
 *   Ben Maurer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/**
 *
 * PHP Pro Bid $Id$ Okjo7B6DTKc42de3diATnvedOi6wEkF9TkwZQ1GGlM0=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.3
 */
/**
 * reCAPTCHA form element for PHP Pro Bid V7
 *
 */

namespace Ppb\Form\Element;

use Cube\Form\Element,
    Cube\Controller\Front,
    Ppb\Validate;

class ReCaptcha extends Element
{
    /**
     * reCAPTCHA API server
     */
    const SERVER = '//www.google.com/recaptcha/api';

    /**
     * element theme
     */
    const THEME = 'clean';

    /**
     *
     * type of element - override the variable from the parent class
     *
     * @var string
     */
    protected $_element = 'ReCaptcha';

    /**
     *
     * class constructor
     *
     * the recaptcha validator will automatically be added to this form element
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($this->_element, $name);

        $this->_baseUrl = Front::getInstance()->getRequest()->getBaseUrl();

        $this->addValidator(
            new Validate\ReCaptcha()
        );
    }

    /**
     *
     * render the recaptcha form element
     *
     * @return string
     */
    public function render()
    {

        $settings = Front::getInstance()->getBootstrap()->getResource('settings');

        return '
            <script type="text/javascript">
                var RecaptchaOptions = {
                    theme : "' . self::THEME . '",
                    custom_theme_widget: "recaptcha_widget"
                };
            </script>
            <script type="text/javascript" src="' . self::SERVER . '/challenge?k=' . $settings['recaptcha_public_key'] . '"></script>
            <noscript>
                <iframe src="' . self::SERVER . '/noscript?k=' . $settings['recaptcha_public_key'] . '" height="300" width="500" frameborder="0"></iframe><br/>
                <textarea name="recaptcha_challenge_field" rows="3" cols="40"></textarea>
                <input type="hidden" name="recaptcha_response_field" value="manual_challenge"/>
            </noscript>';
    }


}

