<?php

/**
 *
 * PHP Pro Bid $Id$ xdn8qYjXi7tRXrjS5GsGbMNcv+fXk3rer9WhIz/YDb4=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * range form element
 *
 * TODO: optionally the jqueryui slider plugin can be added at a later date
 */

namespace Ppb\Form\Element;

use Cube\Form\Element;

class Range extends Element
{

    const RANGE_FROM = 'from';
    const RANGE_TO = 'to';

    /**
     *
     * type of element - override the variable from the parent class
     *
     * @var string
     */
    protected $_element = 'range';

    /**
     *
     * class constructor
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct('text', $name);
        $this->setMultiple(true);
    }


    /**
     *
     * return the value(s) of the element, either the element's data or default value(s)
     *
     * @param string $key
     *
     * @return mixed
     */
    public function getValue($key = null)
    {
        $value = parent::getValue();

        if ($key !== null) {
            if (array_key_exists($key, (array)$value)) {
                return $value[$key];
            }
            else {
                return null;
            }
        }

        return $value;
    }

    /**
     *
     * render composite element
     *
     * @return string
     */
    public function render()
    {
        return $this->getPrefix() . ' '
        . '<input type="' . $this->_type . '" '
        . 'name="' . $this->_name . '[' . self::RANGE_FROM . ']' . '" '
        . $this->renderAttributes()
        . 'value="' . $this->getValue(self::RANGE_FROM) . '" '
        . $this->_endTag . ' '
        . $this->getSuffix()
        . ' - '
        . $this->getPrefix() . ' '
        . '<input type="' . $this->_type . '" '
        . 'name="' . $this->_name . '[' . self::RANGE_TO . ']' . '" '
        . $this->renderAttributes()
        . 'value="' . $this->getValue(self::RANGE_TO) . '" '
        . $this->_endTag . ' '
        . $this->getSuffix();
    }

}

