<?php

/**
 *
 * PHP Pro Bid $Id$ hwIL65z0hDumiQIN69QOKD7AfNOsyNYNY9fuc94K92U=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * listing quantity form element
 * includes a checkbox for when we have an unlimited quantity
 */

namespace Ppb\Form\Element;

use Cube\Form\Element;

class Quantity extends Element
{

    const UNLIMITED = '_unlimited';

    /**
     *
     * type of element - override the variable from the parent class
     *
     * @var string
     */
    protected $_element = 'quantity';

    /**
     *
     * unlimited checkbox flag
     *
     * @var bool
     */
    protected $_unlimited = true;

    /**
     *
     * class constructor
     * TODO: complete this element or cancel its usage!
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct('text', $name);

        $this->setBodyCode(
            "<script type=\"text/javascript\">" . "\n"
            . " $(document).ready(function() { " . "\n"
            . "     $('input[name=\"" . $this->_name . self::UNLIMITED . "\"]').click(function() { " . "\n"
            . "         alert('HI'); " . "\n"
            . "     }); " . "\n"
            . "</script>");
    }

    /**
     *
     * set unlimited flag
     *
     * @param boolean $unlimited
     * @return $this
     */
    public function setUnlimited($unlimited)
    {
        $this->_unlimited = $unlimited;

        return $this;
    }

    /**
     *
     * get unlimited flag
     *
     * @return boolean
     */
    public function getUnlimited()
    {
        return $this->_unlimited;
    }


    /**
     *
     * render composite element
     *
     * @return string
     */
    public function render()
    {
        return parent::render()
               . (($this->getUnlimited()) ? '<label class="checkbox"><input type="checkbox" name="' . $this->_name . self::UNLIMITED . '"> Unlimited</label>' : '');

//        return $this->getPrefix() . ' '
//               . '<input type="' . $this->_type . '" '
//               . 'name="' . $this->_name . '[' . self::RANGE_FROM . ']' . '" '
//               . $this->renderAttributes()
//               . 'value="' . $this->getValue(self::RANGE_FROM) . '" '
//               . $this->_endTag . ' '
//               . $this->getSuffix()
//               . ' - '
//               . $this->getPrefix() . ' '
//               . '<input type="' . $this->_type . '" '
//               . 'name="' . $this->_name . '[' . self::RANGE_TO . ']' . '" '
//               . $this->renderAttributes()
//               . 'value="' . $this->getValue(self::RANGE_TO) . '" '
//               . $this->_endTag . ' '
//               . $this->getSuffix();
    }

}

