<?php

/**
 *
 * PHP Pro Bid $Id$ V1LW7kEqqygPdGR+n8tqoNIUFMT1OrOk0msDNZHYJGw=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * date custom form element
 *
 * creates an element of type date with the datepicker jquery ui component enabled
 */

namespace Ppb\Form\Element;

use Cube\Form\Element;

class Date extends Element
{

    const ELEMENT_CLASS = 'element-date';
    const YEAR_RANGE = '1900:2013';
    /**
     *
     * type of element - override the variable from the parent class
     *
     * @var string
     */
    protected $_element = 'text';

    /**
     *
     * base url of the application
     *
     * @var string
     */
    protected $_baseUrl;

    /**
     *
     * class constructor
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($this->_element, $name);

        $this->setBodyCode(
            "<script type=\"text/javascript\">" . "\n"
            . " $(document).ready(function() { " . "\n"
            . "     $('." . self::ELEMENT_CLASS . "').datepicker({ " . "\n"
            . "         dateFormat: \"yy-mm-dd\", " . "\n"
            . "         changeMonth: true, " . "\n"
            . "         changeYear: true, " . "\n"
            . "         yearRange: \"" . self::YEAR_RANGE . "\", " . "\n"
            . "         maxDate: new Date() " . "\n"
            . "     }); " . "\n"
            . " }); " . "\n"
            . "</script>");

        $this->addAttribute('class', self::ELEMENT_CLASS)
            ->addAttribute('readonly', 'readonly');
    }

}

