<?php

/**
 *
 * PHP Pro Bid $Id$ V+LUyv4XF/phuwUp0JrThB9PLOppitVBrlRWswiKr3o=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * accounting table rowset class
 */

namespace Ppb\Db\Table\Rowset;

abstract class AbstractAccounting extends AbstractRowset
{

    /**
     *
     * calculate the amount w/o tax for the selected rowset
     *
     * @return float
     */
    public function amountNoTax()
    {
        $amount = 0;

        /** @var \Ppb\Db\Table\Row\AbstractAccounting $row */
        foreach ($this->_rows as $row) {
            $amount += $row->amountNoTax();
        }

        return $amount;
    }

    /**
     *
     * calculate the total amount for the selected rowset
     *
     * @return float
     */
    public function totalAmount()
    {
        $amount = 0;

        /** @var \Ppb\Db\Table\Row\AbstractAccounting $row */
        foreach ($this->_rows as $row) {
            $amount += $row->totalAmount();
        }

        return $amount;
    }
    /**
     *
     * calculate the tax amount for the selected rowset
     *
     * @return float
     */
    public function taxAmount()
    {
        return $this->totalAmount() - $this->amountNoTax();
    }

}

