<?php

/**
 *
 * PHP Pro Bid $Id$ V+LUyv4XF/phuwUp0JrThB9PLOppitVBrlRWswiKr3o=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.1
 */
/**
 * abstract accounting/transactions table row object model
 */

namespace Ppb\Db\Table\Row;

abstract class AbstractAccounting extends AbstractRow
{

    /**
     *
     * accounting/transactions row invoice details link
     *
     * @return array
     */
    public function link()
    {
        $array = array(
            'action' => 'view-invoice',
        );

        $array['type'] = ($this->getData('transaction_type') == 'receipt') ? 'transactions' : 'accounting';

        if ($this->getData('listing_id')) {
            $array['listing_id'] = $this->getData('listing_id');
        }
        else {
            $array['id'] = $this->getData('id');
        }

        return $array;
    }

    /**
     *
     * only the admin and the owner can view the row
     *
     * @return bool
     */
    public function canView()
    {
        $user = $this->getUser();

        if ($user->getData('id') == $this->getData('user_id') || $user->getData('role') == 'Admin') {
            return true;
        }

        return false;
    }

    /**
     *
     * return the amount without tax
     *
     * @return float
     */
    public function amountNoTax()
    {
        $amount = $this->getData('amount');

        return round($amount - ($amount * $this->getData('tax_rate') / 100), 2);
    }

    /**
     *
     * return the tax amount
     *
     * @return float
     */

    public function taxAmount()
    {
        return $this->getData('amount') - $this->amountNoTax();
    }

    /**
     *
     * return total amount
     *
     * @return float
     */
    public function totalAmount()
    {
        return $this->getData('amount');
    }

    /**
     *
     * return the name of the transaction row for display purposes
     *
     * @return string
     */
    public function displayName()
    {
        $name = \Ppb\Utility::unserialize($this->getData('name'));

        if (is_array($name)) {
            $translate = $this->getTranslate();
            $string = (null !== $translate) ? $translate->_($name['string']) : $name['string'];

            return vsprintf($string, $name['args']);
        }

        return $name;
    }

    abstract public function caption();
}

