<?php

/**
 * 
 * Cube Framework $Id$ 8V3q0ym10AlFadJ6GOSmaXDLjS79pjFKAvuS1nhmrBs= 
 * 
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 * 
 * @version     1.0
 */
/**
 * translate view helper
 */

namespace Cube\View\Helper;

use Cube\Translate as TranslateObject,
    Cube\Translate\Adapter\AbstractAdapter as TranslateAdapter,
    Cube\Controller\Front;

class Translate extends AbstractHelper
{

    /**
     *
     * translate adapter used by the view helper
     * 
     * @var \Cube\Translate\Adapter\AbstractAdapter
     */
    protected $_adapter;

    public function getAdapter()
    {
        if ($this->_adapter === null) {
            $translate = Front::getInstance()->getBootstrap()->getResource('translate');
            $this->setAdapter($translate);
        }
        return $this->_adapter;
    }

    public function setAdapter($adapter)
    {
        if ($adapter instanceof TranslateAdapter) {
            $this->_adapter = $adapter;
        }
        else if ($adapter instanceof TranslateObject) {
            $this->_adapter = $adapter->getAdapter();
        }
        else {
            throw new \InvalidArgumentException("The translation adapter set in the view helper must be of type \Cube\Translate or \Cube\Translate\Adapter.");
        }

        return $this;
    }

    public function getLocale()
    {
        return $this->getAdapter()->getLocale();
    }

    public function setLocale($locale)
    {
        $this->getAdapter()->setLocale($locale);

        return $this;
    }

    public function translate($message = null)
    {
//        if ($message === null) {
//            return $this;
//        }

        if (!$message) {
            return '';
        }

        return $this->getAdapter()->translate($message);
    }

}

