<?php

/**
 *
 * Cube Framework $Id$ tDsei4rcEapBm3Gh91ks86NySuUhYYoSU1aA3aSo9q0=
 *
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 *
 * @version     1.0
 */
/**
 * partial view helper
 * TODO: the handling of theme specific view partials needs some work
 */

namespace Cube\View\Helper;

class Partial extends AbstractHelper
{

    /**
     *
     * data to be used by the partial
     *
     * @var \Cube\Paginator
     */
    protected $_data = array();

    /**
     *
     * the view partial to be used to display the menu
     *
     * @var string
     */
    protected $_partial;

    /**
     *
     * path where to search for view partial files
     *
     * @var string
     */
    protected $_path;

    /**
     *
     * get the view file
     *
     * @return string
     * @throws \InvalidArgumentException
     */
    public function getPartial()
    {
        if (!file_exists($this->_partial)) {
            throw new \InvalidArgumentException(
                sprintf("Could not find the view file (%s).", $this->_partial));
        }

        return $this->_partial;
    }

    /**
     *
     * set the view file
     *
     * @param string $file
     * @return \Cube\View\Helper\Navigation
     * @throws \InvalidArgumentException
     */
    public function setPartial($file)
    {
        $exists = false;

        if (file_exists($file)) {
            $this->_partial = $file;
            $exists = true;
        }
        else {
            $viewFile = $this->getPath() . DIRECTORY_SEPARATOR . $file;
            $themeViewFile = $this->getView()->getLayoutsPath() . DIRECTORY_SEPARATOR . $file;

            if (file_exists($themeViewFile)) {
                $this->_partial = $themeViewFile;
                $exists = true;
            }
            else if (file_exists($viewFile)) {
                $this->_partial = $viewFile;
                $exists = true;
            }
        }

        if (!$exists) {
            throw new \InvalidArgumentException(
                sprintf("Could not find the view partial (%s).", $file));
        }

        return $this;
    }

    /**
     *
     * get view partials path
     *
     * @return string
     */
    public function getPath()
    {
        if (empty($this->_path)) {
            $this->_path = $this->getView()->getViewsPath();
        }

        return $this->_path;
    }

    /**
     *
     * set view partials path
     *
     * @param string $path
     * @return \Cube\View\Helper\Partial
     * @throws \InvalidArgumentException
     */
    public function setPath($path)
    {
        if (!is_dir($path)) {
            throw new \InvalidArgumentException(
                sprintf("The view partials path (%s) does not exist.", $path));
        }

        $this->_path = $path;

        return $this;
    }

    /**
     *
     * process view partial and return output
     *
     * @param string $partial view partial name/path
     * @param array  $data    input data to be handled by the view partial
     * @param string $path    view partials path
     * @return string|$this           partial output
     */
    public function partial($partial = null, array $data = null, $path = null)
    {
        if ($path !== null) {
            $this->setPath($path);
        }

        if ($partial !== null) {
            $this->setPartial($partial);
        }
        else {
            return $this;
        }

        $view = clone $this->getView();

        $view->clearVariables();

        if ($data !== null) {
            $view->setVariables($data);
        }

        return $view->process(
            $this->getPartial(), true);
    }

}

