<?php

/**
 * 
 * Cube Framework $Id$ 7FN88kDAYR7U+xrLsygWyo6TRv+Yf0Oi0iK3jJhgwpg= 
 * 
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 * 
 * @version     1.0
 */
/**
 * pagination view helper
 */

namespace Cube\View\Helper;

use Cube\Paginator;

class Pagination extends AbstractHelper
{

    /**
     *
     * paginator object
     * 
     * @var \Cube\Paginator
     */
    protected $_paginator;

    /**
     *
     * the view partial to be used to display the menu
     * 
     * @var string
     */
    protected $_partial;

    /**
     *
     * path where to search for navigation view partials
     * 
     * @var string
     */
    protected $_path;

    /**
     * 
     * get the paginator object
     * 
     * @return \Cube\Paginator
     * @throws \InvalidArgumentException
     */
    public function getPaginator()
    {
        if (!($this->_paginator instanceof Paginator)) {
            throw new \InvalidArgumentException(
                    sprintf("'%s' must be of type \Cube\Paginator.", $this->_paginator));
        }

        return $this->_paginator;
    }

    /**
     * 
     * set the paginator object
     * 
     * @param \Cube\Paginator $paginator
     * @return \Cube\View\Helper\Pagination
     * @throws \InvalidArgumentException
     */
    public function setPaginator($paginator)
    {
        if ($paginator instanceof Paginator) {
            $this->_paginator = $paginator;
        }
        else {
            throw new \InvalidArgumentException(
                    sprintf("'%s' must be of type \Cube\Paginator.", $this->_paginator));
        }

        return $this;
    }

    /**
     * 
     * get the view file
     * 
     * @return string
     * @throws \InvalidArgumentException
     */
    public function getPartial()
    {
        if (!file_exists($this->_partial)) {
            throw new \InvalidArgumentException(
                    sprintf("Could not find the pagination view file (%s).", $this->_partial));
        }

        return $this->_partial;
    }

    /**
     * 
     * set the view file
     * 
     * @param string $file
     * @return \Cube\View\Helper\Navigation
     * @throws \InvalidArgumentException
     */
    public function setPartial($file)
    {
        $exists = false;

        if (file_exists($file)) {
            $this->_partial = $file;
            $exists = true;
        }
        else {
            $viewFile = $this->getPath() . DIRECTORY_SEPARATOR . $file;

            if (file_exists($viewFile)) {
                $this->_partial = $viewFile;
                $exists = true;
            }
        }

        if (!$exists) {
            throw new \InvalidArgumentException(
                    sprintf("Could not find the pagination view partial (%s).", $file));
        }

        return $this;
    }

    /**
     * 
     * get paginator partials path
     * 
     * @return string
     */
    public function getPath()
    {
        if (empty($this->_path)) {
            $this->_path = $this->getView()->getViewsPath();
        }

        return $this->_path;
    }

    /**
     * 
     * set paginator partials path
     * 
     * @param string $path
     * @return \Cube\View\Helper\Pagination
     * @throws \InvalidArgumentException
     */
    public function setPath($path)
    {
        if (!is_dir($path)) {
            throw new \InvalidArgumentException(
                    sprintf("The navigation files path (%s) does not exist.", $path));
        }

        $this->_path = $path;

        return $this;
    }

    public function pagination(Paginator $paginator = null, $scrollingStyle = null, $partial = null)
    {
        if ($paginator === null) {
            return $this;
        }
        else {
            $this->setPaginator($paginator);
        }

        if ($scrollingStyle !== null) {
            $this->getPaginator()->setScrollingStyle($scrollingStyle);
        }

        if ($partial !== null) {
            $this->setPartial($partial);
        }

        $view = $this->getView();
        $view->paginator = $paginator;
        
        $view->setVariables(
                get_object_vars($paginator->getPages()));
        
        return $view->process(
                        $this->getPartial(), true);
    }

}

