<?php

/**
 * 
 * Cube Framework $Id$ lm4DokrHCSo8A6r6p5kyYEZeoSO4junSwP7IC3QG+ik= 
 * 
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 * 
 * @version     1.0
 */
/**
 * displays a field's value if the field exists or false otherwise
 * also display array and serialized fields, and glue them by a selected implode separator
 */

namespace Cube\View\Helper;

class FieldDisplay extends AbstractHelper
{

    const DISPLAY_FALSE = 'n/a';
    const IMPLODE_GLUE = ', ';

    public function fieldDisplay($field, $true = null, $false = null, $glue = null)
    {
        $glue = ($glue !== null) ? (string) $glue : self::IMPLODE_GLUE;
        
        if ($field) {
            if (is_array($field)) {
                return (implode($glue, $field));
            }
            
            if (($array = @unserialize(html_entity_decode($field))) !== false) {
                return implode($glue, $array);
            }

            return ($true === null) ? $field : $true;
        }
        else {
            return ($false === null) ? self::DISPLAY_FALSE : $false;
        }
    }

}

