<?php

/**
 * 
 * Cube Framework $Id$ ZQjP21H9Fc8C6k4sAV7NnPxYyLxrt9rdTfeu6r1AbMk= 
 * 
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 * 
 * @version     1.0
 */
/**
 * phone number validator class
 */

namespace Cube\Validate;

class Phone extends AbstractValidate
{

    protected $_message = "'%s' does not contain a valid phone number.";
    
    /**
     * 
     * checks if the variable contains a valid phone number
     * 
     * @return bool          return true if the validation is successful
     */
    public function isValid()
    {
        $value = str_ireplace(array('+', '-', ' ', '(', ')'), '', $this->_value);
        if (is_numeric($value)) {
            return true;
        }

        return false;
    }

}

