<?php

/**
 *
 * Cube Framework $Id$ BvYJU2oStQ89+Rjbm3DlxZLqWrWNo8Rg56nUpLO4JdM=
 *
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 *
 * @version     1.0
 */
/**
 * array translate adapter
 * will accept arrays as inputs
 */

namespace Cube\Translate\Adapter;

use Cube\Config\AbstractConfig,
    Cube\Locale;

class ArrayAdapter extends AbstractAdapter
{

    public function addTranslation($options = array())
    {
        if (!is_array($options) && !($options instanceof AbstractConfig)) {
            throw new \InvalidArgumentException("The translation object requires an
                array or an object of type \Cube\ConfigAbstract.");
        }
        else {
            if ($options instanceof AbstractConfig) {
                $options = $options->getData();
            }

            $file = (isset($options['file'])) ? $options['file'] : null;
            $locale = (isset($options['locale'])) ? $options['locale'] : null;

            if (file_exists($file) === false) {
                throw new \InvalidArgumentException(
                    sprintf("Add translation method error: The translation file '%s' could not be found.", $file));
            }

            if (Locale::isLocale($locale) === false) {
                throw new \InvalidArgumentException(
                    sprintf("Add translation method error: '%s' is an invalid locale.", $locale));
            }

            $this->_translate[$locale] = include ($file);
        }

        return $this;
    }

} 