<?php

/**
 * 
 * Cube Framework $Id$ DBPX7x6RumnI6N88Q7xE8UknqTnylg/9wjIwptE2auo= 
 * 
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 * 
 * @version     1.0
 */
/**
 * db select pagination adapter
 */

namespace Cube\Paginator\Adapter;

use Cube\Db\Select;

class DbSelect implements AdapterInterface
{

    /**
     *
     * the select object
     * 
     * @var \Cube\Db\Select
     */
    protected $_select;

    /**
     *
     * total number of rows
     * 
     * @var integer 
     */
    protected $_count = null;

    /**
     * 
     * class constructor
     * 
     * @param \Cube\Db\Select $select   the select object
     */
    public function __construct(Select $select)
    {
        $this->_select = $select;
    }

    /**
     * 
     * returns an array of items for the selected page
     *
     * @param  integer $offset              page offset
     * @param  integer $itemCountPerPage    number of items per page
     * @return array
     */
    public function getItems($offset, $itemCountPerPage)
    {
        $this->_select->limit($itemCountPerPage, $offset);

        return $this->_select->query()->fetchAll();
    }

    /**
     * 
     * return the number of rows in the result set
     * TODO:    refactor in case of UNION clause (as the current solution is slower), 
     *          implement in case of DISTINCT and HAVING clauses
     * 
     * @return integer
     */
    public function count()
    {
        if ($this->_count === null) {
            $select = clone $this->_select;

            $union = $select->getPart(Select::UNION);

            if (count($union) > 0) {
                $stmt = $select->query();
                $this->_count = count($stmt->fetchAll());
            }
            else {
                $select->reset(Select::COLUMNS)
                        ->reset(Select::ORDER);

                $select->columns('COUNT(*) AS nb_rows');

                $stmt = $select->query();

                if ($select->getPart(Select::GROUP)) {
                    $this->_count = count($stmt->fetchAll());
                }
                else {
                    $this->_count = (integer) $stmt->fetchColumn('nb_rows');
                }
            }
        }

        return $this->_count;
    }

}

