<?php

/**
 * 
 * Cube Framework $Id$ 4JBchhF7sv4U7ZroQI7DCmqmQ2dnYS14tCv/9vBKYaQ= 
 * 
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 * 
 * @version     1.0
 */
/**
 * textarea form element generator class
 */

namespace Cube\Form\Element;

use Cube\Form\Element;

class Textarea extends Element
{

    /**
     *
     * type of element - override the variable from the parent class
     * 
     * @var string
     */
    protected $_element = 'text';

    /**
     * 
     * class constructor
     * 
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($this->_element, $name);
    }

    /**
     * 
     * render the form element
     * 
     * @return string
     */
    public function render()
    {
        $value = $this->getValue();

        return '<textarea name="' . $this->_name . '" '
                . $this->renderAttributes() . '>'
                . $value
                . '</textarea>';
    }

}

