<?php

/**
 *
 * Cube Framework $Id$ yIc0Sn04rm3Uy+aaHptvhOyClZiWyPayxSMG1wu/nYY=
 *
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 *
 * @version     1.1
 */
/**
 * select form element generator class
 * apply translator to select options
 */

namespace Cube\Form\Element;

use Cube\Form\Element;

class Select extends Element
{

    /**
     *
     * type of element - override the variable from the parent class
     *
     * @var string
     */
    protected $_element = 'select';


    /**
     *
     * class constructor
     *
     * @param string $name
     */
    public function __construct($name)
    {
        parent::__construct($this->_element, $name);
    }

    /**
     *
     * render the form element
     *
     * @return string
     */
    public function render()
    {
        $output = null;
        $brackets = null;
        $value = $this->getValue();

        $translate = $this->getTranslate();

        $multipleAttribute = $this->getAttribute('multiple');

        if ($this->getMultiple() === true) {
            $brackets = $this->getBrackets();

            if (!empty($multipleAttribute)) {
                $output .= '<input type="hidden" name="' . $this->_name . '" value=""'
                    . $this->_endTag;
            }
        }

        $output .= '<select name="' . $this->_name . $brackets . '" '
            . $this->renderAttributes() . '>';

        foreach ((array)$this->_multiOptions as $key => $option) {
            $selected = (in_array($key, (array)$value)) ? ' selected' : '';
            $output .= '<option value="' . $key . '"' . $selected . '>' . $translate->_($option) . '</option>';
        }

        $output .= '</select>';

        return $output;
    }

}

