<?php

/**
 * 
 * Cube Framework $Id$ yyfhqiUOVYn0BOSOu0wfylv3fcFtBAb0IaFhD79KA9U= 
 * 
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 * 
 * @version     1.0
 */
/**
 * response interface
 */

namespace Cube\Controller\Response;

interface ResponseInterface
{

    public function getVersion();

    public function getHeaders();

    /**
     *
     * add single response header
     *
     * @param $header
     * @return $this
     */
    public function addHeader($header);

    public function addHeaders(array $headers);

    public function getBody();

    public function appendBody($body);
    
    public function setRedirect($url, $code = 302);

    public function send();

    /**
     *
     * set response header
     *
     * @param $header
     * @return $this
     */
    public function setHeader($header);

    public function setResponseCode($responseCode);

}

