<?php

/**
 *
 * Cube Framework $Id$ AqKA0HCXSpK6q/lRJu339m6StH5cQOujzJdUTSXd9Wo=
 *
 * @link        http://www.phpprobid.com PHP Pro Bid
 * @copyright   Copyright (c) 2013 - CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     1.2
 */
/**
 * request object - for when mod rewrite is not available
 */

namespace Cube\Controller\Request;

class Standard extends AbstractRequest
{

    const DEFAULT_MODULE = 'App';
    const DEFAULT_CONTROLLER = 'Index';
    const DEFAULT_ACTION = 'Index';

    /**
     *
     * set the request uri and format it so that it can be used by the router
     * (remove the base url of the application from the uri and remove any GET variables as well)
     *
     * @param string $requestUri
     *
     * @return \Cube\Controller\Request\AbstractRequest
     */
    public function setRequestUri($requestUri = null)
    {
        if ($requestUri === null) {
            // we can retrieve more ways if needed
            // we replace the first occurrence of the base url (used if installing the app in a sub-domain)

            if (array_key_exists('REQUEST_URI', $_SERVER)) {
                $uri = $_SERVER['REQUEST_URI'];

                $baseUrl = $this->getBaseUrl();
                if ($baseUrl) {
                    $requestUri = str_ireplace('//', '/',
                        @preg_replace($this->getBaseUrl() . self::URI_DELIMITER, '', $uri, 1));
                }
                else {
                    $requestUri = $uri;
                }
            }
        }

        $this->_requestUri = $requestUri;

        return $this;
    }

    public function getModule()
    {
        if (!$this->_module) {
            $this->setModule(self::DEFAULT_MODULE);
        }

        return $this->_module;
    }

    public function getController()
    {
        if (!$this->_controller) {
            $this->setController(self::DEFAULT_CONTROLLER);
        }

        return $this->_controller;
    }

    public function getAction()
    {
        if (!$this->_action) {
            $this->setAction(self::DEFAULT_ACTION);
        }

        return $this->_action;
    }

}

