<?php

/**
 *
 * Cube Framework $Id$ YIzTQJc6m6HlkIqM51WqJP20OG70RFyAF7okJhW+UPA=
 *
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 *
 * @version     1.0
 */
/**
 * config xml generator class
 */

namespace Cube\Config;

class Xml extends AbstractConfig
{

    /**
     *
     * class constructor
     *
     * load data and set it in the container
     *
     * @param string $data
     * @param string $node
     */
    public function __construct($data = null, $node = null)
    {
        $file = null;

        if (file_exists($data)) {
            $file = $data;
        }

        parent::__construct($file, $node);

        if ($data !== null) {
            $this->setData($data);
        }
    }

    /**
     *
     * convert input into \SimpleXMLElement, then process the xml into an array
     *
     * @param mixed $input the input variable, it can be a path to an xml file, a string in xml format or an object of type \SimpleXMLElement
     * @return \Cube\Config\Xml
     */
    public function setData($input)
    {
        $xml = null;
        if ($input instanceof \SimpleXMLElement) {
            $xml = $input;
        }
        else if (file_exists($input)) {
            $xml = simplexml_load_file($input);
        }
        else {
            $xml = simplexml_load_string($input);
        }

        $this->_data = json_decode(json_encode((array)$xml), 1);

        return $this;
    }


}

