<?php

/**
 * 
 * Cube Framework $Id$ 97zfAl/bLktZxTn6fQTULxONDiFj3c8YfMa2Cj9963M= 
 * 
 * @link        http://codecu.be/framework
 * @copyright   Copyright (c) 2014 CodeCube SRL
 * @license     http://codecu.be/framework/license Commercial License
 * 
 * @version     1.0
 */
/**
 * config object
 */

namespace Cube\Config;

abstract class AbstractConfig
{

    /**
     *
     * the data that the config object holds
     * 
     * @var mixed 
     */
    protected $_data;

    /**
     *
     * the file from which to retrieve the config data
     * 
     * @var string
     */
    protected $_file;

    /**
     *
     * a node of the config array
     * 
     * @var string
     */
    protected $_node;

    /**
     * 
     * class constructor
     * accepts a file, the location of the config file, and a node, in case we want to only hold a 
     * part of the configuration array in the config object
     * 
     * @param string $file
     * @param string $node
     */
    public function __construct($file = null, $node = null)
    {
        if ($file !== null) {
            $this->setFile($file);
        }

        $this->setNode($node);
    }

    /**
     * 
     * get the data held in the config container as an array
     * if a node is not found, return an empty array rather than the whole data array
     * 
     * @param string $node
     * @return array
     */
    public function getData($node = null)
    {
        if ($node !== null) {
            $this->setNode($node);
        }

        if ($this->_node !== null) {

            $iterator = new \RecursiveIteratorIterator(
                            new \RecursiveArrayIterator($this->_data),
                            \RecursiveIteratorIterator::SELF_FIRST);


            foreach ($iterator as $key => $array) {
                if ($key == $this->_node) {
                    return $array;
                }
            }
            
            return array();
        }

        return (array) $this->_data;
    }

    /**
     * 
     * set the config object data
     * 
     * @param mixed $data
     * @return \Cube\Config\AbstractConfig
     */
    public function setData($data)
    {
        $this->_data = $data;

        return $this;
    }

    /**
     * 
     * return the name of the file that created the config object
     * 
     * @return string
     */
    public function getFile()
    {
        return $this->_file;
    }

    /**
     * 
     * set the file from which to create the config object
     * 
     * @param string $file
     * @return \Cube\Config\AbstractConfig
     * @throws \InvalidArgumentException
     */
    public function setFile($file)
    {
        if (file_exists($file)) {
            $this->_file = $file;
        }
        else {
            throw new \InvalidArgumentException(sprintf("The file (%s) could not be loaded.", $file));
        }

        return $this;
    }

    /**
     * 
     * get the node name
     * 
     * @return string
     */
    public function getNode()
    {
        return $this->_node;
    }

    /**
     * 
     * set the node for the config array
     * 
     * @param string $node
     */
    public function setNode($node)
    {
        $this->_node = $node;
    }

}

