﻿
-- phpMyAdmin SQL Dump
-- version 4.2.2
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Jan 11, 2015 at 03:54 PM
-- Server version: 5.5.32
-- PHP Version: 5.4.16



--
-- Database: `api_freelance`
--

-- --------------------------------------------------------

--
-- Table structure for table `fx_account_details`
--
DROP TABLE IF EXISTS `fx_account_details`;

CREATE TABLE `fx_account_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `fullname` varchar(160) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(64) COLLATE utf8_unicode_ci DEFAULT '-',
  `phone` varchar(32) COLLATE utf8_unicode_ci DEFAULT '-',
  `mobile` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `skype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(40) COLLATE utf8_unicode_ci DEFAULT 'english',
  `locale` varchar(100) COLLATE utf8_unicode_ci DEFAULT 'en_US',
  `department` int(11) DEFAULT '0',
  `avatar` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'default_avatar.jpg',
  `use_gravatar` enum('Y','N') COLLATE utf8_unicode_ci DEFAULT 'Y',
  `as_company` enum('false','true') COLLATE utf8_unicode_ci DEFAULT 'false',
  `allowed_modules` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO fx_account_details (`id`, `user_id`, `fullname`, `company`, `city`, `country`, `address`, `phone`, `mobile`, `skype`, `language`, `locale`, `department`, `avatar`, `use_gravatar`, `as_company`, `allowed_modules`) VALUES (1, 1, 'John Doe', '-', '', 'Australia', '41 Charles St, Melbourne', '', NULL, NULL, 'english', 'en-US', 0, 'default_avatar.jpg', 'Y', 'false', NULL);


#
# TABLE STRUCTURE FOR: fx_activities
#

DROP TABLE IF EXISTS fx_activities;

CREATE TABLE `fx_activities` (
  `activity_id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `module` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module_field_id` int(11) DEFAULT NULL,
  `activity` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value1` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value2` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `activity_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `icon` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'fa-coffee',
  `deleted` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`activity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_api_keys
#

DROP TABLE IF EXISTS fx_api_keys;

CREATE TABLE `fx_api_keys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `api_key` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `level` int(2) NOT NULL,
  `ignore_limits` tinyint(1) NOT NULL DEFAULT '0',
  `is_private_key` tinyint(1) NOT NULL DEFAULT '0',
  `ip_addresses` text COLLATE utf8_unicode_ci,
  `date_created` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_api_logs
#

DROP TABLE IF EXISTS fx_api_logs;

CREATE TABLE `fx_api_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `method` varchar(6) COLLATE utf8_unicode_ci NOT NULL,
  `params` text COLLATE utf8_unicode_ci,
  `api_key` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `ip_address` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  `rtime` float DEFAULT NULL,
  `authorized` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_assign_projects
#

DROP TABLE IF EXISTS fx_assign_projects;

CREATE TABLE `fx_assign_projects` (
  `a_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `assigned_user` int(11) NOT NULL,
  `project_assigned` int(11) NOT NULL,
  `assign_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`a_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_assign_tasks
#

DROP TABLE IF EXISTS fx_assign_tasks;

CREATE TABLE `fx_assign_tasks` (
  `a_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `assigned_user` int(11) NOT NULL,
  `project_assigned` int(11) NOT NULL,
  `task_assigned` int(11) NOT NULL,
  `assign_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`a_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_bug_comments
#

DROP TABLE IF EXISTS fx_bug_comments;

CREATE TABLE `fx_bug_comments` (
  `c_id` int(11) NOT NULL AUTO_INCREMENT,
  `bug_id` int(11) NOT NULL,
  `comment_by` int(11) NOT NULL,
  `comment` text COLLATE utf8_unicode_ci,
  `date_commented` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`c_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_bug_files
#

DROP TABLE IF EXISTS fx_bug_files;

CREATE TABLE `fx_bug_files` (
  `file_id` int(11) NOT NULL AUTO_INCREMENT,
  `bug` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `file_name` text COLLATE utf8_unicode_ci,
  `file_ext` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `size` int(5) DEFAULT NULL,
  `is_image` int(2) DEFAULT NULL,
  `image_width` int(5) DEFAULT NULL,
  `image_height` int(5) DEFAULT NULL,
  `original_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uploaded_by` int(11) NOT NULL,
  `date_posted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_bugs
#

DROP TABLE IF EXISTS fx_bugs;

CREATE TABLE `fx_bugs` (
  `bug_id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_ref` int(11) DEFAULT NULL,
  `project` int(11) DEFAULT NULL,
  `reporter` int(11) DEFAULT NULL,
  `assigned_to` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bug_status` enum('Unconfirmed','Confirmed','In Progress','Resolved','Verified') COLLATE utf8_unicode_ci DEFAULT 'Unconfirmed',
  `issue_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reproducibility` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `severity` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `priority` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bug_description` text COLLATE utf8_unicode_ci,
  `reported_on` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modified` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bug_id`),
  UNIQUE KEY `issue_ref` (`issue_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_captcha
#

DROP TABLE IF EXISTS fx_captcha;

CREATE TABLE `fx_captcha` (
  `captcha_id` bigint(13) unsigned NOT NULL AUTO_INCREMENT,
  `captcha_time` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(16) COLLATE utf8_unicode_ci DEFAULT '0',
  `word` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`captcha_id`),
  KEY `word` (`word`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_comment_replies
#

DROP TABLE IF EXISTS fx_comment_replies;

CREATE TABLE `fx_comment_replies` (
  `reply_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_comment` int(11) DEFAULT NULL,
  `reply_msg` text COLLATE utf8_unicode_ci,
  `replied_by` int(11) DEFAULT NULL,
  `del` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `date_posted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`reply_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_comments
#

DROP TABLE IF EXISTS fx_comments;

CREATE TABLE `fx_comments` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `project` int(11) NOT NULL,
  `posted_by` int(11) NOT NULL,
  `message` text COLLATE utf8_unicode_ci,
  `date_posted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  PRIMARY KEY (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_companies
#

DROP TABLE IF EXISTS fx_companies;

CREATE TABLE `fx_companies` (
  `co_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `company_ref` int(32) DEFAULT NULL,
  `company_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `primary_contact` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_email` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_website` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_phone` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_mobile` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_fax` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `VAT` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `hosting_company` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hostname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `port` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `account_password` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `account_username` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'USD',
  `account_holder` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `account` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `iban` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bank` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bic` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sortcode` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `skype` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `linkedin` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `facebook` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `twitter` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`co_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_config
#

DROP TABLE IF EXISTS fx_config;

CREATE TABLE `fx_config` (
  `config_key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`config_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO fx_config (`config_key`, `value`) VALUES ('2checkout_private_key', '0EFBDF4-8FEB-43D9-E12-B8ED88F810FB');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('2checkout_publishable_key', '33198C3-BD30-4EC4-70F-DC2329B39C1A');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('2checkout_seller_id', '91265175');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('allowed_files', 'gif|png|jpeg|jpg|pdf|doc|txt|docx|xls|zip|rar|xls|mp4');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('allow_client_registration', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('automatic_email_on_recur', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('beta_updates', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('build', '50716');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('button_color', 'primary');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('captcha_registration', 'FALSE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('client_create_project', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_address', '4146 Golden Hickory Woods');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_city', 'Glass Hill, Sydney');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_country', 'Australia');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_domain', 'http://example.com');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_email', 'wm@gitbench.com');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_legal_name', 'Gitbench');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_logo', 'logo.png');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_name', 'Gitbench Inc');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_phone', '+123 456 789');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_phone_2', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_vat', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('company_zip_code', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('contact_person', 'John Doe');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('cron_key', '34WI2L12L87I1A65M90M9A42N41D08A26I');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('currency_decimals', '2');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('currency_position', 'before');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('date_format', '%d-%m-%Y');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('date_php_format', 'd-m-Y');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('date_picker_format', 'dd-mm-yyyy');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('decimal_separator', '.');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('default_currency', 'USD');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('default_currency_symbol', '$');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('default_language', 'english');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('default_tax', '0.00');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('default_terms', 'Thank you for <span style=\"font-weight: bold;\">your</span> business. Please process this invoice within the due date.');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('demo_mode', 'FALSE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('developer', 'ig63Yd/+yuA8127gEyTz9TY4pnoeKq8dtocVP44+BJvtlRp8Vqcetwjk51dhSB6Rx8aVIKOPfUmNyKGWK7C/gg==');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('display_estimate_badge', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('display_invoice_badge', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('email_account_details', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('email_estimate_message', 'Hi {CLIENT}<br>Thanks for your business inquiry. <br>The estimate EST {REF} is attached with this email. <br>Estimate Overview:<br>Estimate # : EST {REF}<br>Amount: {CURRENCY} {AMOUNT}<br> You can view the estimate online at:<br>{LINK}<br>Best Regards,<br>{COMPANY}');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('email_invoice_message', 'Hello {CLIENT}<br>Here is the invoice of {CURRENCY} {AMOUNT}<br>You can view the invoice online at:<br>{LINK}<br>Best Regards,<br>{COMPANY}');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('email_staff_tickets', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('enable_languages', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('envato_username', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('estimate_color', '#FB6B5B');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('estimate_footer', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('estimate_language', 'en');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('estimate_prefix', 'EST');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('estimate_terms', 'Looking forward to doing business with you.');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('file_max_size', '80000');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('gcal_api_key', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('gcal_id', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('hide_branding', 'FALSE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('increment_invoice_number', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('installed', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('invoices_due_after', '30');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('invoice_color', '#53B567');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('invoice_footer', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('invoice_language', 'en');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('invoice_logo', 'invoice_logo.png');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('invoice_logo_height', '60');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('invoice_logo_width', '304');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('invoice_prefix', 'INV');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('invoice_start_no', '1');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('language', 'english');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('languages', 'spanish');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('last_check', '1437386159');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('last_seen_activities', '0');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('locale', 'en_US');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('login_bg', 'bg-login.jpg');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('login_title', 'Project Management System');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('logo_or_icon', 'logo_title');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('notify_bug_assignment', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('notify_bug_comments', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('notify_bug_status', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('notify_message_received', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('notify_project_assignments', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('notify_project_comments', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('notify_project_files', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('notify_task_assignments', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('paypal_cancel_url', 'paypal/cancel');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('paypal_email', 'billing@gitbench.com');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('paypal_ipn_url', 'paypal/t_ipn/ipn');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('paypal_live', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('paypal_success_url', 'paypal/success');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('pdf_engine', 'invoicr');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('postmark_api_key', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('postmark_from_address', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('project_prefix', 'PRO');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('protocol', 'mail');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('purchase_code', '4490de0-9c30-4157-f14-2b812a7d063f');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('quantity_decimals', '0');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('reminder_message', 'Hello {CLIENT}<br>This is a friendly reminder to pay your invoice of {CURRENCY} {AMOUNT}<br>You can view the invoice online at:<br>{LINK}<br>Best Regards,<br>{COMPANY}');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('reset_key', '34WI2L12L87I1A65M90M9A42N41D08A26I');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('rows_per_table', '25');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('settings', 'email');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('show_estimate_tax', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('show_invoice_tax', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('show_login_image', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('show_only_logo', 'FALSE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('sidebar_theme', 'dark');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('site_appleicon', 'logo.png');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('site_author', 'William M.');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('site_desc', 'Freelancer Office is a Web based PHP application for Freelancers - buy it on Codecanyon');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('site_favicon', 'logo.png');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('site_icon', 'fa-flask');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('smtp_host', 'smtp.mandrillapp.com');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('smtp_pass', '');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('smtp_port', '587');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('smtp_user', 'wm@gitbench.com');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('stripe_private_key', 'sk_test_tV5LwTRLk8yYcM94iMONLdF');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('stripe_public_key', 'pk_test_8t8Ck9sDuSRa2vps1KJlnjT');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('system_font', 'roboto_condensed');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('tax_decimals', '1');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('thousand_separator', ',');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('timezone', 'Europe/London');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('use_gravatar', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('use_postmark', 'FALSE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('valid_license', 'TRUE');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('webmaster_email', 'support@example.com');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('website_name', 'Freelancer Office');
INSERT INTO fx_config (`config_key`, `value`) VALUES ('xrates_check', '0');


#
# TABLE STRUCTURE FOR: fx_countries
#

DROP TABLE IF EXISTS fx_countries;

CREATE TABLE `fx_countries` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `value` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=243 DEFAULT CHARSET=utf8;

INSERT INTO fx_countries (`id`, `value`) VALUES (1, 'Afghanistan');
INSERT INTO fx_countries (`id`, `value`) VALUES (2, 'Albania');
INSERT INTO fx_countries (`id`, `value`) VALUES (3, 'Algeria');
INSERT INTO fx_countries (`id`, `value`) VALUES (4, 'Andorra');
INSERT INTO fx_countries (`id`, `value`) VALUES (5, 'Angola');
INSERT INTO fx_countries (`id`, `value`) VALUES (6, 'Anguilla');
INSERT INTO fx_countries (`id`, `value`) VALUES (7, 'Antigua and Barbuda');
INSERT INTO fx_countries (`id`, `value`) VALUES (8, 'Argentina');
INSERT INTO fx_countries (`id`, `value`) VALUES (9, 'Armenia');
INSERT INTO fx_countries (`id`, `value`) VALUES (10, 'Australia');
INSERT INTO fx_countries (`id`, `value`) VALUES (11, 'Austria');
INSERT INTO fx_countries (`id`, `value`) VALUES (12, 'Azerbaijan');
INSERT INTO fx_countries (`id`, `value`) VALUES (13, 'Bahamas');
INSERT INTO fx_countries (`id`, `value`) VALUES (14, 'Bahrain');
INSERT INTO fx_countries (`id`, `value`) VALUES (15, 'Bangladesh');
INSERT INTO fx_countries (`id`, `value`) VALUES (16, 'Barbados');
INSERT INTO fx_countries (`id`, `value`) VALUES (17, 'Belarus');
INSERT INTO fx_countries (`id`, `value`) VALUES (18, 'Belgium');
INSERT INTO fx_countries (`id`, `value`) VALUES (19, 'Belize');
INSERT INTO fx_countries (`id`, `value`) VALUES (20, 'Benin');
INSERT INTO fx_countries (`id`, `value`) VALUES (21, 'Bhutan');
INSERT INTO fx_countries (`id`, `value`) VALUES (22, 'Bolivia');
INSERT INTO fx_countries (`id`, `value`) VALUES (23, 'Bosnia and Herzegovina');
INSERT INTO fx_countries (`id`, `value`) VALUES (24, 'Botswana');
INSERT INTO fx_countries (`id`, `value`) VALUES (25, 'Brazil');
INSERT INTO fx_countries (`id`, `value`) VALUES (26, 'Brunei');
INSERT INTO fx_countries (`id`, `value`) VALUES (27, 'Bulgaria');
INSERT INTO fx_countries (`id`, `value`) VALUES (28, 'Burkina Faso');
INSERT INTO fx_countries (`id`, `value`) VALUES (29, 'Burundi');
INSERT INTO fx_countries (`id`, `value`) VALUES (30, 'Cambodia');
INSERT INTO fx_countries (`id`, `value`) VALUES (31, 'Cameroon');
INSERT INTO fx_countries (`id`, `value`) VALUES (32, 'Canada');
INSERT INTO fx_countries (`id`, `value`) VALUES (33, 'Cape Verde');
INSERT INTO fx_countries (`id`, `value`) VALUES (34, 'Central African Republic');
INSERT INTO fx_countries (`id`, `value`) VALUES (35, 'Chad');
INSERT INTO fx_countries (`id`, `value`) VALUES (36, 'Chile');
INSERT INTO fx_countries (`id`, `value`) VALUES (37, 'China');
INSERT INTO fx_countries (`id`, `value`) VALUES (38, 'Colombia');
INSERT INTO fx_countries (`id`, `value`) VALUES (39, 'Comoros');
INSERT INTO fx_countries (`id`, `value`) VALUES (40, 'Congo');
INSERT INTO fx_countries (`id`, `value`) VALUES (41, 'Congo Democratic Republic');
INSERT INTO fx_countries (`id`, `value`) VALUES (42, 'Cook Islands');
INSERT INTO fx_countries (`id`, `value`) VALUES (43, 'Costa Rica');
INSERT INTO fx_countries (`id`, `value`) VALUES (44, 'Croatia');
INSERT INTO fx_countries (`id`, `value`) VALUES (45, 'Cuba');
INSERT INTO fx_countries (`id`, `value`) VALUES (46, 'Cyprus');
INSERT INTO fx_countries (`id`, `value`) VALUES (47, 'Czech Republic');
INSERT INTO fx_countries (`id`, `value`) VALUES (48, 'Denmark');
INSERT INTO fx_countries (`id`, `value`) VALUES (49, 'Djibouti');
INSERT INTO fx_countries (`id`, `value`) VALUES (50, 'Dominica');
INSERT INTO fx_countries (`id`, `value`) VALUES (51, 'Dominican Republic');
INSERT INTO fx_countries (`id`, `value`) VALUES (52, 'East Timor');
INSERT INTO fx_countries (`id`, `value`) VALUES (53, 'Ecuador');
INSERT INTO fx_countries (`id`, `value`) VALUES (54, 'Egypt');
INSERT INTO fx_countries (`id`, `value`) VALUES (55, 'El Salvador');
INSERT INTO fx_countries (`id`, `value`) VALUES (56, 'Equatorial Guinea');
INSERT INTO fx_countries (`id`, `value`) VALUES (57, 'Eritrea');
INSERT INTO fx_countries (`id`, `value`) VALUES (58, 'Estonia');
INSERT INTO fx_countries (`id`, `value`) VALUES (59, 'Ethiopia');
INSERT INTO fx_countries (`id`, `value`) VALUES (60, 'Fiji');
INSERT INTO fx_countries (`id`, `value`) VALUES (61, 'Finland');
INSERT INTO fx_countries (`id`, `value`) VALUES (62, 'France');
INSERT INTO fx_countries (`id`, `value`) VALUES (63, 'Gabon');
INSERT INTO fx_countries (`id`, `value`) VALUES (64, 'Gambia');
INSERT INTO fx_countries (`id`, `value`) VALUES (65, 'Georgia');
INSERT INTO fx_countries (`id`, `value`) VALUES (66, 'Germany');
INSERT INTO fx_countries (`id`, `value`) VALUES (67, 'Ghana');
INSERT INTO fx_countries (`id`, `value`) VALUES (68, 'Greece');
INSERT INTO fx_countries (`id`, `value`) VALUES (69, 'Grenada');
INSERT INTO fx_countries (`id`, `value`) VALUES (70, 'Guadeloupe');
INSERT INTO fx_countries (`id`, `value`) VALUES (71, 'Guam');
INSERT INTO fx_countries (`id`, `value`) VALUES (72, 'Guatemala');
INSERT INTO fx_countries (`id`, `value`) VALUES (73, 'Guinea');
INSERT INTO fx_countries (`id`, `value`) VALUES (74, 'Guinea-Bissau');
INSERT INTO fx_countries (`id`, `value`) VALUES (75, 'Guyana');
INSERT INTO fx_countries (`id`, `value`) VALUES (76, 'Haiti');
INSERT INTO fx_countries (`id`, `value`) VALUES (77, 'Honduras');
INSERT INTO fx_countries (`id`, `value`) VALUES (78, 'Hungary');
INSERT INTO fx_countries (`id`, `value`) VALUES (79, 'Iceland');
INSERT INTO fx_countries (`id`, `value`) VALUES (80, 'India');
INSERT INTO fx_countries (`id`, `value`) VALUES (81, 'Indonesia');
INSERT INTO fx_countries (`id`, `value`) VALUES (82, 'Iran');
INSERT INTO fx_countries (`id`, `value`) VALUES (83, 'Iraq');
INSERT INTO fx_countries (`id`, `value`) VALUES (84, 'Ireland');
INSERT INTO fx_countries (`id`, `value`) VALUES (85, 'Israel');
INSERT INTO fx_countries (`id`, `value`) VALUES (86, 'Italy');
INSERT INTO fx_countries (`id`, `value`) VALUES (87, 'Ivory Coast (CÃ´te d\'Ivoire)');
INSERT INTO fx_countries (`id`, `value`) VALUES (88, 'Jamaica');
INSERT INTO fx_countries (`id`, `value`) VALUES (89, 'Japan');
INSERT INTO fx_countries (`id`, `value`) VALUES (90, 'Jordan');
INSERT INTO fx_countries (`id`, `value`) VALUES (91, 'Kazakhstan');
INSERT INTO fx_countries (`id`, `value`) VALUES (92, 'Kenya');
INSERT INTO fx_countries (`id`, `value`) VALUES (93, 'Kiribati');
INSERT INTO fx_countries (`id`, `value`) VALUES (94, 'Korea North');
INSERT INTO fx_countries (`id`, `value`) VALUES (95, 'Korea South');
INSERT INTO fx_countries (`id`, `value`) VALUES (96, 'Kuwait');
INSERT INTO fx_countries (`id`, `value`) VALUES (97, 'Kyrgyzstan');
INSERT INTO fx_countries (`id`, `value`) VALUES (98, 'Laos');
INSERT INTO fx_countries (`id`, `value`) VALUES (99, 'Latvia');
INSERT INTO fx_countries (`id`, `value`) VALUES (100, 'Lebanon');
INSERT INTO fx_countries (`id`, `value`) VALUES (101, 'Lesotho');
INSERT INTO fx_countries (`id`, `value`) VALUES (102, 'Liberia');
INSERT INTO fx_countries (`id`, `value`) VALUES (103, 'Libya');
INSERT INTO fx_countries (`id`, `value`) VALUES (104, 'Liechtenstein');
INSERT INTO fx_countries (`id`, `value`) VALUES (105, 'Lithuania');
INSERT INTO fx_countries (`id`, `value`) VALUES (106, 'Luxembourg');
INSERT INTO fx_countries (`id`, `value`) VALUES (107, 'Macedonia');
INSERT INTO fx_countries (`id`, `value`) VALUES (108, 'Madagascar');
INSERT INTO fx_countries (`id`, `value`) VALUES (109, 'Malawi');
INSERT INTO fx_countries (`id`, `value`) VALUES (110, 'Malaysia');
INSERT INTO fx_countries (`id`, `value`) VALUES (111, 'Maldives');
INSERT INTO fx_countries (`id`, `value`) VALUES (112, 'Mali');
INSERT INTO fx_countries (`id`, `value`) VALUES (113, 'Malta');
INSERT INTO fx_countries (`id`, `value`) VALUES (114, 'Marshall Islands');
INSERT INTO fx_countries (`id`, `value`) VALUES (115, 'Mauritania');
INSERT INTO fx_countries (`id`, `value`) VALUES (116, 'Mauritius');
INSERT INTO fx_countries (`id`, `value`) VALUES (117, 'Mexico');
INSERT INTO fx_countries (`id`, `value`) VALUES (118, 'Micronesia');
INSERT INTO fx_countries (`id`, `value`) VALUES (119, 'Moldova');
INSERT INTO fx_countries (`id`, `value`) VALUES (120, 'Monaco');
INSERT INTO fx_countries (`id`, `value`) VALUES (121, 'Mongolia');
INSERT INTO fx_countries (`id`, `value`) VALUES (122, 'Montenegro');
INSERT INTO fx_countries (`id`, `value`) VALUES (123, 'Morocco');
INSERT INTO fx_countries (`id`, `value`) VALUES (124, 'Mozambique');
INSERT INTO fx_countries (`id`, `value`) VALUES (125, 'Myanmar');
INSERT INTO fx_countries (`id`, `value`) VALUES (126, 'Namibia');
INSERT INTO fx_countries (`id`, `value`) VALUES (127, 'Nauru');
INSERT INTO fx_countries (`id`, `value`) VALUES (128, 'Nepal');
INSERT INTO fx_countries (`id`, `value`) VALUES (129, 'Netherlands');
INSERT INTO fx_countries (`id`, `value`) VALUES (130, 'New Zealand');
INSERT INTO fx_countries (`id`, `value`) VALUES (131, 'Nicaragua');
INSERT INTO fx_countries (`id`, `value`) VALUES (132, 'Niger');
INSERT INTO fx_countries (`id`, `value`) VALUES (133, 'Nigeria');
INSERT INTO fx_countries (`id`, `value`) VALUES (134, 'Niue');
INSERT INTO fx_countries (`id`, `value`) VALUES (135, 'Norway');
INSERT INTO fx_countries (`id`, `value`) VALUES (136, 'Oman');
INSERT INTO fx_countries (`id`, `value`) VALUES (137, 'Pakistan');
INSERT INTO fx_countries (`id`, `value`) VALUES (138, 'Palau');
INSERT INTO fx_countries (`id`, `value`) VALUES (139, 'Palestine');
INSERT INTO fx_countries (`id`, `value`) VALUES (140, 'Panama');
INSERT INTO fx_countries (`id`, `value`) VALUES (141, 'Papua New Guinea');
INSERT INTO fx_countries (`id`, `value`) VALUES (142, 'Paraguay');
INSERT INTO fx_countries (`id`, `value`) VALUES (143, 'Peru');
INSERT INTO fx_countries (`id`, `value`) VALUES (144, 'Philippines');
INSERT INTO fx_countries (`id`, `value`) VALUES (145, 'Poland');
INSERT INTO fx_countries (`id`, `value`) VALUES (146, 'Portugal');
INSERT INTO fx_countries (`id`, `value`) VALUES (147, 'Qatar');
INSERT INTO fx_countries (`id`, `value`) VALUES (148, 'Romania');
INSERT INTO fx_countries (`id`, `value`) VALUES (149, 'Russia');
INSERT INTO fx_countries (`id`, `value`) VALUES (150, 'Rwanda');
INSERT INTO fx_countries (`id`, `value`) VALUES (151, 'Saint Kitts and Nevis');
INSERT INTO fx_countries (`id`, `value`) VALUES (152, 'Saint Lucia');
INSERT INTO fx_countries (`id`, `value`) VALUES (153, 'Saint Vincent and the Grenadines');
INSERT INTO fx_countries (`id`, `value`) VALUES (154, 'Samoa');
INSERT INTO fx_countries (`id`, `value`) VALUES (155, 'San Marino');
INSERT INTO fx_countries (`id`, `value`) VALUES (156, 'SÃ£o TomÃ© and PrÃ­ncipe');
INSERT INTO fx_countries (`id`, `value`) VALUES (157, 'Saudi Arabia');
INSERT INTO fx_countries (`id`, `value`) VALUES (158, 'Senegal');
INSERT INTO fx_countries (`id`, `value`) VALUES (159, 'Serbia');
INSERT INTO fx_countries (`id`, `value`) VALUES (160, 'Seychelles');
INSERT INTO fx_countries (`id`, `value`) VALUES (161, 'Sierra Leone');
INSERT INTO fx_countries (`id`, `value`) VALUES (162, 'Singapore');
INSERT INTO fx_countries (`id`, `value`) VALUES (163, 'Slovakia');
INSERT INTO fx_countries (`id`, `value`) VALUES (164, 'Slovenia');
INSERT INTO fx_countries (`id`, `value`) VALUES (165, 'Solomon Islands');
INSERT INTO fx_countries (`id`, `value`) VALUES (166, 'Somalia');
INSERT INTO fx_countries (`id`, `value`) VALUES (167, 'South Africa');
INSERT INTO fx_countries (`id`, `value`) VALUES (168, 'South Sudan');
INSERT INTO fx_countries (`id`, `value`) VALUES (169, 'Spain');
INSERT INTO fx_countries (`id`, `value`) VALUES (170, 'Sri Lanka');
INSERT INTO fx_countries (`id`, `value`) VALUES (171, 'Sudan');
INSERT INTO fx_countries (`id`, `value`) VALUES (172, 'Suriname');
INSERT INTO fx_countries (`id`, `value`) VALUES (173, 'Swaziland');
INSERT INTO fx_countries (`id`, `value`) VALUES (174, 'Sweden');
INSERT INTO fx_countries (`id`, `value`) VALUES (175, 'Switzerland');
INSERT INTO fx_countries (`id`, `value`) VALUES (176, 'Syria');
INSERT INTO fx_countries (`id`, `value`) VALUES (177, 'Taiwan');
INSERT INTO fx_countries (`id`, `value`) VALUES (178, 'Tajikistan');
INSERT INTO fx_countries (`id`, `value`) VALUES (179, 'Tanzania');
INSERT INTO fx_countries (`id`, `value`) VALUES (180, 'Thailand');
INSERT INTO fx_countries (`id`, `value`) VALUES (181, 'Togo');
INSERT INTO fx_countries (`id`, `value`) VALUES (182, 'Tonga');
INSERT INTO fx_countries (`id`, `value`) VALUES (183, 'Trinidad and Tobago');
INSERT INTO fx_countries (`id`, `value`) VALUES (184, 'Tunisia');
INSERT INTO fx_countries (`id`, `value`) VALUES (185, 'Turkey');
INSERT INTO fx_countries (`id`, `value`) VALUES (186, 'Turkmenistan');
INSERT INTO fx_countries (`id`, `value`) VALUES (187, 'Tuvalu');
INSERT INTO fx_countries (`id`, `value`) VALUES (188, 'Uganda');
INSERT INTO fx_countries (`id`, `value`) VALUES (189, 'Ukraine');
INSERT INTO fx_countries (`id`, `value`) VALUES (190, 'United Arab Emirates');
INSERT INTO fx_countries (`id`, `value`) VALUES (191, 'United Kingdom');
INSERT INTO fx_countries (`id`, `value`) VALUES (192, 'United States');
INSERT INTO fx_countries (`id`, `value`) VALUES (193, 'Uruguay');
INSERT INTO fx_countries (`id`, `value`) VALUES (194, 'Uzbekistan');
INSERT INTO fx_countries (`id`, `value`) VALUES (195, 'Vanuatu');
INSERT INTO fx_countries (`id`, `value`) VALUES (196, 'Vatican City');
INSERT INTO fx_countries (`id`, `value`) VALUES (197, 'Venezuela');
INSERT INTO fx_countries (`id`, `value`) VALUES (198, 'Vietnam');
INSERT INTO fx_countries (`id`, `value`) VALUES (199, 'Yemen');
INSERT INTO fx_countries (`id`, `value`) VALUES (200, 'Zambia');
INSERT INTO fx_countries (`id`, `value`) VALUES (201, 'Zimbabwe');


#
# TABLE STRUCTURE FOR: fx_currencies
#

DROP TABLE IF EXISTS fx_currencies;

CREATE TABLE `fx_currencies` (
  `code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `symbol` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `xrate` decimal(12,5) DEFAULT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('AUD', 'Australian Dollar', '$', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('BRL', 'Brazilian Real', 'R$', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('CAD', 'Canadian Dollar', '$', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('CHF', 'Swiss Franc', 'Fr', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('CLP', 'Chilean Peso', '$', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('CNY', 'Chinese Yuan', 'Â¥', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('CZK', 'Czech Koruna', 'KÄ', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('DKK', 'Danish Krone', 'kr', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('EUR', 'Euro', 'â‚¬', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('GBP', 'British Pound', 'Â£', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('HKD', 'Hong Kong Dollar', '$', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('HUF', 'Hungarian Forint', 'Ft', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('IDR', 'Indonesian Rupiah', 'Rp', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('ILS', 'Israeli New Shekel', 'â‚ª', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('INR', 'Indian Rupee', 'INR', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('JPY', 'Japanese Yen', 'Â¥', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('KRW', 'Korean Won', 'â‚©', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('MXN', 'Mexican Peso', '$', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('MYR', 'Malaysian Ringgit', 'RM', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('NOK', 'Norwegian Krone', 'kr', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('NZD', 'New Zealand Dollar', '$', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('PHP', 'Philippine Peso', 'â‚±', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('PKR', 'Pakistan Rupee', 'â‚¨', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('PLN', 'Polish Zloty', 'zÅ‚', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('RON', 'Romanian Leu', 'lei', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('RUB', 'Russian Ruble', 'â‚½', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('SEK', 'Swedish Krona', 'kr', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('SGD', 'Singapore Dollar', '$', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('THB', 'Thai Baht', 'à¸¿', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('TRY', 'Turkish Lira', 'â‚º', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('TWD', 'Taiwan Dollar', '$', NULL);
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('USD', 'US Dollar', '$', '1.00000');
INSERT INTO fx_currencies (`code`, `name`, `symbol`, `xrate`) VALUES ('ZAR', 'South African Rand', 'R', NULL);


#
# TABLE STRUCTURE FOR: fx_departments
#

DROP TABLE IF EXISTS fx_departments;

CREATE TABLE `fx_departments` (
  `deptid` int(10) NOT NULL AUTO_INCREMENT,
  `deptname` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `depthidden` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`deptid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_email_templates
#

DROP TABLE IF EXISTS fx_email_templates;

CREATE TABLE `fx_email_templates` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `email_group` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template_body` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (1, 'registration', 'Registration successful', '<div style=\"height: 7px; background-color: #535353;\"></div><div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Welcome to {SITE_NAME}</div><div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\">Thanks for joining {SITE_NAME}. We listed your sign in details below, make sure you keep them safe.<br>To open your {SITE_NAME} homepage, please follow this link:<br><big><b><a href=\"{SITE_URL}\">{SITE_NAME} Account!</a></b></big><br>Link doesn\'t work? Copy the following link to your browser address bar:<br><a href=\"{SITE_URL}\">{SITE_URL}</a><br>Your username: {USERNAME}<br>Your email address: {EMAIL}<br>Your password: {PASSWORD}<br>Have fun!<br>The {SITE_NAME} Team.<br><br></div></div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (2, 'forgot_password', 'Forgot Password', '        <div style=\"height: 7px; background-color: #535353;\"></div><div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New Password</div><div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\">Forgot your password, huh? No big deal.<br>To create a new password, just follow this link:<br><br><big><b><a href=\"{PASS_KEY_URL}\">Create a new password</a></b></big><br>Link doesn\'t work? Copy the following link to your browser address bar:<br><a href=\"{PASS_KEY_URL}\">{PASS_KEY_URL}</a><br><br><br>You received this email, because it was requested by a <a href=\"{SITE_URL}\">{SITE_NAME}</a> user. <p></p><p>This is part of the procedure to create a new password on the system. If you DID NOT request a new password then please ignore this email and your password will remain the same.</p><br>Thank you,<br>The {SITE_NAME} Team</div></div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (3, 'change_email', 'Change Email', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New email address on {SITE_NAME}</div>\r\n\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\">You have changed your email address for {SITE_NAME}.<br>Follow this link to confirm your new email address:<br><big><b><a href=\"{NEW_EMAIL_KEY_URL}\">Confirm your new email</a></b></big><br>Link doesn\'t work? Copy the following link to your browser address bar:<br><a href=\"{NEW_EMAIL_KEY_URL}\">{NEW_EMAIL_KEY_URL}</a><br><br>Your email address: {NEW_EMAIL}<br><br>You received this email, because it was requested by a <a href=\"{SITE_URL}\">{SITE_NAME}</a> user. If you have received this by mistake, please DO NOT click the confirmation link, and simply delete this email. After a short time, the request will be removed from the system.<br>Thank you,<br>The {SITE_NAME} Team</div>\r\n\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (4, 'activate_account', 'Activate Account', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Welcome to {SITE_NAME}!</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Thanks for joining {SITE_NAME}. We listed your sign in details below, make sure you keep them safe.</p>\r\nTo verify your email address, please follow this link:<br><big><b><a href=\"{ACTIVATE_URL}\">Finish your registration...</a></b></big><br>Link doesn\'t work? Copy the following link to your browser address bar:<br><a href=\"{ACTIVATE_URL}\">{ACTIVATE_URL}</a><br><br>Please verify your email within {ACTIVATION_PERIOD} hours, otherwise your registration will become invalid and you will have to register again.<br><br><br>Your username: {USERNAME}<br>Your email address: {EMAIL}<br>Your password: {PASSWORD}<br><br>Have fun!<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (5, 'reset_password', 'Reset Password', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New password on {SITE_NAME}</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>You have changed your password.<br>Please, keep it in your records so you don\'t forget it.<br></p>\r\nYour username: {USERNAME}<br>Your email address: {EMAIL}<br>Your new password: {NEW_PASSWORD}<br><br>Thank you,<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (6, 'bug_assigned', 'New Bug Assigned', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New Bug Assigned</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p>A new bug ( {ISSUE_TITLE} ) has been assigned to you by {ASSIGNED_BY} in project {PROJECT_TITLE}. </p>\r\n<p>You can view this bug by logging in to the portal using the link below.</p>\r\n--------------------------<br><big><b><a href=\"{SITE_URL}\">My Account</a></b></big><br><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (7, 'bug_status', 'Bug status changed', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Bug status changed</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p>Bug {ISSUE_TITLE} has been marked as {STATUS} by {MARKED_BY}. </p>\r\n<p>You can view this bug by logging in to the portal using the link below.</p>\r\n--------------------------<br><big><b><a href=\"{BUG_URL}\">My Account</a></b></big><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (8, 'bug_comment', 'New Bug Comment Received', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New Comment Received</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p>A new comment has been posted by {POSTED_BY} to bug {ISSUE_TITLE}. </p>\r\n<p>You can view the comment using the link below.</p>\r\n----------------------------------------------------------<br><big><b><a href=\"{COMMENT_URL}\">View Comment</a></b></big><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (9, 'bug_file', 'New bug file', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New bug file</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there, </p>\r\n<p>A new file has been uploaded by {UPLOADED_BY} to issue {ISSUE_TITLE}. </p>\r\n<p>You can view the bug using the link below.</p>\r\n--------------------------<br><big><b><a href=\"{BUG_URL}\">View Bug</a></b></big><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (10, 'bug_reported', 'New bug Reported', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New bug Reported</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p></p>\r\n<p>A new bug ({ISSUE_TITLE}) has been reported by {ADDED_BY}. </p>\r\n<p>You can view the Bug using the Dashboard Page.</p>\r\n--------------------------<br><big><b><a href=\"{BUG_URL}\">View Bug</a></b></big><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (11, 'project_file', 'New Project File', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New Project File</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p>A new file has been uploaded by {UPLOADED_BY} to project {PROJECT_TITLE}. </p>\r\n<p>You can view the Project using the link below.</p>\r\n--------------------------<br><big><b><a href=\"{PROJECT_URL}\">View Project</a></b></big><br><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (12, 'project_complete', 'Project Completed', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Project Completed</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi {CLIENT_NAME}</p>\r\n<p>Project : {PROJECT_TITLE} - {PROJECT_CODE} has been completed. </p>\r\n<p>You can view the project by logging into your portal Account.</p>\r\n<big><b><a href=\"{PROJECT_URL}\">View Project</a></b></big><br><br>--------------------------<br>Project Overview:<br>Hours Logged # :  {PROJECT_HOURS} hours<br>Project Cost : {PROJECT_COST}<br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (13, 'project_comment', 'New Project Comment Received', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New Comment Received</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p>A new comment has been posted by {POSTED_BY} to project {PROJECT_TITLE}. </p>\r\n<p>You can view the comment using the link below.</p>\r\n-----------------------------------------------------------------------<br><big><b><a href=\"{COMMENT_URL}\">View Comment</a></b></big><br><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (14, 'task_assigned', 'Task assigned', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Task assigned</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p>A new task ( {TASK_NAME} ) has been assigned to you by {ASSIGNED_BY} in project {PROJECT_TITLE}. </p>\r\n<p>You can view this task by logging in to the portal using the link below.</p>\r\n-----------------------------------<br><big><b><a href=\"{PROJECT_URL}\">View Task</a></b></big><br><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (15, 'project_assigned', 'Project assigned', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Project assigned</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p>A new project ( {PROJECT_TITLE} ) has been assigned to you by {ASSIGNED_BY}.</p>\r\n<p>You can view this project by logging in to the portal using the link below.</p>\r\n-----------------------------------<br><big><b><a href=\"{PROJECT_URL}\">View Project</a></b></big><br><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (16, 'payment_email', 'Payment Received', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Payment Received</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Dear Customer</p>\r\n<p>We have received your payment of {INVOICE_CURRENCY} {PAID_AMOUNT}. </p>\r\n<p>Thank you for your Payment and business. We look forward to working with you again.</p>\r\n--------------------------<br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (17, 'invoice_message', 'New Invoice', '<div style=\"height: 7px; background-color: #535353;\"></div><div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">INVOICE {REF}</div><div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><span class=\"style1\"><span style=\"font-weight:bold;\">Hello {CLIENT}</span></span><br><br>Here is the invoice of {CURRENCY} {AMOUNT}.<br><br>You can view the invoice online at:<br><big><b><a href=\"{INVOICE_LINK}\">View Invoice</a></b></big><br><br>Best Regards<br><br>The {SITE_NAME} Team</div></div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (18, 'invoice_reminder', 'Invoice Reminder', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Invoice Reminder</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hello {CLIENT}</p>\r\n<br><p>This is a friendly reminder to pay your invoice of {CURRENCY} {AMOUNT}<br>You can view the invoice online at:<br><big><b><a href=\"{INVOICE_LINK}\">View Invoice</a></b></big><br><br>Best Regards,<br>The {SITE_NAME} Team</p>\r\n</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (19, 'message_received', 'Message Received', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Message Received</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi {RECIPIENT},</p>\r\n<p>You have received a message from {SENDER}. </p>\r\n------------------------------------------------------------------<br><blockquote>\r\n{MESSAGE}</blockquote>\r\n<big><b><a href=\"{SITE_URL}\">Go to Account</a></b></big><br><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (20, 'estimate_email', 'New Estimate', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Estimate {ESTIMATE_REF}</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi {CLIENT}</p>\r\n<p>Thanks for your business inquiry. </p>\r\nThe estimate {ESTIMATE_REF} is attached with this email. <br> Estimate Overview:<br> Estimate # : {ESTIMATE_REF}<br> Amount: {CURRENCY} {AMOUNT}<br> <br>You can view the estimate online at:<br> <big><b><a href=\"{ESTIMATE_LINK}\">View Estimate</a></b></big><br><br>  Best Regards,<br> The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (21, 'ticket_staff_email', 'New Ticket [TICKET_CODE]', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New Ticket</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Ticket #{TICKET_CODE} has been created by the client.</p>\r\n<p>You may view the ticket by clicking on the following link <br><br>  Client Email : {REPORTER_EMAIL}<br><br> <big><b><a href=\"{TICKET_LINK}\">View Ticket</a></b></big> <br><br>Regards<br><br>{SITE_NAME}</p>\r\n</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (22, 'ticket_client_email', 'Ticket [TICKET_CODE] Opened', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Ticket Opened</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hello {CLIENT_EMAIL},<br><br></p>\r\n<p>Your ticket has been opened with us.<br><br>Ticket #{TICKET_CODE}<br>Status : Open<br><br>Click on the below link to see the ticket details and post additional comments.<br><br><big><b><a href=\"{TICKET_LINK}\">View Ticket</a></b></big><br><br>Regards<br><br>The {SITE_NAME} Team<br></p>\r\n</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (23, 'ticket_reply_email', 'Ticket [TICKET_CODE] Response', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Ticket Response</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>A new response has been added to Ticket #{TICKET_CODE}<br><br> Ticket : #{TICKET_CODE} <br>Status : {TICKET_STATUS} <br><br></p>\r\nTo see the response and post additional comments, click on the link below.<br><br>         <big><b><a href=\"{TICKET_LINK}\">View Reply</a> </b></big><br><br>          Note: Do not reply to this email as this email is not monitored.<br><br>     Regards<br>The {SITE_NAME} Team<br></div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (24, 'ticket_closed_email', 'Ticket [TICKET_CODE] Closed', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Ticket Closed</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\">Hi {REPORTER_EMAIL}<br><br>Ticket #{TICKET_CODE} has been closed by {STAFF_USERNAME} <br><br>          Ticket : #{TICKET_CODE} <br>     Status : {TICKET_STATUS}<br><br>Replies : {NO_OF_REPLIES}<br><br>          To see the responses or open the ticket, click on the link below.<br><br>          <big><b><a href=\"{TICKET_LINK}\">View Ticket</a></b></big> <br><br>          Note: Do not reply to this email as this email is not monitored.<br><br>    Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (25, 'project_updated', 'Project updated', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Project updated</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p>{PROJECT_TITLE} ) has been updated by {ASSIGNED_BY}.</p>\r\n<p>You can view this project by logging in to the portal using the link below.</p>\r\n-----------------------------------<br><big><b><a href=\"{PROJECT_URL}\">View Project</a></b></big><br><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO fx_email_templates (`template_id`, `email_group`, `subject`, `template_body`) VALUES (26, 'task_updated', 'Task updated', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Task updated</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p>{TASK_NAME} in {PROJECT_TITLE} has been updated by {ASSIGNED_BY}.</p>\r\n<p>You can view this project by logging in to the portal using the link below.</p>\r\n-----------------------------------<br><big><b><a href=\"{PROJECT_URL}\">View Project</a></b></big><br><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');


#
# TABLE STRUCTURE FOR: fx_estimate_items
#

DROP TABLE IF EXISTS fx_estimate_items;

CREATE TABLE `fx_estimate_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_tax_rate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `item_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT 'Item Name',
  `item_desc` longtext COLLATE utf8_unicode_ci,
  `unit_cost` decimal(10,2) DEFAULT '0.00',
  `quantity` decimal(10,2) DEFAULT '0.00',
  `item_tax_total` decimal(10,2) DEFAULT '0.00',
  `total_cost` decimal(10,2) DEFAULT '0.00',
  `estimate_id` int(11) NOT NULL,
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `item_order` int(11) DEFAULT '0',
  PRIMARY KEY (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_estimates
#

DROP TABLE IF EXISTS fx_estimates;

CREATE TABLE `fx_estimates` (
  `est_id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `client` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `due_date` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'USD',
  `discount` float NOT NULL,
  `notes` text COLLATE utf8_unicode_ci,
  `tax` int(11) NOT NULL DEFAULT '0',
  `status` enum('Accepted','Declined','Pending') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Pending',
  `date_sent` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `est_deleted` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `emailed` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `show_client` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `invoiced` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  PRIMARY KEY (`est_id`),
  UNIQUE KEY `reference_no` (`reference_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_fields
#

DROP TABLE IF EXISTS fx_fields;

CREATE TABLE `fx_fields` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `deptid` int(10) NOT NULL,
  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uniqid` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_files
#

DROP TABLE IF EXISTS fx_files;

CREATE TABLE `fx_files` (
  `file_id` int(11) NOT NULL AUTO_INCREMENT,
  `project` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `path` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` text COLLATE utf8_unicode_ci,
  `ext` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `size` int(10) DEFAULT NULL,
  `is_image` int(2) DEFAULT NULL,
  `image_width` int(5) DEFAULT NULL,
  `image_height` int(5) DEFAULT NULL,
  `uploaded_by` int(11) NOT NULL,
  `date_posted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_invoices
#

DROP TABLE IF EXISTS fx_invoices;

CREATE TABLE `fx_invoices` (
  `inv_id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `client` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `due_date` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8_unicode_ci,
  `allow_paypal` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Yes',
  `tax` decimal(10,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `allow_2checkout` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'Yes',
  `allow_stripe` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `allow_bitcoin` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `recurring` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `r_freq` varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT '31',
  `recur_start_date` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recur_end_date` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recur_frequency` varchar(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recur_next_date` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'USD',
  `status` enum('Unpaid','Paid') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Unpaid',
  `archived` int(11) DEFAULT '0',
  `date_sent` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inv_deleted` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `emailed` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `show_client` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Yes',
  `viewed` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  PRIMARY KEY (`inv_id`),
  UNIQUE KEY `reference_no` (`reference_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_ipn_log
#

DROP TABLE IF EXISTS fx_ipn_log;

CREATE TABLE `fx_ipn_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `listener_name` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Either IPN or API',
  `transaction_type` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The type of call being made to the listener',
  `transaction_id` varchar(19) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The unique transaction ID generated by PayPal',
  `status` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The status of the call',
  `message` varchar(512) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Explanation of the call status',
  `ipn_data_hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'MD5 hash of the IPN post data',
  `detail` mediumtext COLLATE utf8_unicode_ci COMMENT 'Detail text (potentially JSON) on this call',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_ipn_order_items
#

DROP TABLE IF EXISTS fx_ipn_order_items;

CREATE TABLE `fx_ipn_order_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `item_name` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Item name as passed by you, the merchant. Or, if not passed by you, as entered by your customer. If this is a shopping cart transaction, Paypal will append the number of the item (e.g., item_name_1,item_name_2, and so forth).',
  `item_number` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Pass-through variable for you to track purchases. It will get passed back to you at the completion of the payment. If omitted, no variable will be passed back to you.',
  `quantity` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Quantity as entered by your customer or as passed by you, the merchant. If this is a shopping cart transaction, PayPal appends the number of the item (e.g., quantity1,quantity2).',
  `mc_gross` decimal(10,2) DEFAULT NULL COMMENT 'Full amount of the customer''s payment',
  `mc_handling` decimal(10,2) DEFAULT NULL COMMENT 'Total handling charge associated with the transaction',
  `mc_shipping` decimal(10,2) DEFAULT NULL COMMENT 'Total shipping amount associated with the transaction',
  `tax` decimal(10,2) DEFAULT NULL COMMENT 'Amount of tax charged on payment',
  `cost_per_item` decimal(10,2) DEFAULT NULL COMMENT 'Cost of an individual item',
  `option_name_1` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 1 name as requested by you',
  `option_selection_1` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 1 choice as entered by your customer',
  `option_name_2` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 2 name as requested by you',
  `option_selection_2` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 2 choice as entered by your customer',
  `option_name_3` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 3 name as requested by you',
  `option_selection_3` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 3 choice as entered by your customer',
  `option_name_4` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 4 name as requested by you',
  `option_selection_4` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 4 choice as entered by your customer',
  `option_name_5` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 5 name as requested by you',
  `option_selection_5` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 5 choice as entered by your customer',
  `option_name_6` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 6 name as requested by you',
  `option_selection_6` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 6 choice as entered by your customer',
  `option_name_7` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 7 name as requested by you',
  `option_selection_7` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Option 7 choice as entered by your customer',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_ipn_orders
#

DROP TABLE IF EXISTS fx_ipn_orders;

CREATE TABLE `fx_ipn_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notify_version` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'IPN Version Number',
  `verify_sign` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Encrypted string used to verify the authenticityof the tansaction',
  `test_ipn` int(11) DEFAULT NULL,
  `protection_eligibility` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Which type of seller protection the buyer is protected by',
  `charset` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Character set used by PayPal',
  `btn_id` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The PayPal buy button clicked',
  `address_city` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'City of customers address',
  `address_country` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Country of customers address',
  `address_country_code` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Two character ISO 3166 country code',
  `address_name` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Name used with address (included when customer provides a Gift address)',
  `address_state` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'State of customer address',
  `address_status` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'confirmed/unconfirmed',
  `address_street` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Customer''s street address',
  `address_zip` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Zip code of customer''s address',
  `first_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Customer''s first name',
  `last_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Customer''s last name',
  `payer_business_name` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Customer''s company name, if customer represents a business',
  `payer_email` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Customer''s primary email address. Use this email to provide any credits',
  `payer_id` varchar(13) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Unique customer ID.',
  `payer_status` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'verified/unverified',
  `contact_phone` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Customer''s telephone number.',
  `residence_country` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Two-Character ISO 3166 country code',
  `business` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Email address or account ID of the payment recipient (that is, the merchant). Equivalent to the values of receiver_email (If payment is sent to primary account) and business set in the Website Payment HTML.',
  `receiver_email` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Primary email address of the payment recipient (that is, the merchant). If the payment is sent to a non-primary email address on your PayPal account, the receiver_email is still your primary email.',
  `receiver_id` varchar(13) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Unique account ID of the payment recipient (i.e., the merchant). This is the same as the recipients referral ID.',
  `custom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Custom value as passed by you, the merchant. These are pass-through variables that are never presented to your customer.',
  `invoice` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Pass through variable you can use to identify your invoice number for this purchase. If omitted, no variable is passed back.',
  `memo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Memo as entered by your customer in PayPal Website Payments note field.',
  `tax` decimal(10,2) DEFAULT NULL COMMENT 'Amount of tax charged on payment',
  `auth_id` varchar(19) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Authorization identification number',
  `auth_exp` varchar(28) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Authorization expiration date and time, in the following format: HH:MM:SS DD Mmm YY, YYYY PST',
  `auth_amount` int(11) DEFAULT NULL COMMENT 'Authorization amount',
  `auth_status` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Status of authorization',
  `num_cart_items` int(11) DEFAULT NULL COMMENT 'If this is a PayPal shopping cart transaction, number of items in the cart',
  `parent_txn_id` varchar(19) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'In the case of a refund, reversal, or cancelled reversal, this variable contains the txn_id of the original transaction, while txn_id contains a new ID for the new transaction.',
  `payment_date` varchar(28) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Time/date stamp generated by PayPal, in the following format: HH:MM:SS DD Mmm YY, YYYY PST',
  `payment_status` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Payment status of the payment',
  `payment_type` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'echeck/instant',
  `pending_reason` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'This variable is only set if payment_status=pending',
  `reason_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'This variable is only set if payment_status=reversed',
  `remaining_settle` int(11) DEFAULT NULL COMMENT 'Remaining amount that can be captured with Authorization and Capture',
  `shipping_method` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The name of a shipping method from the shipping calculations section of the merchants account profile. The buyer selected the named shipping method for this transaction',
  `shipping` decimal(10,2) DEFAULT NULL COMMENT 'Shipping charges associated with this transaction. Format unsigned, no currency symbol, two decimal places',
  `transaction_entity` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Authorization and capture transaction entity',
  `txn_id` varchar(19) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'A unique transaction ID generated by PayPal',
  `txn_type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'cart/express_checkout/send-money/virtual-terminal/web-accept',
  `exchange_rate` decimal(10,2) DEFAULT NULL COMMENT 'Exchange rate used if a currency conversion occured',
  `mc_currency` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Three character country code. For payment IPN notifications, this is the currency of the payment, for non-payment subscription IPN notifications, this is the currency of the subscription.',
  `mc_fee` decimal(10,2) DEFAULT NULL COMMENT 'Transaction fee associated with the payment, mc_gross minus mc_fee equals the amount deposited into the receiver_email account. Equivalent to payment_fee for USD payments. If this amount is negative, it signifies a refund or reversal, and either ofthose p',
  `mc_gross` decimal(10,2) DEFAULT NULL COMMENT 'Full amount of the customer''s payment',
  `mc_handling` decimal(10,2) DEFAULT NULL COMMENT 'Total handling charge associated with the transaction',
  `mc_shipping` decimal(10,2) DEFAULT NULL COMMENT 'Total shipping amount associated with the transaction',
  `payment_fee` decimal(10,2) DEFAULT NULL COMMENT 'USD transaction fee associated with the payment',
  `payment_gross` decimal(10,2) DEFAULT NULL COMMENT 'Full USD amount of the customers payment transaction, before payment_fee is subtracted',
  `settle_amount` decimal(10,2) DEFAULT NULL COMMENT 'Amount that is deposited into the account''s primary balance after a currency conversion',
  `settle_currency` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Currency of settle amount. Three digit currency code',
  `auction_buyer_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The customer''s auction ID.',
  `auction_closing_date` varchar(28) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'The auction''s close date. In the format: HH:MM:SS DD Mmm YY, YYYY PSD',
  `auction_multi_item` int(11) DEFAULT NULL COMMENT 'The number of items purchased in multi-item auction payments',
  `for_auction` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'This is an auction payment - payments made using Pay for eBay Items or Smart Logos - as well as send money/money request payments with the type eBay items or Auction Goods(non-eBay)',
  `subscr_date` varchar(28) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Start date or cancellation date depending on whether txn_type is subcr_signup or subscr_cancel',
  `subscr_effective` varchar(28) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Date when a subscription modification becomes effective',
  `period1` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(Optional) Trial subscription interval in days, weeks, months, years (example a 4 day interval is 4 D',
  `period2` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(Optional) Trial period',
  `period3` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Regular subscription interval in days, weeks, months, years',
  `amount1` decimal(10,2) DEFAULT NULL COMMENT 'Amount of payment for Trial period 1 for USD',
  `amount2` decimal(10,2) DEFAULT NULL COMMENT 'Amount of payment for Trial period 2 for USD',
  `amount3` decimal(10,2) DEFAULT NULL COMMENT 'Amount of payment for regular subscription  period 1 for USD',
  `mc_amount1` decimal(10,2) DEFAULT NULL COMMENT 'Amount of payment for trial period 1 regardless of currency',
  `mc_amount2` decimal(10,2) DEFAULT NULL COMMENT 'Amount of payment for trial period 2 regardless of currency',
  `mc_amount3` decimal(10,2) DEFAULT NULL COMMENT 'Amount of payment for regular subscription period regardless of currency',
  `recurring` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Indicates whether rate recurs (1 is yes, blank is no)',
  `reattempt` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Indicates whether reattempts should occur on payment failure (1 is yes, blank is no)',
  `retry_at` varchar(28) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Date PayPal will retry a failed subscription payment',
  `recur_times` int(11) DEFAULT NULL COMMENT 'The number of payment installations that will occur at the regular rate',
  `username` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(Optional) Username generated by PayPal and given to subscriber to access the subscription',
  `password` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(Optional) Password generated by PayPal and given to subscriber to access the subscription (Encrypted)',
  `subscr_id` varchar(19) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'ID generated by PayPal for the subscriber',
  `case_id` varchar(28) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Case identification number',
  `case_type` varchar(28) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'complaint/chargeback',
  `case_creation_date` varchar(28) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Date/Time the case was registered',
  `order_status` enum('PAID','WAITING','REJECTED') COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Additional variable to make payment_status more actionable',
  `discount` decimal(10,2) DEFAULT NULL COMMENT 'Additional variable to record the discount made on the order',
  `shipping_discount` decimal(10,2) DEFAULT NULL COMMENT 'Record the discount made on the shipping',
  `ipn_track_id` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Internal tracking variable added in April 2011',
  `transaction_subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Describes the product for a button-based purchase',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UniqueTransactionID` (`txn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_items
#

DROP TABLE IF EXISTS fx_items;

CREATE TABLE `fx_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_tax_rate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `item_tax_total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `quantity` decimal(10,2) DEFAULT '0.00',
  `total_cost` decimal(10,2) DEFAULT '0.00',
  `invoice_id` int(11) NOT NULL,
  `item_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'Item Name',
  `item_desc` longtext COLLATE utf8_unicode_ci,
  `unit_cost` decimal(10,2) DEFAULT '0.00',
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `item_order` int(11) DEFAULT '0',
  PRIMARY KEY (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_items_saved
#

DROP TABLE IF EXISTS fx_items_saved;

CREATE TABLE `fx_items_saved` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT 'Item Name',
  `item_desc` longtext COLLATE utf8_unicode_ci,
  `unit_cost` decimal(10,2) DEFAULT '0.00',
  `item_tax_rate` decimal(10,2) DEFAULT '0.00',
  `item_tax_total` decimal(10,2) DEFAULT '0.00',
  `quantity` decimal(10,2) DEFAULT '0.00',
  `total_cost` decimal(10,2) DEFAULT '0.00',
  `deleted` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  PRIMARY KEY (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_languages
#

DROP TABLE IF EXISTS fx_languages;

CREATE TABLE `fx_languages` (
  `code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active` int(2) DEFAULT '0',
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('cs', 'czech', 'cs', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('de', 'german', 'de', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('el', 'greek', 'gr', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('en', 'english', 'us', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('es', 'spanish', 'es', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('fr', 'french', 'fr', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('it', 'italian', 'it', 0);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('nl', 'dutch', 'nl', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('no', 'norwegian', 'no', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('pl', 'polish', 'pl', 0);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('pt', 'portuguese', 'pt', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('ro', 'romanian', 'ro', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('ru', 'russian', 'ru', 1);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('sr', 'serbian', 'sr', 0);
INSERT INTO fx_languages (`code`, `name`, `icon`, `active`) VALUES ('tr', 'turkish', 'tr', 0);


#
# TABLE STRUCTURE FOR: fx_links
#

DROP TABLE IF EXISTS fx_links;

CREATE TABLE `fx_links` (
  `link_id` int(11) NOT NULL,
  `project_id` int(11) DEFAULT NULL,
  `client` int(11) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `link_title` varchar(255) DEFAULT NULL,
  `link_url` varchar(255) DEFAULT NULL,
  `description` text,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  PRIMARY KEY (`link_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: fx_locales
#

DROP TABLE IF EXISTS fx_locales;

CREATE TABLE `fx_locales` (
  `locale` varchar(10) NOT NULL,
  `code` varchar(10) DEFAULT NULL,
  `language` varchar(100) DEFAULT NULL,
  `name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('aa_DJ', 'aa', 'afar', 'Afar (Djibouti)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('aa_ER', 'aa', 'afar', 'Afar (Eritrea)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('aa_ET', 'aa', 'afar', 'Afar (Ethiopia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('af_ZA', 'af', 'afrikaans', 'Afrikaans (South Africa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('am_ET', 'am', 'amharic', 'Amharic (Ethiopia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('an_ES', 'an', 'aragonese', 'Aragonese (Spain)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_AE', 'ar', 'arabic', 'Arabic (United Arab Emirates)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_BH', 'ar', 'arabic', 'Arabic (Bahrain)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_DZ', 'ar', 'arabic', 'Arabic (Algeria)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_EG', 'ar', 'arabic', 'Arabic (Egypt)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_IN', 'ar', 'arabic', 'Arabic (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_IQ', 'ar', 'arabic', 'Arabic (Iraq)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_JO', 'ar', 'arabic', 'Arabic (Jordan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_KW', 'ar', 'arabic', 'Arabic (Kuwait)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_LB', 'ar', 'arabic', 'Arabic (Lebanon)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_LY', 'ar', 'arabic', 'Arabic (Libya)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_MA', 'ar', 'arabic', 'Arabic (Morocco)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_OM', 'ar', 'arabic', 'Arabic (Oman)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_QA', 'ar', 'arabic', 'Arabic (Qatar)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_SA', 'ar', 'arabic', 'Arabic (Saudi Arabia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_SD', 'ar', 'arabic', 'Arabic (Sudan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_SY', 'ar', 'arabic', 'Arabic (Syria)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_TN', 'ar', 'arabic', 'Arabic (Tunisia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ar_YE', 'ar', 'arabic', 'Arabic (Yemen)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ast_ES', 'ast', 'asturian', 'Asturian (Spain)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('as_IN', 'as', 'assamese', 'Assamese (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('az_AZ', 'az', 'azerbaijani', 'Azerbaijani (Azerbaijan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('az_TR', 'az', 'azerbaijani', 'Azerbaijani (Turkey)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('bem_ZM', 'bem', 'bemba', 'Bemba (Zambia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ber_DZ', 'ber', 'berber', 'Berber (Algeria)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ber_MA', 'ber', 'berber', 'Berber (Morocco)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('be_BY', 'be', 'belarusian', 'Belarusian (Belarus)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('bg_BG', 'bg', 'bulgarian', 'Bulgarian (Bulgaria)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('bn_BD', 'bn', 'bengali', 'Bengali (Bangladesh)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('bn_IN', 'bn', 'bengali', 'Bengali (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('bo_CN', 'bo', 'tibetan', 'Tibetan (China)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('bo_IN', 'bo', 'tibetan', 'Tibetan (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('br_FR', 'br', 'breton', 'Breton (France)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('bs_BA', 'bs', 'bosnian', 'Bosnian (Bosnia and Herzegovina)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('byn_ER', 'byn', 'blin', 'Blin (Eritrea)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ca_AD', 'ca', 'catalan', 'Catalan (Andorra)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ca_ES', 'ca', 'catalan', 'Catalan (Spain)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ca_FR', 'ca', 'catalan', 'Catalan (France)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ca_IT', 'ca', 'catalan', 'Catalan (Italy)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('crh_UA', 'crh', 'crimean turkish', 'Crimean Turkish (Ukraine)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('csb_PL', 'csb', 'kashubian', 'Kashubian (Poland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('cs_CZ', 'cs', 'czech', 'Czech (Czech Republic)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('cv_RU', 'cv', 'chuvash', 'Chuvash (Russia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('cy_GB', 'cy', 'welsh', 'Welsh (United Kingdom)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('da_DK', 'da', 'danish', 'Danish (Denmark)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('de_AT', 'de', 'german', 'German (Austria)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('de_BE', 'de', 'german', 'German (Belgium)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('de_CH', 'de', 'german', 'German (Switzerland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('de_DE', 'de', 'german', 'German (Germany)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('de_LI', 'de', 'german', 'German (Liechtenstein)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('de_LU', 'de', 'german', 'German (Luxembourg)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('dv_MV', 'dv', 'divehi', 'Divehi (Maldives)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('dz_BT', 'dz', 'dzongkha', 'Dzongkha (Bhutan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ee_GH', 'ee', 'ewe', 'Ewe (Ghana)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('el_CY', 'el', 'greek', 'Greek (Cyprus)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('el_GR', 'el', 'greek', 'Greek (Greece)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_AG', 'en', 'english', 'English (Antigua and Barbuda)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_AS', 'en', 'english', 'English (American Samoa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_AU', 'en', 'english', 'English (Australia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_BW', 'en', 'english', 'English (Botswana)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_CA', 'en', 'english', 'English (Canada)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_DK', 'en', 'english', 'English (Denmark)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_GB', 'en', 'english', 'English (United Kingdom)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_GU', 'en', 'english', 'English (Guam)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_HK', 'en', 'english', 'English (Hong Kong SAR China)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_IE', 'en', 'english', 'English (Ireland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_IN', 'en', 'english', 'English (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_JM', 'en', 'english', 'English (Jamaica)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_MH', 'en', 'english', 'English (Marshall Islands)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_MP', 'en', 'english', 'English (Northern Mariana Islands)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_MU', 'en', 'english', 'English (Mauritius)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_NG', 'en', 'english', 'English (Nigeria)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_NZ', 'en', 'english', 'English (New Zealand)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_PH', 'en', 'english', 'English (Philippines)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_SG', 'en', 'english', 'English (Singapore)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_TT', 'en', 'english', 'English (Trinidad and Tobago)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_US', 'en', 'english', 'English (United States)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_VI', 'en', 'english', 'English (Virgin Islands)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_ZA', 'en', 'english', 'English (South Africa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_ZM', 'en', 'english', 'English (Zambia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('en_ZW', 'en', 'english', 'English (Zimbabwe)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('eo', 'eo', 'esperanto', 'Esperanto');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_AR', 'es', 'spanish', 'Spanish (Argentina)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_BO', 'es', 'spanish', 'Spanish (Bolivia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_CL', 'es', 'spanish', 'Spanish (Chile)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_CO', 'es', 'spanish', 'Spanish (Colombia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_CR', 'es', 'spanish', 'Spanish (Costa Rica)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_DO', 'es', 'spanish', 'Spanish (Dominican Republic)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_EC', 'es', 'spanish', 'Spanish (Ecuador)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_ES', 'es', 'spanish', 'Spanish (Spain)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_GT', 'es', 'spanish', 'Spanish (Guatemala)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_HN', 'es', 'spanish', 'Spanish (Honduras)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_MX', 'es', 'spanish', 'Spanish (Mexico)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_NI', 'es', 'spanish', 'Spanish (Nicaragua)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_PA', 'es', 'spanish', 'Spanish (Panama)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_PE', 'es', 'spanish', 'Spanish (Peru)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_PR', 'es', 'spanish', 'Spanish (Puerto Rico)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_PY', 'es', 'spanish', 'Spanish (Paraguay)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_SV', 'es', 'spanish', 'Spanish (El Salvador)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_US', 'es', 'spanish', 'Spanish (United States)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_UY', 'es', 'spanish', 'Spanish (Uruguay)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('es_VE', 'es', 'spanish', 'Spanish (Venezuela)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('et_EE', 'et', 'estonian', 'Estonian (Estonia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('eu_ES', 'eu', 'basque', 'Basque (Spain)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('eu_FR', 'eu', 'basque', 'Basque (France)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fa_AF', 'fa', 'persian', 'Persian (Afghanistan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fa_IR', 'fa', 'persian', 'Persian (Iran)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ff_SN', 'ff', 'fulah', 'Fulah (Senegal)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fil_PH', 'fil', 'filipino', 'Filipino (Philippines)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fi_FI', 'fi', 'finnish', 'Finnish (Finland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fo_FO', 'fo', 'faroese', 'Faroese (Faroe Islands)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_BE', 'fr', 'french', 'French (Belgium)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_BF', 'fr', 'french', 'French (Burkina Faso)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_BI', 'fr', 'french', 'French (Burundi)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_BJ', 'fr', 'french', 'French (Benin)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_CA', 'fr', 'french', 'French (Canada)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_CF', 'fr', 'french', 'French (Central African Republic)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_CG', 'fr', 'french', 'French (Congo)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_CH', 'fr', 'french', 'French (Switzerland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_CM', 'fr', 'french', 'French (Cameroon)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_FR', 'fr', 'french', 'French (France)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_GA', 'fr', 'french', 'French (Gabon)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_GN', 'fr', 'french', 'French (Guinea)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_GP', 'fr', 'french', 'French (Guadeloupe)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_GQ', 'fr', 'french', 'French (Equatorial Guinea)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_KM', 'fr', 'french', 'French (Comoros)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_LU', 'fr', 'french', 'French (Luxembourg)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_MC', 'fr', 'french', 'French (Monaco)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_MG', 'fr', 'french', 'French (Madagascar)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_ML', 'fr', 'french', 'French (Mali)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_MQ', 'fr', 'french', 'French (Martinique)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_NE', 'fr', 'french', 'French (Niger)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_SN', 'fr', 'french', 'French (Senegal)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_TD', 'fr', 'french', 'French (Chad)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fr_TG', 'fr', 'french', 'French (Togo)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fur_IT', 'fur', 'friulian', 'Friulian (Italy)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fy_DE', 'fy', 'western frisian', 'Western Frisian (Germany)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('fy_NL', 'fy', 'western frisian', 'Western Frisian (Netherlands)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ga_IE', 'ga', 'irish', 'Irish (Ireland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('gd_GB', 'gd', 'scottish gaelic', 'Scottish Gaelic (United Kingdom)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('gez_ER', 'gez', 'geez', 'Geez (Eritrea)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('gez_ET', 'gez', 'geez', 'Geez (Ethiopia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('gl_ES', 'gl', 'galician', 'Galician (Spain)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('gu_IN', 'gu', 'gujarati', 'Gujarati (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('gv_GB', 'gv', 'manx', 'Manx (United Kingdom)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ha_NG', 'ha', 'hausa', 'Hausa (Nigeria)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('he_IL', 'he', 'hebrew', 'Hebrew (Israel)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('hi_IN', 'hi', 'hindi', 'Hindi (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('hr_HR', 'hr', 'croatian', 'Croatian (Croatia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('hsb_DE', 'hsb', 'upper sorbian', 'Upper Sorbian (Germany)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ht_HT', 'ht', 'haitian', 'Haitian (Haiti)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('hu_HU', 'hu', 'hungarian', 'Hungarian (Hungary)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('hy_AM', 'hy', 'armenian', 'Armenian (Armenia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ia', 'ia', 'interlingua', 'Interlingua');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('id_ID', 'id', 'indonesian', 'Indonesian (Indonesia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ig_NG', 'ig', 'igbo', 'Igbo (Nigeria)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ik_CA', 'ik', 'inupiaq', 'Inupiaq (Canada)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('is_IS', 'is', 'icelandic', 'Icelandic (Iceland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('it_CH', 'it', 'italian', 'Italian (Switzerland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('it_IT', 'it', 'italian', 'Italian (Italy)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('iu_CA', 'iu', 'inuktitut', 'Inuktitut (Canada)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ja_JP', 'ja', 'japanese', 'Japanese (Japan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ka_GE', 'ka', 'georgian', 'Georgian (Georgia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('kk_KZ', 'kk', 'kazakh', 'Kazakh (Kazakhstan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('kl_GL', 'kl', 'kalaallisut', 'Kalaallisut (Greenland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('km_KH', 'km', 'khmer', 'Khmer (Cambodia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('kn_IN', 'kn', 'kannada', 'Kannada (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('kok_IN', 'kok', 'konkani', 'Konkani (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ko_KR', 'ko', 'korean', 'Korean (South Korea)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ks_IN', 'ks', 'kashmiri', 'Kashmiri (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ku_TR', 'ku', 'kurdish', 'Kurdish (Turkey)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('kw_GB', 'kw', 'cornish', 'Cornish (United Kingdom)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ky_KG', 'ky', 'kirghiz', 'Kirghiz (Kyrgyzstan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('lg_UG', 'lg', 'ganda', 'Ganda (Uganda)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('li_BE', 'li', 'limburgish', 'Limburgish (Belgium)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('li_NL', 'li', 'limburgish', 'Limburgish (Netherlands)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('lo_LA', 'lo', 'lao', 'Lao (Laos)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('lt_LT', 'lt', 'lithuanian', 'Lithuanian (Lithuania)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('lv_LV', 'lv', 'latvian', 'Latvian (Latvia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('mai_IN', 'mai', 'maithili', 'Maithili (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('mg_MG', 'mg', 'malagasy', 'Malagasy (Madagascar)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('mi_NZ', 'mi', 'maori', 'Maori (New Zealand)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('mk_MK', 'mk', 'macedonian', 'Macedonian (Macedonia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ml_IN', 'ml', 'malayalam', 'Malayalam (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('mn_MN', 'mn', 'mongolian', 'Mongolian (Mongolia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('mr_IN', 'mr', 'marathi', 'Marathi (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ms_BN', 'ms', 'malay', 'Malay (Brunei)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ms_MY', 'ms', 'malay', 'Malay (Malaysia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('mt_MT', 'mt', 'maltese', 'Maltese (Malta)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('my_MM', 'my', 'burmese', 'Burmese (Myanmar)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('naq_NA', 'naq', 'namibia', 'Namibia');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('nb_NO', 'nb', 'norwegian bokmÃ¥l', 'Norwegian BokmÃ¥l (Norway)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('nds_DE', 'nds', 'low german', 'Low German (Germany)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('nds_NL', 'nds', 'low german', 'Low German (Netherlands)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ne_NP', 'ne', 'nepali', 'Nepali (Nepal)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('nl_AW', 'nl', 'dutch', 'Dutch (Aruba)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('nl_BE', 'nl', 'dutch', 'Dutch (Belgium)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('nl_NL', 'nl', 'dutch', 'Dutch (Netherlands)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('nn_NO', 'nn', 'norwegian nynorsk', 'Norwegian Nynorsk (Norway)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('no_NO', 'no', 'norwegian', 'Norwegian (Norway)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('nr_ZA', 'nr', 'south ndebele', 'South Ndebele (South Africa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('nso_ZA', 'nso', 'northern sotho', 'Northern Sotho (South Africa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('oc_FR', 'oc', 'occitan', 'Occitan (France)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('om_ET', 'om', 'oromo', 'Oromo (Ethiopia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('om_KE', 'om', 'oromo', 'Oromo (Kenya)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('or_IN', 'or', 'oriya', 'Oriya (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('os_RU', 'os', 'ossetic', 'Ossetic (Russia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('pap_AN', 'pap', 'papiamento', 'Papiamento (Netherlands Antilles)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('pa_IN', 'pa', 'punjabi', 'Punjabi (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('pa_PK', 'pa', 'punjabi', 'Punjabi (Pakistan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('pl_PL', 'pl', 'polish', 'Polish (Poland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ps_AF', 'ps', 'pashto', 'Pashto (Afghanistan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('pt_BR', 'pt', 'portuguese', 'Portuguese (Brazil)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('pt_GW', 'pt', 'portuguese', 'Portuguese (Guinea-Bissau)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('pt_PT', 'pt', 'portuguese', 'Portuguese (Portugal)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ro_MD', 'ro', 'romanian', 'Romanian (Moldova)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ro_RO', 'ro', 'romanian', 'Romanian (Romania)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ru_RU', 'ru', 'russian', 'Russian (Russia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ru_UA', 'ru', 'russian', 'Russian (Ukraine)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('rw_RW', 'rw', 'kinyarwanda', 'Kinyarwanda (Rwanda)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sa_IN', 'sa', 'sanskrit', 'Sanskrit (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sc_IT', 'sc', 'sardinian', 'Sardinian (Italy)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sd_IN', 'sd', 'sindhi', 'Sindhi (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('seh_MZ', 'seh', 'sena', 'Sena (Mozambique)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('se_NO', 'se', 'northern sami', 'Northern Sami (Norway)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sid_ET', 'sid', 'sidamo', 'Sidamo (Ethiopia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('si_LK', 'si', 'sinhala', 'Sinhala (Sri Lanka)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sk_SK', 'sk', 'slovak', 'Slovak (Slovakia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sl_SI', 'sl', 'slovenian', 'Slovenian (Slovenia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sn_ZW', 'sn', 'shona', 'Shona (Zimbabwe)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('so_DJ', 'so', 'somali', 'Somali (Djibouti)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('so_ET', 'so', 'somali', 'Somali (Ethiopia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('so_KE', 'so', 'somali', 'Somali (Kenya)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('so_SO', 'so', 'somali', 'Somali (Somalia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sq_AL', 'sq', 'albanian', 'Albanian (Albania)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sq_MK', 'sq', 'albanian', 'Albanian (Macedonia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sr_BA', 'sr', 'serbian', 'Serbian (Bosnia and Herzegovina)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sr_ME', 'sr', 'serbian', 'Serbian (Montenegro)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sr_RS', 'sr', 'serbian', 'Serbian (Serbia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ss_ZA', 'ss', 'swati', 'Swati (South Africa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('st_ZA', 'st', 'southern sotho', 'Southern Sotho (South Africa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sv_FI', 'sv', 'swedish', 'Swedish (Finland)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sv_SE', 'sv', 'swedish', 'Swedish (Sweden)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sw_KE', 'sw', 'swahili', 'Swahili (Kenya)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('sw_TZ', 'sw', 'swahili', 'Swahili (Tanzania)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ta_IN', 'ta', 'tamil', 'Tamil (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('teo_UG', 'teo', 'teso', 'Teso (Uganda)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('te_IN', 'te', 'telugu', 'Telugu (India)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('tg_TJ', 'tg', 'tajik', 'Tajik (Tajikistan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('th_TH', 'th', 'thai', 'Thai (Thailand)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('tig_ER', 'tig', 'tigre', 'Tigre (Eritrea)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ti_ER', 'ti', 'tigrinya', 'Tigrinya (Eritrea)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ti_ET', 'ti', 'tigrinya', 'Tigrinya (Ethiopia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('tk_TM', 'tk', 'turkmen', 'Turkmen (Turkmenistan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('tl_PH', 'tl', 'tagalog', 'Tagalog (Philippines)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('tn_ZA', 'tn', 'tswana', 'Tswana (South Africa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('to_TO', 'to', 'tongan', 'Tongan (Tonga)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('tr_CY', 'tr', 'turkish', 'Turkish (Cyprus)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('tr_TR', 'tr', 'turkish', 'Turkish (Turkey)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ts_ZA', 'ts', 'tsonga', 'Tsonga (South Africa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('tt_RU', 'tt', 'tatar', 'Tatar (Russia)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ug_CN', 'ug', 'uighur', 'Uighur (China)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('uk_UA', 'uk', 'ukrainian', 'Ukrainian (Ukraine)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ur_PK', 'ur', 'urdu', 'Urdu (Pakistan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('uz_UZ', 'uz', 'uzbek', 'Uzbek (Uzbekistan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('ve_ZA', 've', 'venda', 'Venda (South Africa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('vi_VN', 'vi', 'vietnamese', 'Vietnamese (Vietnam)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('wa_BE', 'wa', 'walloon', 'Walloon (Belgium)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('wo_SN', 'wo', 'wolof', 'Wolof (Senegal)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('xh_ZA', 'xh', 'xhosa', 'Xhosa (South Africa)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('yi_US', 'yi', 'yiddish', 'Yiddish (United States)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('yo_NG', 'yo', 'yoruba', 'Yoruba (Nigeria)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('zh_CN', 'zh', 'chinese', 'Chinese (China)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('zh_HK', 'zh', 'chinese', 'Chinese (Hong Kong SAR China)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('zh_SG', 'zh', 'chinese', 'Chinese (Singapore)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('zh_TW', 'zh', 'chinese', 'Chinese (Taiwan)');
INSERT INTO fx_locales (`locale`, `code`, `language`, `name`) VALUES ('zu_ZA', 'zu', 'zulu', 'Zulu (South Africa)');


#
# TABLE STRUCTURE FOR: fx_login_attempts
#

DROP TABLE IF EXISTS fx_login_attempts;

CREATE TABLE `fx_login_attempts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(40) NOT NULL,
  `login` varchar(50) NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: fx_messages
#

DROP TABLE IF EXISTS fx_messages;

CREATE TABLE `fx_messages` (
  `msg_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_to` int(11) DEFAULT NULL,
  `user_from` int(11) DEFAULT NULL,
  `message` mediumtext COLLATE utf8_unicode_ci,
  `status` enum('Read','Unread') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Unread',
  `attached_file` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_received` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `favourite` int(11) DEFAULT '0',
  `deleted` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  PRIMARY KEY (`msg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_milestones
#

DROP TABLE IF EXISTS fx_milestones;

CREATE TABLE `fx_milestones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `milestone_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `project` int(11) DEFAULT NULL,
  `start_date` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `due_date` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_payment_methods
#

DROP TABLE IF EXISTS fx_payment_methods;

CREATE TABLE `fx_payment_methods` (
  `method_id` int(11) NOT NULL AUTO_INCREMENT,
  `method_name` varchar(64) NOT NULL DEFAULT 'Paypal',
  PRIMARY KEY (`method_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO fx_payment_methods (`method_id`, `method_name`) VALUES (1, 'Online');
INSERT INTO fx_payment_methods (`method_id`, `method_name`) VALUES (2, 'Cash');
INSERT INTO fx_payment_methods (`method_id`, `method_name`) VALUES (3, 'Bank Deposit');
INSERT INTO fx_payment_methods (`method_id`, `method_name`) VALUES (5, 'Cheque');


#
# TABLE STRUCTURE FOR: fx_payments
#

DROP TABLE IF EXISTS fx_payments;

CREATE TABLE `fx_payments` (
  `p_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice` int(11) NOT NULL,
  `paid_by` int(11) NOT NULL,
  `payer_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_method` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency` varchar(64) COLLATE utf8_unicode_ci DEFAULT 'USD',
  `amount` longtext COLLATE utf8_unicode_ci,
  `trans_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_date` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `month_paid` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `year_paid` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inv_deleted` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  PRIMARY KEY (`p_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_permissions
#

DROP TABLE IF EXISTS fx_permissions;

CREATE TABLE `fx_permissions` (
  `permission_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive','deleted') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`permission_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (1, 'view_all_invoices', 'Allow user access to view all invoices', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (2, 'edit_all_invoices', 'Allow user access to edit all invoices', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (3, 'add_invoices', 'Allow user access to add invoices', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (4, 'delete_invoices', 'Allow user access to delete invoice', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (5, 'pay_invoice_offline', 'Allow user access to make offline Invoice Payments', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (6, 'view_payments', 'Allow user access to view own payments', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (7, 'email_invoices', 'Allow user access to email invoices', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (8, 'send_email_reminders', 'Allow user access to send invoice reminders', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (9, 'add_estimates', 'Allow user access to add estimates', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (10, 'edit_estimates', 'Allow user access to edit all estimates', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (11, 'view_all_estimates', 'Allow user access to view all estimates', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (12, 'delete_estimates', 'Allow user access to delete estimates', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (17, 'view_all_projects', 'Allow user access to view all projects', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (18, 'view_project_cost', 'Allow user access to view project cost', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (19, 'add_projects', 'Allow user access to add projects', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (20, 'edit_all_projects', 'Allow user access to edit projects', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (22, 'delete_projects', 'Allow user access to delete projects', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (23, 'edit_settings', 'Allow user access to edit all settings', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (25, 'view_project_clients', 'Allow staff to view project\'s clients', 'active');
INSERT INTO fx_permissions (`permission_id`, `name`, `description`, `status`) VALUES (26, 'view_project_notes', 'Allow staff to view project notes', 'active');


#
# TABLE STRUCTURE FOR: fx_priorities
#

DROP TABLE IF EXISTS fx_priorities;

CREATE TABLE `fx_priorities` (
  `priority` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO fx_priorities (`priority`) VALUES ('Low');
INSERT INTO fx_priorities (`priority`) VALUES ('Medium');
INSERT INTO fx_priorities (`priority`) VALUES ('High');


#
# TABLE STRUCTURE FOR: fx_project_settings
#

DROP TABLE IF EXISTS fx_project_settings;

CREATE TABLE `fx_project_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO fx_project_settings (`id`, `setting`, `description`) VALUES (1, 'show_team_members', 'Allow client to view team members');
INSERT INTO fx_project_settings (`id`, `setting`, `description`) VALUES (2, 'show_milestones', 'Allow client to view project milestones');
INSERT INTO fx_project_settings (`id`, `setting`, `description`) VALUES (5, 'show_project_tasks', 'Allow client to view project tasks');
INSERT INTO fx_project_settings (`id`, `setting`, `description`) VALUES (6, 'show_project_files', 'Allow client to view project files');
INSERT INTO fx_project_settings (`id`, `setting`, `description`) VALUES (7, 'show_timesheets', 'Allow clients to view project timesheets');
INSERT INTO fx_project_settings (`id`, `setting`, `description`) VALUES (8, 'show_project_bugs', 'Allow client to view project bugs');
INSERT INTO fx_project_settings (`id`, `setting`, `description`) VALUES (9, 'show_project_history', 'Allow client to view project history');
INSERT INTO fx_project_settings (`id`, `setting`, `description`) VALUES (10, 'show_project_calendar', 'Allow clients to view project calendars');
INSERT INTO fx_project_settings (`id`, `setting`, `description`) VALUES (11, 'show_project_comments', 'Allow clients to view project comments');
INSERT INTO fx_project_settings (`id`, `setting`, `description`) VALUES (12, 'show_project_links', 'Allow client to view project links');


#
# TABLE STRUCTURE FOR: fx_project_timer
#

DROP TABLE IF EXISTS fx_project_timer;

CREATE TABLE `fx_project_timer` (
  `timer_id` int(11) NOT NULL AUTO_INCREMENT,
  `project` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `start_time` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `end_time` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_timed` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`timer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_projects
#

DROP TABLE IF EXISTS fx_projects;

CREATE TABLE `fx_projects` (
  `project_id` int(11) NOT NULL AUTO_INCREMENT,
  `project_code` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `project_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'Project Title',
  `description` longtext COLLATE utf8_unicode_ci,
  `client` int(11) NOT NULL,
  `start_date` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `due_date` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fixed_rate` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `hourly_rate` decimal(10,2) DEFAULT '0.00',
  `fixed_price` decimal(10,2) DEFAULT '0.00',
  `progress` int(11) DEFAULT '0',
  `notes` longtext COLLATE utf8_unicode_ci,
  `assign_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('On Hold','Active','Done') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Active',
  `timer` enum('On','Off') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Off',
  `timer_started_by` int(11) DEFAULT NULL,
  `timer_start` int(11) DEFAULT NULL,
  `time_logged` int(11) DEFAULT NULL,
  `proj_deleted` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `archived` int(11) DEFAULT '0',
  `auto_progress` enum('TRUE','FALSE') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'FALSE',
  `estimate_hours` decimal(10,2) NOT NULL DEFAULT '0.00',
  `settings` text COLLATE utf8_unicode_ci,
  `currency` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_roles
#

DROP TABLE IF EXISTS fx_roles;

CREATE TABLE `fx_roles` (
  `r_id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(64) NOT NULL,
  `default` int(11) NOT NULL,
  `permissions` varchar(255) NOT NULL,
  PRIMARY KEY (`r_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO fx_roles (`r_id`, `role`, `default`, `permissions`) VALUES (1, 'admin', 1, '{\"settings\":\"permissions\",\"role\":\"admin\",\"view_all_invoices\":\"on\",\"edit_invoices\":\"on\",\"pay_invoice_offline\":\"on\",\"view_all_payments\":\"on\",\"email_invoices\":\"on\",\"send_email_reminders\":\"on\"}');
INSERT INTO fx_roles (`r_id`, `role`, `default`, `permissions`) VALUES (2, 'client', 2, '{\"settings\":\"permissions\",\"role\":\"client\"}');
INSERT INTO fx_roles (`r_id`, `role`, `default`, `permissions`) VALUES (3, 'staff', 3, '{\"settings\":\"permissions\",\"role\":\"staff\",\"view_all_invoices\":\"on\",\"edit_invoices\":\"on\",\"add_invoices\":\"on\",\"pay_invoice_offline\":\"on\",\"send_email_reminders\":\"on\"}');


#
# TABLE STRUCTURE FOR: fx_saved_tasks
#

DROP TABLE IF EXISTS fx_saved_tasks;

CREATE TABLE `fx_saved_tasks` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT 'Task Name',
  `task_desc` text COLLATE utf8_unicode_ci,
  `visible` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Yes',
  `estimate_hours` decimal(10,2) DEFAULT '0.00',
  `added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `saved_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_status
#

DROP TABLE IF EXISTS fx_status;

CREATE TABLE `fx_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO fx_status (`id`, `status`) VALUES (1, 'answered');
INSERT INTO fx_status (`id`, `status`) VALUES (2, 'closed');
INSERT INTO fx_status (`id`, `status`) VALUES (3, 'open');
INSERT INTO fx_status (`id`, `status`) VALUES (5, 'in progress');


#
# TABLE STRUCTURE FOR: fx_task_files
#

DROP TABLE IF EXISTS fx_task_files;

CREATE TABLE `fx_task_files` (
  `file_id` int(11) NOT NULL AUTO_INCREMENT,
  `task` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `path` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` mediumtext COLLATE utf8_unicode_ci,
  `file_ext` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `is_image` int(2) DEFAULT NULL,
  `image_width` int(10) DEFAULT NULL,
  `image_height` int(10) DEFAULT NULL,
  `original_name` mediumtext COLLATE utf8_unicode_ci,
  `file_status` enum('unconfirmed','confirmed','in_progress','done','verified') COLLATE utf8_unicode_ci DEFAULT 'unconfirmed',
  `uploaded_by` int(11) DEFAULT NULL,
  `date_posted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_tasks
#

DROP TABLE IF EXISTS fx_tasks;

CREATE TABLE `fx_tasks` (
  `t_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'Task Name',
  `project` int(11) NOT NULL,
  `milestone` int(11) DEFAULT NULL,
  `assigned_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `visible` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Yes',
  `task_progress` int(11) DEFAULT '0',
  `timer_status` enum('On','Off') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Off',
  `timer_started_by` int(11) DEFAULT NULL,
  `start_time` int(11) DEFAULT NULL,
  `estimated_hours` decimal(10,2) DEFAULT NULL,
  `logged_time` int(11) NOT NULL DEFAULT '0',
  `auto_progress` enum('TRUE','FALSE') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'FALSE',
  `due_date` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `added_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`t_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_tasks_timer
#

DROP TABLE IF EXISTS fx_tasks_timer;

CREATE TABLE `fx_tasks_timer` (
  `timer_id` int(11) NOT NULL AUTO_INCREMENT,
  `task` int(11) NOT NULL,
  `pro_id` int(11) NOT NULL,
  `start_time` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `end_time` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` int(11) DEFAULT NULL,
  `date_timed` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`timer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_tax_rates
#

DROP TABLE IF EXISTS fx_tax_rates;

CREATE TABLE `fx_tax_rates` (
  `tax_rate_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_rate_name` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `tax_rate_percent` decimal(10,2) NOT NULL DEFAULT '0.00',
  KEY `Index 1` (`tax_rate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_ticketreplies
#

DROP TABLE IF EXISTS fx_ticketreplies;

CREATE TABLE `fx_ticketreplies` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ticketid` int(10) DEFAULT NULL,
  `body` text COLLATE utf8_unicode_ci,
  `replier` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `replierid` int(10) DEFAULT NULL,
  `attachment` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_tickets
#

DROP TABLE IF EXISTS fx_tickets;

CREATE TABLE `fx_tickets` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ticket_code` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8_unicode_ci,
  `status` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department` int(11) DEFAULT NULL,
  `reporter` int(10) DEFAULT '0',
  `priority` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `additional` text COLLATE utf8_unicode_ci,
  `attachment` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `archived_t` int(2) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: fx_un_sessions
#

DROP TABLE IF EXISTS fx_un_sessions;

CREATE TABLE `fx_un_sessions` (
  `session_id` varchar(40) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '0',
  `ip_address` varchar(16) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '0',
  `user_agent` varchar(150) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `last_activity` int(10) unsigned NOT NULL DEFAULT '0',
  `user_data` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO fx_un_sessions (`session_id`, `ip_address`, `user_agent`, `last_activity`, `user_data`) VALUES ('4c09054f1011c1908bd57899038f3895', '127.0.0.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:39.0) Gecko/20100101 Firefox/39.0', 1437385344, 'a:7:{s:9:\"user_data\";s:0:\"\";s:7:\"user_id\";s:1:\"1\";s:8:\"username\";s:5:\"admin\";s:7:\"role_id\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:14:\"requested_page\";s:46:\"http://localhost/management/updates/view/50624\";s:13:\"previous_page\";s:46:\"http://localhost/management/updates/view/50624\";}');
INSERT INTO fx_un_sessions (`session_id`, `ip_address`, `user_agent`, `last_activity`, `user_data`) VALUES ('9397cd629b5c26d63bdbb5c001fbd802', '127.0.0.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:39.0) Gecko/20100101 Firefox/39.0', 1437385988, 'a:7:{s:9:\"user_data\";s:0:\"\";s:7:\"user_id\";s:1:\"1\";s:8:\"username\";s:5:\"admin\";s:7:\"role_id\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:14:\"requested_page\";s:42:\"http://localhost/management/updates/backup\";s:13:\"previous_page\";s:35:\"http://localhost/management/updates\";}');


#
# TABLE STRUCTURE FOR: fx_updates
#

DROP TABLE IF EXISTS fx_updates;

CREATE TABLE `fx_updates` (
  `build` int(11) NOT NULL DEFAULT '0',
  `code` varchar(50) DEFAULT NULL,
  `date` timestamp NULL DEFAULT NULL,
  `version` varchar(10) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `filename` varchar(255) DEFAULT NULL,
  `importance` enum('low','medium','high') DEFAULT 'low',
  `dependencies` varchar(255) DEFAULT NULL,
  `installed` int(11) DEFAULT '0',
  `sql` text,
  `files` text,
  `depends` varchar(255) DEFAULT NULL,
  `includes` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`build`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO fx_updates (`build`, `code`, `date`, `version`, `title`, `description`, `filename`, `importance`, `dependencies`, `installed`, `sql`, `files`, `depends`, `includes`) VALUES (50624, 'hotfix', '2015-07-19 22:22:01', '1.7.1', 'Cumulative bug fix update', 'Changelog<br/><br/>\r\n- Fix: Invoice item delete 404 error<br/>\r\n- Fix: Task editable by client through milestone<br/>\r\n- Fix: Username color change for update notification only visible to admin<br/>\r\n- Fix: Inheritance of language and locale to new users<br/>\r\n- Fix: Display default language in dashboard chart<br/>\r\n- Fix: Error in saving items because of extra field item_name_auto<br/>\r\n- Fix: Dashboard avatars for unassigned tasks<br/>\r\n- Fix: Calendar JS error when description contains single quote<br/>\r\n- Fix: Main calendar showing all tasks on the project due date<br/>\r\n- Fix: Typeahead script error<br/>\r\n- Fix: Company update redirect error<br/>\r\n- Fix: Login page not in default language<br/>\r\n- Fix: Translated invoice status for staff and payment status for admins<br/>\r\n- Fix: Insert item popup in estimates doesn\'t appear<br/>\r\n- Fix: Line breaks in update description<br/>', 'update-50624.zip', 'high', '{\"depends\":\"\",\"includes\":\"50622\"}', 1, NULL, NULL, NULL, NULL);
INSERT INTO fx_updates (`build`, `code`, `date`, `version`, `title`, `description`, `filename`, `importance`, `dependencies`, `installed`, `sql`, `files`, `depends`, `includes`) VALUES (50626, 'hotfix', '2015-07-19 22:22:01', '1.7.1', 'Cumulative bug fix update 2', 'Changelog<br/><br/>\r\n- Fix: mPDF hide item tax in invoices and estimates<br/>\r\n- Fix: Changed all external links protocol to https<br/>\r\n- Feature: Tooltips for main calendar<br/>\r\n- Fix: Added currency symbol to all amounts in invoice<br/>\r\n- Fix: Removed remote checks from updates page for faster loading<br/>\r\n- Fix: Reversed previous changes in invoice status<br/>\r\n- Fix: Reversed previous change in quantity number format<br/>\r\n- Fix: Typeahead items 404 when there is no edit field<br/>\r\n- Fix: Unassigned bug error<br/>\r\n- Feature: Added Romanian currency<br/>\r\n- Fix: Limit dashboard activities to 10<br/>\r\n- Fix: dataTables empty translation<br/>\r\n- Fix: Mobile menu hidden under elements<br/>\r\n- Fix: Dashboard projects table row height issue<br/>\r\n- Fix: Mobile menu hidden under elements<br/>\r\n- Fix: Dashboard projects table row height issue<br/>\r\n- Fix: User menu background in mobile view<br/>', 'update-50626.zip', 'high', '{\"depends\":\"\",\"includes\":\"\"}', 1, NULL, NULL, NULL, NULL);
INSERT INTO fx_updates (`build`, `code`, `date`, `version`, `title`, `description`, `filename`, `importance`, `dependencies`, `installed`, `sql`, `files`, `depends`, `includes`) VALUES (50706, 'release', '2015-07-19 22:22:01', '1.7.1', 'Version 1.7.2: Updates & bug fixes', '<strong>IMPORTANT</strong><br/>\r\n1. Back up your translations (second button in translations list)<br/>\r\n2. Copy your custom CSS and reapply it after the update (we will overwrite style.css for the last time to ensure no old code remains)<br/>\r\n3. After installation set the invoice logo size from Settings > Invoice Settings\r\n<br/><br/>\r\nChangelog at <a href=\"http://codecanyon.net/item/freelancer-office/8870728\">Freelancer Office on CodeCanyon</a>.', 'update-50706.zip', 'high', '{\"depends\":\"\",\"includes\":\"50624,50626\"}', 1, NULL, NULL, NULL, NULL);
INSERT INTO fx_updates (`build`, `code`, `date`, `version`, `title`, `description`, `filename`, `importance`, `dependencies`, `installed`, `sql`, `files`, `depends`, `includes`) VALUES (50714, 'hotfix', '2015-07-19 22:22:01', '1.7.1', 'UPDATED! Re-install! Version 1.7.3', '<strong>IMPORTANT</strong><br/><br/>\r\n<strong>If you have problems with auto-update replace the file at<br/>\r\n/application/modules/updates/views/modal/view_update.php<br/>\r\nwith the file in the archive <a href=\"http://gitbench.com/updates/folite/view_update.zip\" target=\"_blank\">view_update.zip</a> and re-install</strong><br/><br/>\r\n1. Back up your translations (second button in translations list)<br/>\r\n2. After installation set the invoice logo size from Settings > Invoice Settings<br/>\r\n<br/>\r\nChangelog<br/>\r\n<br/>\r\n- Feature: Hide FO branding (Settings>Themes)<br/>\r\n- Feature: Login title (Settings>Themes)<br/>\r\n- Feature: Currency symbol position and decimal settings for currency/quantity/tax (Settings>System)\r\n- Feature: Estimate and invoice footer in PDF(Settings>Invoices/Estimates)<br/>\r\n- Update: Added Croatian and Serbian language<br/>\r\n- Fix: Customer online registration causing PHP errors when client is not assigned to a company<br/>\r\n- Fix: Multicurrency amounts are converted to the default currency for home charts / currencies are auto-updated daily<br/>\r\n- Fix: Duplicate labels in invoice list<br/>\r\n- Fix: Followlocation error when safe_mode or open_basedir are enabled<br/>\r\n- Fix: Translations showing wrong completed percentage and auth_tank strings<br/>\r\n<br/>\r\nMore small bug fixes and tweaks', 'update-50713.zip', 'high', '{\"depends\":\"\",\"includes\":\"\"}', 1, NULL, NULL, NULL, NULL);
INSERT INTO fx_updates (`build`, `code`, `date`, `version`, `title`, `description`, `filename`, `importance`, `dependencies`, `installed`, `sql`, `files`, `depends`, `includes`) VALUES (50716, 'hotfix', '2015-07-20 11:55:15', '1.7.3', 'UPDATED! Re-install! Version 1.7.3', '<strong>IMPORTANT</strong><br/><br/>\r\n<strong>If you have problems with auto-update replace the file at<br/>\r\n/application/modules/updates/views/modal/view_update.php<br/>\r\nwith the file in the archive <a href=\"http://gitbench.com/updates/folite/view_update.zip\" target=\"_blank\">view_update.zip</a> and re-install</strong><br/><br/>\r\n1. Back up your translations (second button in translations list)<br/>\r\n2. After installation set the invoice logo size from Settings > Invoice Settings<br/>\r\n<br/>\r\nChangelog<br/>\r\n<br/>\r\n- Feature: Hide FO branding (Settings>Themes)<br/>\r\n- Feature: Login title (Settings>Themes)<br/>\r\n- Feature: Currency symbol position and decimal settings for currency/quantity/tax (Settings>System)\r\n- Feature: Estimate and invoice footer in PDF(Settings>Invoices/Estimates)<br/>\r\n- Update: Added Croatian and Serbian language<br/>\r\n- Fix: Customer online registration causing PHP errors when client is not assigned to a company<br/>\r\n- Fix: Multicurrency amounts are converted to the default currency for home charts / currencies are auto-updated daily<br/>\r\n- Fix: Duplicate labels in invoice list<br/>\r\n- Fix: Followlocation error when safe_mode or open_basedir are enabled<br/>\r\n- Fix: Translations showing wrong completed percentage and auth_tank strings<br/>\r\n<br/>\r\nMore small bug fixes and tweaks', 'update-50714.zip', 'high', '{\"depends\":\"\",\"includes\":\"\"}', 1, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: fx_user_autologin
#

DROP TABLE IF EXISTS fx_user_autologin;

CREATE TABLE `fx_user_autologin` (
  `key_id` char(32) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `user_agent` varchar(150) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `last_ip` varchar(40) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `last_login` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`key_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: fx_users
#

DROP TABLE IF EXISTS fx_users;

CREATE TABLE `fx_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `role_id` int(11) NOT NULL DEFAULT '2',
  `activated` tinyint(1) NOT NULL DEFAULT '1',
  `banned` tinyint(1) NOT NULL DEFAULT '0',
  `ban_reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `new_password_key` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `new_password_requested` datetime DEFAULT NULL,
  `new_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `new_email_key` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_ip` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_login` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO fx_users (`id`, `username`, `password`, `email`, `role_id`, `activated`, `banned`, `ban_reason`, `new_password_key`, `new_password_requested`, `new_email`, `new_email_key`, `last_ip`, `last_login`, `created`, `modified`) VALUES (1, 'admin', '$P$BF/6v2Lu4uG7eT4qJZiM/2wkwJYHqN.', 'wm@gitbench.com', 1, 1, 0, NULL, NULL, NULL, NULL, NULL, '127.0.0.1', '2015-07-20 11:47:53', '2015-03-11 22:09:23', '2015-07-20 10:47:53');


