{include file="header.tpl"}
<script type="text/javascript" src="{$templateurl}js/tinymce/tinymce.min.js"></script>
{literal}
<script>
tinymce.init({
    selector: "textarea",
    theme: "modern",

    height: 150,
    plugins: [
         "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
         "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
         "save table contextmenu directionality emoticons template paste textcolor"
   ],
   content_css: "css/content.css",
   toolbar: "styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist | link image | print preview media fullpage | forecolor backcolor", 
   style_formats: [
        {title: 'Bold text', inline: 'b'},
        {title: 'Red text', inline: 'span', styles: {color: '#ff0000'}},
        {title: 'Red header', block: 'h1', styles: {color: '#ff0000'}},
        {title: 'Example 1', inline: 'span', classes: 'example1'},
        {title: 'Example 2', inline: 'span', classes: 'example2'},
        {title: 'Table styles'},
        {title: 'Table row 1', selector: 'tr', classes: 'tablerow1'}
    ]
 }); 
</script>
{/literal}
 <div id="container">
    <div class="row">

      <div class="col-1-4">
	    <div class="sidebar">
	      {include file="user_menu.tpl"}
		  </div>
		</div>
	  {if $smarty.get.edit}
      <div class="col-3-4">
	  <h2>Edit Article</h2>
      {if $message}<div class="message">{$message}</div>{/if}
	  </div>
	   <div class="col-3-4">
	    <div class="content">
            <form action="" method="post">
				<table width="100%">
					<tr>
						<td><input type="text" name="title" value="{'docs'|data:'id':$smarty.get.edit:'title'}" placeholder="Article Name..." required/></td>
					</tr>
					<tr>
						<td>
						<select type="select" name="product" required onChange="getCat('get.cat_r.php?product='+this.value,'category')">
						<option value="">Select Product</option>
							{foreach from=$products item=prod}
								<option value="{$prod.id}" {if 'docs'|data:'id':$smarty.get.edit:'software' eq $prod.id}selected{/if}>{$prod.name}</option>
							{/foreach}
						</select>
						</td>
					</tr>
					<tr id="category">
					<td>
					<select type="select" name="category" required onChange="getCat('get.scat.php?category='+this.value,'subcategory')">
						<option value="">Select Category</option>
							{foreach from=$category item=cat}
								<option value="{$cat.id}" {if 'docs'|data:'id':$smarty.get.edit:'category' eq $cat.id}selected{/if}>{$cat.name}</option>
							{/foreach}
						</select>
						
						</td>
					</tr>
					<tr id="subcategory">
					<td>
					<select type="select" name="subcategory" required>
						<option value="">Select Subcategory</option>
							{foreach from=$subcategory item=scat}
								<option value="{$scat.id}" {if 'docs'|data:'id':$smarty.get.edit:'subcategory' eq $scat.id}selected{/if}>{$scat.name}</option>
							{/foreach}
						</select>
						
						</td>
					</tr>
					<tr>
						<td><textarea type="textarea" name="text" placeholder="Article text...">{'docs'|data:'id':$smarty.get.edit:'text'}</textarea>
						<span>Use &lt;pre> your code &lt;/pre> to insert code. </span>
						</td>
						
					</tr>
					<tr>
						<td>Article Level</td>
					</tr>
					<tr>
						<td>
						<select type="select" name="level" required>
						<option value="1" {if 'docs'|data:'id':$smarty.get.edit:'level' eq '1'}selected{/if}>Public</option>
						<option value="2" {if 'docs'|data:'id':$smarty.get.edit:'level' eq '2'}selected{/if}>Editors only</option>
						</select>
						</td>
					</tr>
					{if 'docs'|data:'id':$smarty.get.edit:'status' eq '1'}
					<tr>
						<td>Article Status</td>
					</tr>
					<tr>
						<td>
						<select type="select" name="status" required>
						<option value="1" {if 'docs'|data:'id':$smarty.get.edit:'status' eq '1'}selected{/if}>Published</option>
						<option value="2" {if 'docs'|data:'id':$smarty.get.edit:'status' eq '2'}selected{/if}>Draft</option>
						</select>
						</td>
					</tr>
					{/if}
					{if 'docs'|data:'id':$smarty.get.edit:'status' eq '1' and 'docs_editors'|data:'id':$user_id:'level' eq '1'}
					<tr>
						<td>Editor access</td>
					</tr>
					<tr>
						<td>
						<select type="select" name="access" required>
						<option value="1" {if 'docs'|data:'id':$smarty.get.edit:'access' eq '1'}selected{/if}>Admin Only</option>
						<option value="2" {if 'docs'|data:'id':$smarty.get.edit:'access' eq '2'}selected{/if}>Admin and Editors</option>
						</select>
						</td>
					</tr>
					{/if}
					<tr>
						<td><input type="submit" name="edit" value="Edit Article"/></td>
					</tr>
				</table>
			</form>
	
		</div>
	  </div>
    {elseif $smarty.get.add}
 
	  
      <div class="col-3-4">
	  <h2>Add Article</h2>
      {if $message}<div class="message">{$message}</div>{/if}
	  </div>
	  <div class="col-3-4">
	    <div class="content">
            <form action="" method="post">
				<table width="100%">
					<tr>
						<td><input type="text" name="title" value="{$smarty.post.name}" placeholder="Article Name..." required/></td>
					</tr>
					<tr>
						<td>
						<select type="select" name="product" required onChange="getCat('get.cat_r.php?product='+this.value,'category')">
						<option value="">Select Product</option>
							{foreach from=$products item=prod}
								<option value="{$prod.id}">{$prod.name}</option>
							{/foreach}
						</select>
						</td>
					</tr>
					<tr id="category">
					</tr>
					<tr id="subcategory">
					</tr>
					<tr>
						<td><textarea type="textarea" name="text" placeholder="Article text...">{$smarty.post.descr}</textarea>
						<span>Use &lt;pre> your code &lt;/pre> to insert code. </span>
						</td>
					</tr>
					<tr>
						<td>Article Level</td>
					</tr>
					<tr>
						<td>
						<select type="select" name="level" required>
						<option value="1">Public</option>
						<option value="2">Editors only</option>
						</select>
						</td>
					</tr>
					{if 'docs_editors'|data:'id':$user_id:'level' eq '1'}
					<tr>
						<td>Article Status</td>
					</tr>
					<tr>
						<td>
						<select type="select" name="status" required>
						<option value="1">Published</option>
						<option value="2">Draft</option>
						</select>
						</td>
					</tr>
					<tr>
						<td>Editor access</td>
					</tr>
					<tr>
						<td>
						<select type="select" name="access" required>
						<option value="1">Admin Only</option>
						<option value="2">Admin and Editors</option>
						</select>
						</td>
					</tr>
					{/if}
					<tr>
						<td><input type="submit" name="save" value="Add Article"/></td>
					</tr>
				</table>
			</form>
	
		</div>
	  </div>
	  {else}
	   <div class="col-4-6">
	   <h2>List Articles</h2>
	  {if $message}<div class="message">{$message}</div>{/if}
	  {if $num eq '0'}
	  <div style="text-align:center;margin:15px;">
	  No articles found
	  </div>
	  {/if}
	  {foreach from=$articles item=art}
	
	   <div class="prod_list">
	      <div style="float:left;padding-bottom:2px">{$art.title}</div>
			<div style="float:right">
				<a class="link" href="{$virtualurl}articles.php?edit={$art.id}">Edit</a> | 
				<a class="link" href="{$virtualurl}articles.php?delete={$art.id}" onclick="return confirm('Are you sure you want delete?');">Delete</a> | 
				<a class="link" href="{$virtualurl}article/{$art.title|lower|replace:' ':'-'}/{$art.id}" target="_blank">View</a>
			</div>
		  <div class="clear"></div>
		  <hr />
		<div style="font-size:11px;">in {'docs_products'|data:'id':$art.software:'name'} &raquo; {'docs_cat'|data:'id':$art.category:'name'} &raquo; {'docs_scat'|data:'id':$art.subcategory:'name'}</div>
	   </div>
	  
	  {/foreach}
	  <div style="float:right;margin:10px">{$pagination}</div>
	  </div>
	  {/if}
	  <div class="clear"></div>
    </div>	
	
	
  {include file="footer.tpl"}







