<?php
ob_start();
session_start();
include('configuration.php');

defined('DS') ? null : define('DS', DIRECTORY_SEPARATOR);
defined('DATABASE_HOST') ? null : define('DATABASE_HOST', $db['product']['hostname']);
defined('DATABASE_NAME') ? null : define('DATABASE_NAME', $db['product']['database']);
defined('DATABASE_USER') ? null : define('DATABASE_USER', $db['product']['username']);
defined('DATABASE_PASSWORD') ? null : define('DATABASE_PASSWORD', $db['product']['password']); 
defined('ROOT_URL') ? null : define('ROOT_URL', $config['base_url']);

defined('DEBUG') ? null : define('DEBUG', $db['product']['debug']);
defined('CAGHE') ? null : define('CAGHE', $db['product']['cache']);
defined('LICENSE') ? null : define('LICENSE', $config['license_key']);

// Define absolute path to server root
defined('SITE_ROOT') ? null : define('SITE_ROOT', dirname(dirname(__FILE__)).DS);
defined('CURR_FILE') ? null : define('CURR_FILE', basename(__FILE__, '.php'));
ini_set("display_errors", DEBUG);
error_reporting(E_ERROR | E_WARNING | E_PARSE);

// Define absolute path to includes
defined('INCLUDE_PATH') ? null : define('INCLUDE_PATH', SITE_ROOT.'includes'.DS);
defined('FUNCTION_PATH') ? null : define('FUNCTION_PATH', INCLUDE_PATH.'functions'.DS);
defined('LIB_PATH') ? null : define('LIB_PATH', SITE_ROOT.'lib'.DS);
defined('SMARTY_PATH') ? null : define('SMARTY_PATH', LIB_PATH.'smarty'.DS);


include(INCLUDE_PATH.'classes/database.class.php');
include(INCLUDE_PATH.'functions.php');
require(SMARTY_PATH.'Smarty.class.php');
$smarty = new Smarty; 
$front_template = settings('site_template');
defined('FRONT_PATH') ? null : define('FRONT_PATH', SITE_ROOT.'templates/'.$front_template.''.DS);
$smarty->setTemplateDir(FRONT_PATH);
$filename = str_replace(".php","",basename($_SERVER['PHP_SELF']));

$virtualurl = ROOT_URL;
$templateurl = ROOT_URL.'templates/'.$front_template.'/';
if(isset($_COOKIE['user_id'])){
$username = $_COOKIE['username'];
$user_id = $_COOKIE['user_id'];
$islogged = 1;
}else{
$islogged = 0;
}
$smarty->force_compile = true;
$smarty->debugging = false;
$smarty->caching = false;
$smarty->cache_lifetime = 120;
$smarty->assign('username',$username);
$smarty->assign('user_id',$user_id);
$smarty->assign('islogged',$islogged);
$smarty->assign('filename',$filename);
$smarty->assign('templateurl',$templateurl);
$smarty->assign('virtualurl',$virtualurl);
?>