<?php

class Database {

	private $connection = null;
	private $is_magic_quotes_active = null;
	private $is_real_escape_string_active = null;
	
	public function __construct() {
		$this->is_magic_quotes_active = get_magic_quotes_gpc();
		$this->is_real_escape_string_active = function_exists("mysqli_real_escape_string");		
	}
	
	public function open() {
	
		// Open database connection
		$this->connection = mysqli_connect(DATABASE_HOST, DATABASE_USER, DATABASE_PASSWORD) or die(mysqli_error());
		
		// Select target database
		mysqli_select_db($this->connection, DATABASE_NAME) or die(mysqli_error());
			
	}

	public function sanitize($value) {
	$this->open();
		if ($this->is_real_escape_string_active) {
	
			if ($this->is_magic_quotes_active) {
	
				// Undo magic quote effects
				$value = stripslashes($value);
			}
			// Redo escape using mysql_real_escape_string
			$value = mysqli_real_escape_string($this->connection, $value);
	
		} else {
	
			if (!$this->is_magic_quotes_active) {
	
				// Add slashed manually
				$value = addslashes($value);
			}
		}
		$this->close();
		// Return sanitized value
		return $value;
	}

	public function execute($statement) {
	
		// Open database connection
		$this->open();
	
		// Execute database statement
		$result = mysqli_query($this->connection, $statement)or die(mysqli_error($this->connection));
		
		// Close database connection
		$this->close();
		
		// Return results
		return $result;
	}
	
	public function fetch($result) {
		return mysqli_fetch_array($result);
	}
	public function result($result) {
		return mysqli_result($result);
	}
	public function free_result($result) {
		return mysqli_free_result($result);
	}
	public function assoc($result) {
		return mysqli_fetch_assoc($result);
	}
	public function num($result) {
		return mysqli_num_rows($result);
	}

	public function close() {
	
		// Close database connection
		if (isset($this->connection)) {
			mysqli_close($this->connection);
		}
	}
}

$database = new Database();