<?php
/**
 * Only icons for socials
 *
 * @package YITH WooCommerce Social Login
 * @since   1.0.0
 * @author  YITH
 */

foreach ( $socials as $key => $value ) {
    $enabled = get_option( 'ywsl_' . $key . '_enable' );

    if ( $enabled == 'yes' ) {

        $social_args = array(
            'value'     => $value,
            'url'       => esc_url( add_query_arg( array(
                'ywsl_social' => $key,
                'redirect'    => urlencode( $args['redirect_to'] )
            ), site_url( 'wp-login.php' ) ) ),
            'image_url' => apply_filters( 'ywsl_custom_icon_' . $key, YITH_YWSL_ASSETS_URL . '/images/' . $key . '.png', $key ),
            'class'     => 'ywsl-social ywsl-' . $key
        );

	    $social_args = apply_filters( 'yith_wc_social_login_args', $social_args );

        $image  = sprintf( '<img src="%s" alt="%s"/>', $social_args['image_url'], isset( $value['label'] ) ? $value['label'] : $value );
        $social = sprintf( '<a class="%s" href="%s" rel="nofollow">%s</a>', $social_args['class'], $social_args['url'], $image );

        echo apply_filters( 'yith_wc_social_login_icon', $social, $key, $social_args );

    }
}