<?php
/*
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

function yith_wcgeoip_print_rule_section_titles() {
	?>
    <th class="option-status"><?php _e( 'Device', 'yith-geoip-language-redirect-for-woocommerce' );
		echo wc_help_tip( __( 'Choose the
                device(s) on which the rule applies', 'yith-geoip-language-redirect-for-woocommerce' ), false )
		?></th>
	<?php
}

function yith_wcgeoip_print_select( $id, $type, $args, $type_selected ) {
	$all_option      = _x( 'All', 'select item type', 'yith-geoip-language-redirect-for-woocommerce' );
	$specific_option = _x( 'Specific', 'select item type', 'yith-geoip-language-redirect-for-woocommerce' );
	$archive_option  = _x( 'Archive', 'select item type', 'yith-geoip-language-redirect-for-woocommerce' );
	?>
    <td class="form-field _rules_0_option_select option_select">
        <select name="_rules[<?php echo $id ?>][<?php echo $type ?>_type]"
                id="_rules_<?php echo $id ?>_<?php echo $type ?>_type"
                class="select_type <?php echo $type; ?> _rule">
			<?php
			$default_item_alls      = $args['default_types']['items']['all'];
			$default_item_specifics = $args['default_types']['items']['specific'];

			$default_first_items = array( 'entire_site' => 'all' );

			foreach ( $default_first_items as $key => $first_item ) {
				if ( 'all' == $first_item ) {
					if ( isset( $default_item_alls[ $key ] ) ) {
						if ( yith_wcgeoip_can_print_option( $type, $default_item_alls[ $key ] ) ) {
							yith_wcgeoip_print_option( 'all_' . $key, $default_item_alls[ $key ], 'all', $all_option, $type_selected );
						}
					}
				}
				if ( 'specific' == $first_item ) {
					if ( isset( $default_item_specifics[ $key ] ) ) {
						if ( yith_wcgeoip_can_print_option( $type, $default_item_specifics[ $key ] ) ) {
							yith_wcgeoip_print_option( $key, $default_item_specifics[ $key ], '', $specific_option, $type_selected );
						}
					}
				}
			}

			foreach ( $default_item_specifics as $key => $default_item_specific ) {
				if ( ! isset( $default_first_items[ $key ] ) ) {
					if ( yith_wcgeoip_can_print_option( $type, $default_item_specific ) ) {
						yith_wcgeoip_print_option( $key, $default_item_specific, '', $specific_option, $type_selected );
						if ( isset( $default_item_alls[ $key ] ) ) {
							if ( yith_wcgeoip_can_print_option( $type, $default_item_alls[ $key ] ) ) {
								yith_wcgeoip_print_option( 'all_' . $key, $default_item_alls[ $key ], 'all', $all_option, $type_selected );
							}
						}
					}
				}
			}
			foreach ( $default_item_alls as $key => $default_item_all ) {
				if ( ! isset( $default_first_items[ $key ] ) ) {
					if ( ! isset( $default_item_specifics[ $key ] ) ) {
						if ( yith_wcgeoip_can_print_option( $type, $default_item_all ) ) {
							yith_wcgeoip_print_option( $key, $default_item_all, 'all', $all_option, $type_selected );
						}
					}
				}
			}

			$grouped_types = $args['grouped_types'];
			foreach ( $grouped_types as $key => $grouped_type ) {
				?>
                <optgroup label="<?php echo $grouped_type['label']; ?>" <?php disabled( $grouped_type['disable'] ); ?>>
					<?php
					$grouped_items_alls      = isset( $grouped_type['items']['all'] ) ? $grouped_type['items']['all'] : array();
					$grouped_items_specifics = isset( $grouped_type['items']['specific'] ) ? $grouped_type['items']['specific'] : array();
					foreach ( $grouped_items_specifics as $key_item => $grouped_item_specific ) {
						if ( yith_wcgeoip_can_print_option( $type, $grouped_item_specific ) ) {
							yith_wcgeoip_print_option( $key_item, $grouped_item_specific, '', $specific_option, $type_selected );
							if ( isset( $grouped_items_alls[ $key_item ] ) ) {
								if ( yith_wcgeoip_can_print_option( $type, $grouped_items_alls[ $key_item ] ) ) {
									yith_wcgeoip_print_option( 'all_' . $key_item, $grouped_items_alls[ $key_item ], 'all', $all_option, $type_selected );
								}
							}
						}
					}
					?>
                </optgroup>
				<?php
			}
			if ( 'origin' == $type ) {
				$archive_types = $args ['archive_types'];
				?>
                <optgroup label="<?php echo $archive_types['label']; ?>" <?php disabled( $archive_types['disable'] ); ?>>
					<?php
					$archive_items = isset( $archive_types['items'] ) ? $archive_types['items'] : array();
					foreach ( $archive_items as $key_item => $archive_item ) {
						if ( yith_wcgeoip_can_print_option( $type, $archive_item ) ) {
							yith_wcgeoip_print_option( 'archive_' . $key_item, $archive_item, 'archive', $archive_option, $type_selected );
						}
					}
					?>
                </optgroup>
				<?php
			}
			?>
        </select>
    </td>
	<?php
}

function yith_wcgeoip_can_print_option( $type, $item ) {
	$print = false;
	if ( 'origin' == $type ) {
		if ( 'origin_destination' == $item['_display'] | 'origin' == $item['_display'] ) {
			$print = true;
		}
	}
	if ( 'destination' == $type ) {
		if ( 'origin_destination' == $item['_display'] | 'destination' == $item['_display'] ) {
			$print = true;
		}
	}

	return $print;
}

function yith_wcgeoip_print_option( $value, $item, $class = '', $message, $type_selected ) {
	?>
    <option value="<?php echo $value; ?>"
            data-type="<?php echo $item['_type']; ?>"
            class="<?php echo $class ?>"
		<?php if ( isset( $item['_placeholder'] ) ) { ?>
            data-placeholder = "<?php echo $item['_placeholder'] ?>"<?php
		}
		selected( $type_selected, $value );
		?>>
		<?php
		if ( '_custom_type' == $item['_type'] ) {
			echo $item['_name'];
		} else {
			echo $message . ' ' . $item['_name'];
		}
		?>
    </option>
	<?php
}

function yith_wcgeoip_get_option_once_duration() {
	$option_once = explode( '-', get_option( 'once_redirect_cookie_duration' ) );
	$time        = 0;
	if ( isset( $option_once[1] ) ) {
		switch ( $option_once[1] ) {
			case 'min':
				$time = $option_once[0] * MINUTE_IN_SECONDS;
				break;
			case 'hour':
				$time = $option_once[0] * HOUR_IN_SECONDS;
				break;
		}
	}

	return $time;
}

function yith_wcgeoip_get_device_list() {

	$device_list['all_devices'] = array(
		'value' => 'all_devices',
		'text'  => _x( 'All devices', 'Define the device on which the rules will apply',
			'yith-geoip-language-redirect-for-woocommerce' )
	);

	$device_list['mobile'] = array(
		'value' => 'mobile',
		'text'  => _x( 'Mobile', 'Define the device on which the rules will apply', 'yith-geoip-language-redirect-for-woocommerce' )
	);

	$device_list['desktop'] = array(
		'value' => 'desktop',
		'text'  => _x( 'Desktop', 'Define the device on which the rules will apply', 'yith-geoip-language-redirect-for-woocommerce' )
	);

	return $device_list;
}