<?php
/*
 * This file belongs to the YITH Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */
if ( ! defined( 'YITH_WCGEOIP_VERSION' ) ) {
	exit( 'Direct access forbidden.' );
}

/**
 *
 *
 * @class      YITH_Geoip_Premium
 * @package    Yithemes
 * @since      Version 1.0.0
 * @author     Your Inspiration Themes
 *
 */

if ( ! class_exists( 'YITH_Geoip_Premium' ) ) {
	/**
	 * Class YITH_Geoip_Premium
	 *
	 * @author Francisco Mateo
	 */
	class YITH_Geoip_Premium extends YITH_Geoip {

		/**
		 * Construct
		 *
		 * @author Francisco Mateo
		 * @since  1.0
		 */
		public function __construct() {
			add_filter( 'yith_wcgeoip_require_class', array( $this, 'require_class_premium' ), 10, 1 );

			parent::__construct();
		}

		/**
		 * Main plugin Instance
		 *
		 * @return Class Main instance
		 * @author Francisco Mateo
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		/**
		 * Class Initialization
		 *
		 * Instance the admin premium class.
		 *
		 * @author Francisco Mateo
		 * @since  1.0
		 * @return void
		 * @access protected
		 */
		public function init() {
			$this->_install_tables();

			if ( is_admin() ) {
				$this->admin = new YITH_Geoip_Admin_Premium();
			}

			if ( ! is_admin() || ( defined( 'DOING_AJAX' ) && DOING_AJAX ) ) {

				$this->frontend = new YITH_Geoip_Frontend_Premium();
			}
		}

		public function require_class_premium( $require ) {
			array_push( $require['common'], 'includes/functions.yith-wcgeoip-premium.php' );
			array_push( $require['frontend'], 'includes/class.yith-geoip-language-redirect-frontend-premium.php' );
			array_push( $require['admin'], 'includes/class.yith-geoip-language-redirect-admin-premium.php' );

			return $require;
		}

	}

}