<?php
/*
 * This file belongs to the YITH Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */
if ( ! defined( 'YITH_WCGEOIP_VERSION' ) ) {
	exit( 'Direct access forbidden.' );
}

/**
 *
 *
 * @class      YITH_Geoip_Frontend_Premium
 * @package    Yithemes
 * @since      Version 1.0.0
 * @author     Your Inspiration Themes
 *
 */

if ( ! class_exists( 'YITH_Geoip_Frontend_Premium' ) ) {
	/**
	 * Class YITH_Geoip_Frontend_Premium
	 *
	 * @author Francisco Mateo
	 */
	class YITH_Geoip_Frontend_Premium extends YITH_Geoip_Frontend {

		protected $url = '';

		public function __construct() {
			parent::__construct();

			add_filter( 'yith_wcgeoip_check_before_custom_url', array( $this, 'check_rule_before_custom_url' ), 10, 3 );
			add_filter( 'yith_wcgeoip_check_after_custom_url', array( $this, 'check_rule_after_custom_url' ), 10, 3 );
			add_filter( 'yith_wcgeoip_expire_cookie_duration', array( $this, 'set_expire_cookie_duration' ) );
			add_filter( 'yith_wcgeoip_set_url_before_compare', array( $this, 'set_url_before_compare' ), 10, 3 );

		}

		public function check_rule_before_custom_url( $rule_custom, $customer_country, $template ) {
			//1º Check if IP are exluded...
			$user_ip = yith_wcgeoip_get_current_ip();
			if ( $user_ip && $this->exclude_ip_list( $user_ip ) ) {
				return array();
			}

			//2º Find rule for specific_* from specific country.
			$rule_specific_values = $this->check_specific_values( $customer_country, $template['url'], $template['origin_type'] );

			if ( ! empty( $rule_specific_values ) ) {
				return $rule_specific_values;
			}

			//3º Find rule for all_* from specific country
			$rule_all_values = $this->check_all_values( $customer_country, $template['origin_type'] );
			if ( ! empty( $rule_all_values ) ) {
				return $rule_all_values;
			}

			//4º Find rule for archive_* from specific country
			$rule_archive_values = $this->check_archive_values( $customer_country, $template['origin_type'] );
			if ( ! empty( $rule_archive_values ) ) {
				return $rule_archive_values;
			}

			return $rule_custom;
		}

		public function check_rule_after_custom_url( $rule_custom, $customer_country, $template ) {

			//6º Find rule for cutom_url_regex from specific country.
			$rule_custom_url_regex = $this->check_custom_url_regex( $customer_country, $template['url'] );
			if ( ! empty( $rule_custom_url_regex ) ) {
				return $rule_custom_url_regex;
			}

			//8º Find rule for entire site from specific country.
			$rule_all_entire_site = $this->check_all_entire_site( $customer_country );
			if ( ! empty( $rule_all_entire_site ) ) {
				return $rule_all_entire_site;
			}

			return $rule_custom;
		}

		public function set_expire_cookie_duration( $expire ) {
			$duration = yith_wcgeoip_get_option_once_duration();
			$expire   = ( $duration != 0 ) ? time() + $duration : $duration;

			return $expire;
		}

		public function set_url_before_compare( $destination, $rule, $origin_template ) {
			$url = $destination;

			$internal   = strpos( $destination, get_home_url() ) === 0 || strpos( $destination, '%' ) !== false;
			$need_parse = strpos( $destination, 'http' ) !== 0;

			if ( $need_parse ) {
				if ( $internal && 'custom_url' == $rule['destination_type'] && $rule['origin_type'] != 'all_entire_site' ) {
					$url = $this->parse_url_to_redirect( $destination, $origin_template );
				} elseif ( $internal && 'custom_url' == $rule['destination_type'] && $rule['origin_type'] == 'all_entire_site' ) {
					$url = $this->parse_url_to_redirect_entire_site( $destination, $origin_template );
					//$url = $this->parse_url_to_redirect( $destination, $origin_template );
				} else {
					$url = $destination;
				}

				//$url = ($internal & 'custom_url' == $rule['destination_type']) ?  $this->parse_url_to_redirect($destination, $origin_template) : $destination;
			}

			return $url;
		}

		public function parse_url_to_redirect( $url, $origin_template ) {
			global $wp_rewrite;

			$permalink_structure = get_option( 'permalink_structure', false );
			$new_url             = '';

			remove_all_filters( 'home_url' );;

			if ( $permalink_structure ) {

				$this->url                       = $url;
				$wp_rewrite->permalink_structure = $url;
				switch ( $origin_template['template_type'] ) {
					case 'archive':
						$wp_rewrite->page_structure = $url;
						$new_url                    = get_permalink( $origin_template['id'] );
						break;
					case 'page':
						if ( isset( $_COOKIE['yith_geoip_cookies_last_url_loaded'] ) ) {
							$url_cookie = $_COOKIE['yith_geoip_cookies_last_url_loaded'];
							if ( substr_compare( $url_cookie, $origin_template['url'], strpos( $url_cookie, ':' ) + 1, strlen( $origin_template['url'] ) ) === 0 ) {
								$new_url = $url_cookie;
								break;
							}
						}
						$wp_rewrite->page_structure = $url;
						$new_url                    = get_permalink( $origin_template['id'] );
						$new_url                    = str_replace( '%path%', $origin_template['rel_name'], $new_url );

						break;
					case 'single':
						if ( isset( $_COOKIE['yith_geoip_cookies_last_url_loaded'] ) ) {
							$url_cookie = $_COOKIE['yith_geoip_cookies_last_url_loaded'];
							if ( substr_compare( $url_cookie, $origin_template['url'], strpos( $url_cookie, ':' ) + 1, strlen( $origin_template['url'] ) ) === 0 ) {
								$new_url = $url_cookie;
								break;
							}
						}
						$post = $origin_template['qo'];
						if ( in_array( $post->post_type, get_post_types( array( '_builtin' => false ) ) ) ) {
							$wp_rewrite->extra_permastructs[ $post->post_type ]['struct'] = $url;
							$new_url                                                      = get_permalink( $origin_template['id'] );
						} else {
							remove_all_filters( 'post_link' );
							add_filter( 'pre_post_link', array( $this, 'change_permastruct' ) );
							$new_url = get_permalink( $origin_template['id'] );
						}
						$new_url = str_replace( '%path%', $origin_template['rel_name'], $new_url );
						break;
					case 'tag':
					case 'category':
					case 'tax':
						$wp_rewrite->extra_permastructs[ $origin_template['origin_type'] ]['struct'] = $url;
						$new_url                                                                     = get_term_link( $origin_template['id'] );
						break;
				}

				$pos = strpos( $url, '?' );

				if ( $pos !== false ) {
					$query_string = substr( $url, $pos + 1 );
					$query_item   = explode( '&', $query_string );

					$query_args = array();
					foreach ( $query_item as $item ) {
						if ( ! empty( $item ) ) {
							$value                   = explode( '=', $item );
							$query_args[ $value[0] ] = $value[1];
						}
					}
					$new_url = add_query_arg( $query_args, $new_url );
				}

				return $new_url;
			} else {
				$new_url = get_site_url() . '/' . preg_replace( '~%(.*?)%~', $origin_template['id'], $url );
			}

			return $new_url;
		}

		public function parse_url_to_redirect_entire_site( $url, $origin_template ) {
			global $wp_rewrite;

			$permalink_structure = get_option( 'permalink_structure', false );
			$new_url             = '';

			if ( $permalink_structure ) {

				$this->url                       = $url;
				$wp_rewrite->permalink_structure = $url;

				// removes all filters from home url
				remove_all_filters( 'home_url' );
				add_filter( 'home_url', array( $this, 'update_home_url' ), 10, 2 );

				switch ( $origin_template['template_type'] ) {
					case 'archive':
						remove_all_filters( 'post_type_archive_link' );

						$new_url = get_post_type_archive_link( $origin_template['rel_name'] );
						break;
					case 'date':

						if ( ! empty( $origin_template['day'] ) ) {
							remove_all_filters( 'day_link' );

							$new_url = get_day_link( $origin_template['year'], $origin_template['monthnum'], $origin_template['day'] );
						} elseif ( ! empty( $origin_template['monthnum'] ) ) {
							remove_all_filters( 'month_link' );

							$new_url = get_month_link( $origin_template['year'], $origin_template['monthnum'] );
						} else {
							remove_all_filters( 'year_link' );

							$new_url = get_year_link( $origin_template['year'] );
						}

						break;
					case 'page':
						remove_all_filters( 'page_link' );

						$new_url = get_permalink( $origin_template['id'] );

						if ( isset( $_COOKIE['yith_geoip_cookies_last_url_loaded'] ) ) {
							$url_cookie = $_COOKIE['yith_geoip_cookies_last_url_loaded'];
							if ( substr_compare( $url_cookie, $origin_template['url'], strpos( $url_cookie, ':' ) + 1, strlen( $origin_template['url'] ) ) === 0 ) {
								$new_url = $url_cookie;
								break;
							}
						}
						break;
					case 'single':
						$post = $origin_template['qo'];
						if ( in_array( $post->post_type, get_post_types( array( '_builtin' => false ) ) ) ) {
							remove_all_filters( 'post_type_link' );

							$new_url = get_permalink( $origin_template['id'] );
						} else {
							remove_all_filters( 'post_link' );

							$new_url = get_permalink( $origin_template['id'] );
						}
						if ( isset( $_COOKIE['yith_geoip_cookies_last_url_loaded'] ) ) {
							$url_cookie = $_COOKIE['yith_geoip_cookies_last_url_loaded'];

							if ( substr_compare( $url_cookie, $origin_template['url'], strpos( $url_cookie, ':' ) + 1, strlen( $origin_template['url'] ) ) === 0 ) {
								$new_url = $url_cookie;
								break;
							}
						}
						break;
					case 'category':
					case 'tag':
					case 'tax':
						remove_all_filters( 'term_link' );

						$new_url = get_term_link( $origin_template['id'] );
						break;
				}

				$pos = strpos( $url, '?' );

				if ( $pos !== false ) {
					$query_string = substr( $url, $pos + 1 );
					$query_item   = explode( '&', $query_string );

					$query_args = array();
					foreach ( $query_item as $item ) {
						if ( ! empty( $item ) ) {
							$value                   = explode( '=', $item );
							$query_args[ $value[0] ] = $value[1];
						}
					}
					$new_url = add_query_arg( $query_args, $new_url );
				}

				return $new_url;
			} else {
				$new_url = get_site_url() . '/' . preg_replace( '~%(.*?)%~', $origin_template['id'], $url );
			}

			return $new_url;
		}

		public function change_permastruct() {
			return $this->url;
		}

		public function update_home_url( $url, $path ) {
			$path = $this->maybe_replace_path( $this->url, $path );

			remove_filter( 'home_url', array( $this, 'update_home_url' ) );
			$new_url = home_url( $path );
			add_filter( 'home_url', array( $this, 'update_home_url' ), 10, 2 );

			return $new_url;
		}

		public function maybe_replace_path( $new_permastruct, $old_permastruct ) {
			if ( strpos( $new_permastruct, '%path%' ) !== false ) {
				$old_permastruct = untrailingslashit( $old_permastruct );
				$new_permastruct = trailingslashit( str_replace( '%path%', $old_permastruct, $new_permastruct ) );
			}

			if ( strpos( $new_permastruct, '%pagename%' ) !== false ) {
				$new_permastruct = str_replace( '%pagename%', $old_permastruct, $new_permastruct );
			}

			if ( strpos( $new_permastruct, '?' ) !== false ) { // Format URL with attributes
				$query_string    = substr( $new_permastruct, strpos( $new_permastruct, '?' ) );
				$new_permastruct = $old_permastruct . '/' . $query_string;
			}

			// fix possible duplicated slash, when $old_permastruct starts or end with /
			$new_permastruct = str_replace( '//', '/', $new_permastruct );

			return $new_permastruct;
		}

		public function check_specific_values( $country, $url, $type ) {
			$args = array(
				'country'     => $country,
				'origin_type' => $type,
				'origin'      => 'http:' . $url
			);


			$rule = $this->geoip_rules->get_rules( $args );

			if ( ! empty( $rule ) ) {
				$rule = $rule[0];
			}

			return $rule;
		}

		public function check_all_values( $country, $type ) {
			$args = array(
				'country'     => $country,
				'origin_type' => 'all_' . $type
			);
			$rule = $this->geoip_rules->get_rules( $args );
			if ( ! empty( $rule ) ) {
				$rule = $rule[0];
			}

			return $rule;
		}

		public function check_archive_values( $country, $type ) {
			$args = array(
				'country'     => $country,
				'origin_type' => 'archive_' . $type
			);
			$rule = $this->geoip_rules->get_rules( $args );

			if ( ! empty( $rule ) ) {
				$rule = $rule[0];
			}

			return $rule;
		}

		public function check_custom_url_regex( $country, $url ) {
			$args = array(
				'country'     => $country,
				'origin_type' => 'custom_url_regex',
				'origin'      => $url
			);

			$rule = $this->geoip_rules->get_rules( $args );

			if ( ! empty( $rule ) ) {
				$rule = $rule[0];
			}

			return $rule;
		}

		public function check_all_entire_site( $country ) {
			$args = array(
				'country'     => $country,
				'origin_type' => 'all_entire_site'
			);

			$rule = $this->geoip_rules->get_rules( $args );

			if ( ! empty( $rule ) ) {
				$rule = $rule[0];
			}

			return $rule;
		}

		public function exclude_ip_list( $ip ) {
			$excluded = false;

			$list_excluded = get_option( 'list_exclude_ips', false );

			if ( empty( $list_excluded ) ) {
				return false;
			}

			foreach ( $list_excluded as $ip_excluded ) {
				if ( $ip_excluded == $ip ) {
					return true;
				}
			}

			return apply_filters( 'yith_wcgeoip_exlclude_ip_list', $excluded );
		}
	}

}