<?php
/*
 * This file belongs to the YITH Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */
if ( ! defined( 'YITH_WCGEOIP_VERSION' ) ) {
	exit( 'Direct access forbidden.' );
}

/**
 *
 *
 * @class      YITH_Geoip_Admin_Premium
 * @package    Yithemes
 * @since      Version 1.0.0
 * @author     Your Inspiration Themes
 *
 */

if ( ! class_exists( 'YITH_Geoip_Admin_Premium' ) ) {
	/**
	 * Class YITH_Geoip_Admin_Premium
	 *
	 * @author Francisco Mateo
	 */
	class YITH_Geoip_Admin_Premium extends YITH_Geoip_Admin {
		protected $types_select = array();

		public function __construct() {
			parent::__construct();
			$this->types_select = $this->get_types_select();

			add_action( 'yith_wcgeoip_rule_before_origin', array( $this, 'rule_before_origin' ), 10, 2 );
			add_action( 'yith_wcgeoip_rule_before_destination', array( $this, 'rule_before_destination' ), 10, 2 );

			add_action( 'yith_wcgeoip_rule_before_option_actions_title', array(
				$this,
				'add_cutom_rule_sections_titles'
			) );
			add_action( 'yith_wcgeoip_rule_before_option_actions', array( $this, 'add_cutom_rule_sections' ), 10, 3 );

			add_action( 'yith_wcgeoip_rules_add_rule_button_colspan', array(
				$this,
				'set_rules_add_rule_button_colspan'
			) );
			add_action( 'yith_wcgeoip_option_origin_colspan', array(
				$this,
				'set_rules_option_origin_destination_colspan'
			) );
			add_action( 'yith_wcgeoip_option_destination_colspan', array(
				$this,
				'set_rules_option_origin_destination_colspan'
			) );

			/* === Get Settings Premium Panel === */
			add_filter( 'yith_wcgeoip_admin_tabs', array( $this, 'register_settings_tab' ) );
			add_action( 'yith_wcgeoip_settings_panel', array( $this, 'get_settings_panel' ) );

			// register plugin to licence/update system
			add_action( 'wp_loaded', array( $this, 'register_plugin_for_activation' ), 99 );
			add_action( 'admin_init', array( $this, 'register_plugin_for_updates' ) );
		}

		protected function enqueue_settings_scripts() {
			$path   = ( defined( 'WP_DEBUG' ) && WP_DEBUG ) ? '/unminified' : '';
			$prefix = ( defined( 'WP_DEBUG' ) && WP_DEBUG ) ? '' : '.min';

			wp_register_style( 'yith-wc-style-geopip-settings', YITH_WCGEOIP_ASSETS_URL . 'css/style-geoip-settings.css', null, YITH_WCGEOIP_VERSION );


			wp_register_script( 'yith-wc-script-geopip-settings', YITH_WCGEOIP_ASSETS_URL . '/js' . $path . '/script-geoip-settings' . $prefix . '.js', array( 'jquery' ), YITH_WCGEOIP_VERSION, true );
			wp_enqueue_script( 'yith-wc-script-geopip-settings' );

			wp_enqueue_style( 'yith-wc-style-geopip-settings' );


		}

		public function rule_before_origin( $index, $rule ) {
			$origin_select = ! empty( $rule['origin_type'] ) ? $rule['origin_type'] : 'custom_url';
			yith_wcgeoip_print_select( $index, 'origin', $this->types_select, $origin_select );
		}

		public function add_cutom_rule_sections_titles() {
			yith_wcgeoip_print_rule_section_titles();
		}

		public function add_cutom_rule_sections( $index, $rule_row ) {
			$args = array(
				'index'       => $index,
				'rule_row'    => $rule_row,
				'device_list' => yith_wcgeoip_get_device_list()
			);
			yith_wcgeoip_get_template( 'rule-row-section-option_device', $args, 'admin' );
		}

		public function rule_before_destination( $index, $rule ) {
			$destination_select = ! empty( $rule['destination_type'] ) ? $rule['destination_type'] : 'custom_url';
			yith_wcgeoip_print_select( $index, 'destination', $this->types_select, $destination_select );
		}

		public function set_rules_add_rule_button_colspan( $colspan ) {
			$colspan = 10;

			return $colspan;
		}

		public function set_rules_option_origin_destination_colspan( $colspan ) {
			$colspan = 1;

			return $colspan;
		}

		public function register_settings_tab( $admin_tabs ) {
			$admin_tabs['geoip-settings'] = _x( 'Settings', 'tab name', 'yith-geoip-language-redirect-for-woocommerce' );

			return $admin_tabs;
		}

		public function get_settings_panel() {
			$this->enqueue_settings_scripts();
			$args = array(
				'list_exclude_ips'              => get_option( 'list_exclude_ips' ),
				'once_redirect_cookie_duration' => get_option( 'once_redirect_cookie_duration' )
			);

			yith_wcgeoip_get_template( 'settings-panel', $args, 'admin' );
		}

		public function finder_source_action() {
			global $wp_rewrite;
			$permalink_structure = get_option( 'permalink_structure', false );
			$source              = array(
				'term'   => $_POST['data']['term'],
				'select' => $_POST['data']['select'],
				'type'   => $_POST['data']['type']
			);

			$results = array();
			switch ( $source['type'] ) {
				case '_post_type':
					$args  = array(
						'post_type' => $source['select'],
						's'         => $source['term']
					);
					$posts = get_posts( $args );
					if ( ! empty( $posts ) ) {
						foreach ( $posts as $post ) {
							if ( $permalink_structure ) {
								$wp_rewrite->permalink_structure = get_permalink( $post );
							}
							$permalink = get_permalink( $post );
							$results[] = array(
								'id'        => $post->ID,
								'title'     => get_the_title( $post ),
								'permalink' => ( 'attachment' != $source['select'] ) ? $permalink : wp_get_attachment_url( $post->ID )
							);
						}
					}
					break;
				case '_term_type':
					$args = array(
						'taxonomy'   => $source['select'],
						'search'     => $source['term'],
						'hide_empty' => false
					);

					$terms = get_terms( $args );

					if ( ! empty( $terms ) ) {
						foreach ( $terms as $term ) {
							$results[] = array(
								'id'        => $term->term_id,
								'title'     => $term->name,
								'permalink' => get_term_link( $term )
							);
						}
					}
					break;
				default:

					break;
			}
			wp_send_json( $results );
			die();
		}

		public function get_types_select() {

			$black_list = array(
				'post_format'            => true,
				'product_shipping_class' => true
			);

			$media_post_type = get_post_type_object( 'attachment' );

			$default_types = array(
				'specific' => array(
					'custom_url'       => array(
						'_name'    => _x( 'Custom URL', 'select item type', 'yith-geoip-language-redirect-for-woocommerce' ),
						'_type'    => '_custom_type',
						'_display' => 'origin_destination',
					),
					'custom_url_regex' => array(
						'_name'    => _x( 'Custom URL (regex)', 'select item type', 'yith-geoip-language-redirect-for-woocommerce' ),
						'_type'    => '_custom_type',
						'_display' => 'origin',
					),
					'attachment'       => array(
						'_name'    => $media_post_type->labels->singular_name,
						'_type'    => '_post_type',
						'_display' => 'origin_destination',
					)
				),
				'all'      => array(
					'entire_site' => array(
						'_name'        => _x( 'Entire website', 'select item type', 'yith-geoip-language-redirect-for-woocommerce' ),
						'_type'        => '_custom_type',
						'_display'     => 'origin',
						'_placeholder' => '/%path%'
					),
					'attachment'  => array(
						'_name'        => $media_post_type->labels->name,
						'_type'        => '_post_type',
						'_display'     => 'origin',
						'_placeholder' => $this->get_permastruct( $media_post_type )
					)
				)
			);
			$post_types    = get_post_types( array( 'public' => true ), 'objects' );

			$options_post_types = array();
			$options_archives   = array();
			foreach ( $post_types as $key => $post_type_object ) {
				if ( ! isset( $default_types['specific'][ $key ] ) & ! isset( $black_list[ $key ] ) ) {
					$options_post_types['specific'][ $key ] = array(
						'_name'    => ( empty( $post_type_object->labels->singular_name ) ) ? $post_type_object->labels->name : $post_type_object->labels->singular_name,
						'_type'    => '_post_type',
						'_display' => 'origin_destination'
					);
				}
				if ( ! isset( $default_types['all'][ $key ] ) ) {
					$options_post_types['all'][ $key ] = array(
						'_name'        => $post_type_object->labels->name,
						'_type'        => '_post_type',
						'_display'     => 'origin',
						'_placeholder' => $this->get_permastruct( $post_type_object )
					);
				}
				if ( $post_type_object->has_archive ) {
					$options_archives[ $key ] = array(
						'_name'        => $post_type_object->labels->name,
						'_type'        => '_archive',
						'_display'     => 'origin',
						'_placeholder' => get_post_type_archive_link( $post_type_object->name )
					);
				}
			}

			$taxonomies         = get_taxonomies( array( 'public' => true ) );
			$options_taxonomies = array();
			foreach ( $taxonomies as $key => $taxonomy ) {
				$taxonomy_object = get_taxonomy( $taxonomy );

				$x_name = '';

				if ( preg_match( '/post/', $key ) ) {
					$x_name = _x( 'Post', 'Taxonomy prefix as in the expression "Post Category"', 'yith-geoip-language-redirect-for-woocommerce' );
				} elseif ( preg_match( '/product/', $key ) ) {
					$x_name = _x( 'Product', 'Taxonomy prefix as in the expression "Product Category"', 'yith-geoip-language-redirect-for-woocommerce' );
				}

				if ( ! isset( $default_types['specific'][ $key ] ) & ! isset( $black_list[ $key ] ) ) {
					$name = ( empty( $taxonomy_object->labels->singular_name ) ) ? $taxonomy_object->labels->name : $taxonomy_object->labels->singular_name;
					$name = ! preg_match( '/' . $x_name . '/', $name ) ? $x_name . ' ' . $name : $name;
					$name = apply_filters( 'yith_wcgeoip_specific_taxonomy_name', $name, $key, $taxonomy_object );

					$options_taxonomies['specific'][ $key ] = array(
						'_name'    => $name,
						'_type'    => '_term_type',
						'_display' => 'origin_destination'
					);
				}
				if ( ! isset( $default_types['all'][ $key ] ) & ! isset( $black_list[ $key ] ) ) {
					$name = $taxonomy_object->labels->name;
					$name = ! preg_match( '/' . $x_name . '/', $name ) ? $x_name . ' ' . $name : $name;
					$name = apply_filters( 'yith_wcgeoip_all_taxonomy_name', $name, $key, $taxonomy_object );

					$options_taxonomies['all'][ $key ] = array(
						'_name'        => $name,
						'_type'        => '_term_type',
						'_display'     => 'origin',
						'_placeholder' => $this->get_permastruct( $taxonomy_object )
					);
				}
			}

			$types = array(
				'default_types' => array(
					'items' => $default_types
				),
				'grouped_types' => array(
					'options_post_types' => array(
						'label'   => _x( 'Types', '', 'yith-geoip-language-redirect-for-woocommerce' ),
						'items'   => $options_post_types,
						'disable' => false
					),
					'options_taxonomies' => array(
						'label'   => _x( 'Taxonomies', '', 'yith-geoip-language-redirect-for-woocommerce' ),
						'items'   => $options_taxonomies,
						'disable' => false
					)
				),
				'archive_types' => array(
					'label'   => _x( 'Archives', '', 'yith-geoip-language-redirect-for-woocommerce' ),
					'items'   => $options_archives,
					'disable' => false
				)
			);

			return $types;
		}

		public function get_permastruct( $item ) {
			global $wp_rewrite;
			$permalink_structure = get_option( 'permalink_structure', true );
			$value               = '';
			switch ( $item->name ) {
				case 'post':
					$value = ( $permalink_structure ) ? $permalink_structure : '?p=%id_post%';
					break;
				case'page':
					$page_permastruct = $wp_rewrite->get_page_permastruct( $item->name );
					$value            = ( $page_permastruct ) ? $page_permastruct : '?page_id=%page_id%';
					break;
				case 'attachment':
					$value = 'wp-content/uploads/%media_path%/%media%';
					break;
				default:
					if ( $permalink_structure ) {
						$value = $wp_rewrite->get_extra_permastruct( $item->name );
					} else {

						switch ( $item->name ) {
							case 'product':
								$value = '?' . $item->rewrite['slug'] . '=%product%';
								break;
							case 'category':
								$value = '?cat=%id%';
								break;
							case 'post_tag':
								$value = '?tag=%id%';
								break;
							case 'product_category':
								$value = '?product_cat=%product_category%';
								break;
							case 'product_tag':
								$value = '?' . $item->rewrite['slug'] . '=%product_tag%';
								break;
							default:
								$value = '?' . $item->rewrite['slug'] . '=%id%';
						};
					}
					break;
			}

			return $value;
		}

		public function save_settings_action() {

			$exclude_ip_list = array();
			if ( isset( $_POST['data']['list_exclude_ips'] ) ) {
				$exclude_ip_list = explode( ',', $_POST['data']['list_exclude_ips'] );
			}
			$once_redirect_cookie_duration = $_POST['data']['once_redirect_cookie_duration'];

			update_option( 'list_exclude_ips', $exclude_ip_list );
			update_option( 'once_redirect_cookie_duration', $once_redirect_cookie_duration );

			die();
		}

		/* === LICENCE HANDLING METHODS === */

		/**
		 * Register plugins for activation tab
		 *
		 * @return void
		 * @since 1.0.1
		 */
		public function register_plugin_for_activation() {
			if ( ! class_exists( 'YIT_Plugin_Licence' ) ) {
				require_once YITH_WCGEOIP_PATH . 'plugin-fw/licence/lib/yit-licence.php';
				require_once YITH_WCGEOIP_PATH . 'plugin-fw/licence/lib/yit-plugin-licence.php';
			}

			YIT_Plugin_Licence()->register( YITH_WCGEOIP_INIT, YITH_WCGEOIP_SECRETKEY, YITH_WCGEOIP_SLUG );
		}

		/**
		 * Register plugins for update tab
		 *
		 * @return void
		 * @since 1.0.0
		 */
		public function register_plugin_for_updates() {
			if ( ! class_exists( 'YIT_Plugin_Licence' ) ) {
				require_once( YITH_WCAF_DIR . 'plugin-fw/lib/yit-upgrade.php' );
			}

			YIT_Upgrade()->register( YITH_WCGEOIP_SLUG, YITH_WCGEOIP_INIT );
		}
	}

}