jQuery(document).ready(function ($) {

    main_init();

    function main_init() {
        $('#yith_wcgeoip_settings_form').on('click', '#add_exclude_ips_button', function (e) {
            add_ips(e);
        });
        $('.tagchecklist').on('click', '.ntdelbutton', function (e) {
            e.preventDefault();
            var $span = $(this).closest('span');
            var current_list = $('#list_exclude_ips').val().split(',');
            console.log(current_list);
            var aux_current_list = '';
            for (var i = 0; i < current_list.length; i++) {
                if ($span.find('.ip_text').text() != current_list[i]) {
                    if (0 == aux_current_list.length) {
                        aux_current_list = current_list[i];
                    } else {
                        aux_current_list += ',' + current_list[i];
                    }
                }
                console.log(aux_current_list);
            }

            $('#list_exclude_ips').val(aux_current_list);

            $span.remove();
        });

        $('#save_ip_excluded_list').click(function (event) {
            event.preventDefault();
            var post_data = {
                action: 'save_settings_action',
                data  : {
                    list_exclude_ips             : $('#list_exclude_ips').val(),
                    once_redirect_cookie_duration: $('#cookie_duration').val()
                }
            };

            $('#yith_wcgeoip_settings_form').block({message: null, overlayCSS: {background: "#fff", opacity: .6}});


            $.post(ajaxurl, post_data).success(function (data) {

                $('#yith_wcgeoip_settings_form').unblock();
            });

        });

    }

    function add_ips(event) {
        event.preventDefault();
        var values = $('#add_exclude_ips').val().split(',');

        for (var i = 0; i < values.length; i++) {
            var value = values[i].replace(' ', '');

            if (0 < value.length && !ip_added(value)) {
                var $span = $('<span/>');

                var $button = $('<button/>').addClass('ntdelbutton').attr('id', 'ip_check-num-' + i);

                var $span_remove = $('<span/>').addClass('remove-tag-icon').attr('aria-hidden', 'true');
                var $span_screen = $('<span/>').addClass('screen-reader-text').text('Remove excluded IP');
                var $p = $('<p/>').addClass('ip_text').attr('data-value', value).text(value);

                $span_remove.appendTo($button);
                $span_screen.appendTo($button);
                $button.appendTo($span);
                $p.appendTo($span);

                $span.appendTo('.tagchecklist');

                var $list_exclude_ips = $('#list_exclude_ips');
                if (0 == $list_exclude_ips.val().length) {
                    $list_exclude_ips.val(value);
                } else {
                    $list_exclude_ips.val($list_exclude_ips.val() + ',' + value);
                }

            }
        }
        $('#add_exclude_ips').val('');
    }

    function ip_added(value) {
        var added = false;

        var current_list = $('#list_exclude_ips').val().split(',');

        for (var i = 0; i < current_list.length; i++) {
            if (value == current_list[i]) {
                added = true;
                return added;
            }
        }
        /*
         $('.ip_text').each(function (i) {
         if(value == $(this).text()){
         added = true;
         return added;
         }
         });
         */
        return added;
    }
});
