<!DOCTYPE html>
<html lang="<?php echo $site_lang;?>">

<?php require_once('head' . cfg('template', 'template_extension')); ?>

<body>
    
	<?php require_once('header' . cfg('template', 'template_extension')); ?>
	
	<div id="container">
		
		<div class="wrapper">
		
			<div class="content left">
			
				<section class="module">
					<header>
						<h1><?php echo $lang['TITLE_PARTNERS']; ?></h1>
					</header>
					
					<div class="gallery2Cols">
						
						<?php foreach ($partners as $row): ?>
						<div>
							<a class="link-gray-red" href="<?php echo $row['partner_url']; ?>" title="" target="_blank">
								<figure>
									<img  src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['partner_image']; ?>" alt="<?php echo $row['partner_name']; ?>" title="" width="200" height="70"/>
									<figcaption><?php echo $row['partner_name']; ?></figcaption>
								</figure>
							</a>
						</div>
						<?php endforeach; ?>
						
					</div> <!-- END .gallery2Cols -->
					
				</section> <!-- END .module -->
				
			</div> <!-- END .content .left -->
			
			
			<aside class="sidebar right">
			
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_FACEBOOK_FAN']; ?></h2>
					</header>
					
					<div class="fb-like-box" 
						data-href="<?php echo cfg('social', 'facebook_page'); ?>" 
						data-colorscheme="dark" 
						data-show-faces="true" 
						data-header="false" 
						data-stream="false"
						data-show-border="false"
						data-height="260">
					</div>
				</article> <!-- END .widget -->
				
				<?php if($sidebar_ad): ?>
					<article class="widget">
					
						<?php echo $sidebar_ad; ?>
						
					</article> <!-- END .widget -->
				<?php endif; ?>

			</aside> <!-- END .sidebar .right -->
		
		</div> <!-- END .wrapper -->
		
	</div> <!-- END #container -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
</body>
</html>