<!DOCTYPE html>
<html lang="<?php echo $site_lang;?>">

<?php require_once('head' . cfg('template', 'template_extension')); ?>

<body>
    
	<?php require_once('header' . cfg('template', 'template_extension')); ?>
	
	<div id="container">
		
		<div class="wrapper">
		
			<div class="module flexslider">
				<ul class="slides">
				
				<?php foreach ($slides as $row): ?>
				
					<li>
						<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['slide_image']; ?>" alt="" title="" width="1073" height="300"/>
						<div class="flex-caption">
							<div>
								<p>
									<a href="<?php echo $row['slide_url']; ?>" <?php if ($row['target_blank']) echo 'target="blank"'; ?> title="">
									    <?php echo $row['slide_title']; ?>
									</a>
								</p>
							</div>
							<p><?php echo $row['slide_info']; ?></p>
						</div>
					</li>
					
				<?php endforeach; ?>	
					
				</ul>
			</div> <!-- END .module .flexslider -->
			
			
			<div class="module cover-mix">
			
				<article>
					
					<?php if($mix['cover']):?> 
						<figure class="scaleEffect">
							<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $mix['cover']; ?>" alt="<?php echo $mix['mix_title']; ?>" title="" width="200" height="200"/>
						</figure>
					<?php else: ?>
						<figure>
							<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj.jpg" alt="" title="" width="200" height="200"/>
						</figure>
					<?php endif; ?>
					
					<div>
						<h3><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($mix['mix_title']).'-'.$mix['mix_id']; ?>" title=""><?php echo $mix['mix_title']; ?></a></h3>

						<p class="gap-T5 gap-B10 txt-italic txt-gray"> 
							<a class="link-red-gray" href="#" title=""><?php echo $mix['author']; ?></a>
						</p>
						
						<footer>
							<script type="text/javascript">var zippywww="<?php echo $mix['zippy_www']; ?>";var zippyfile="<?php echo $mix['zippy_file']; ?>";var zippytext="#ffffff";var zippyback="#222222";var zippyplay="#ff0056";var zippywidth="100%";var zippyauto=false;var zippyvol=80;var zippywave = "#666666";var zippyborder = "#222222";</script><script type="text/javascript" src="http://api.zippyshare.com/api/embed_new.js"></script>
						</footer>
					</div>
				</article>

				<aside>
					<header>
						<h1 class="txt22"><?php echo $title; ?></h1>
					</header>
					
					<?php echo $content; ?>
				</aside>
				
			</div> <!-- END .module -->
		
		
			<div class="content left">
			
				<section class="module">
					<header>
						<h2><?php echo $lang['TITLE_LATEST_NEWS']; ?></h2>
					</header>
					
					<div class="articles">
					
					<?php foreach ($articles as $row): ?>
						
						<article>
							<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url(article_category($row['article_id'],$site_lang)).'/'.url($row['article_title']).'-'.$row['article_id']; ?>" title="">
								<?php if($row['article_video']):?>
									<figure>
										<iframe style="border:0px;" width="232" height="140" src="http://www.youtube.com/embed/<?php echo $row['article_video']; ?>?rel=0&amp;iv_load_policy=3&amp;hd=1"></iframe>
									</figure>
								<?php elseif($row['article_image']):?> 
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['article_image']; ?>" alt="<?php echo $row['article_title']; ?>" title="" width="250" height="166"/>
									</figure>
								<?php else: ?>
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/blog.jpg" alt="<?php echo $row['article_title']; ?>" title="" width="250" height="166"/>
									</figure>
								<?php endif; ?>
							</a>
							
							<div>
								<header>
									<h3>
										<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url(article_category($row['article_id'],$site_lang)).'/'.url($row['article_title']).'-'.$row['article_id']; ?>" title="">
											<?php echo $row['article_title']; ?>
										</a>
									</h3>
									<ul class="inlineLi">
										<li>
											<i class="fa fa-user"></i> <?php echo $row['article_source']; ?>
										</li>
										<li>
										    <i class="fa fa-calendar"></i> <?php echo $row['date_added']; ?>
										</li>
									</ul>
								</header>
								
								<p><?php echo ShortenText(strip_tags($row['article_content']),200); ?></p>
								
								<footer>
									<a class="button btn-gray-red" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url(article_category($row['article_id'],$site_lang)).'/'.url($row['article_title']).'-'.$row['article_id']; ?>" title=""><?php echo $lang['BTN_READ_MORE']; ?></a>
								</footer>
							</div>
						</article>
						
					<?php endforeach; ?>	
						
					</div> <!-- END .articles -->
					
					<footer>
						<a class="link-black-white" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG']; ?>" title=""><?php echo $lang['BTN_MORE']; ?> <i class="fa fa-arrow-right"></i></a>
					</footer>
					
				</section> <!-- END .module -->
				
				
				<section class="module">
					<header>
						<h2><?php echo $lang['TITLE_LATEST_EVENTS']; ?></h2>
					</header>
					
					<div class="thumbsList">
						
						<?php foreach ($events as $row): ?>
						
						<article class="scaleEffectImg">
							<header>
								<figure>
									<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['event_poster']; ?>" alt="" title="" width="233" height="324"/>
								</figure>
							</header>
							
							<div>
								<h3><?php echo $row['event_title']; ?></h3>
								
								<div>
									<a class="button btn-grey-red" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.url($row['event_title']).'-'.$row['event_id']; ?>" title="">
										<i class="fa fa-arrow-circle-right"></i> <?php echo $lang['BTN_VIEW_DETAILS']; ?>
									</a>
								</div>
							</div>
						</article>
						
						<?php endforeach; ?>
						
					</div> <!-- END .thumbsList -->
					
					<footer>
						<a class="link-black-white" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS']; ?>" title=""><?php echo $lang['BTN_MORE']; ?> <i class="fa fa-arrow-right"></i></a>
					</footer>
					
				</section> <!-- END .module -->
			
			</div> <!-- END .content .left -->
			
			
			<aside class="sidebar right">
			
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_FACEBOOK_FAN']; ?></h2>
					</header>
					
					<div class="fb-like-box" 
						data-href="<?php echo cfg('social', 'facebook_page'); ?>" 
						data-colorscheme="dark" 
						data-show-faces="true" 
						data-header="false" 
						data-stream="false"
						data-show-border="false"
						data-height="260">
					</div>
				</article> <!-- END .widget -->
				
				<?php if($sidebar_ad): ?>
					<article class="widget">
					
						<?php echo $sidebar_ad; ?>
						
					</article> <!-- END .widget -->
				<?php endif; ?>
				
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_LATEST_MIXES']; ?></h2>
					</header>
					
					<div class="articles smallArticles widgetArticles">
					
						<?php foreach ($mixes as $row): ?>
						
						<article>
							<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title="">
								<?php if($mix['cover']):?> 
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['cover']; ?>" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php else: ?>
									<figure>
										<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj.jpg" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php endif; ?>
							</a>
							
							<div>
								<header>
									<h3><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title=""><?php echo $row['mix_title']; ?></a></h3>
								</header>
								<p>
									<i class="fa fa-user"></i> <?php echo $row['author']; ?>
								</p>
							</div>
						</article>
						
						<?php endforeach; ?>
					
					</div> <!-- END .articles .smallArticles .widgetArticles -->
					
					<footer>
						<a class="link-black-white" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES']; ?>" title=""><?php echo $lang['BTN_MORE']; ?> <i class="fa fa-arrow-right"></i></a>
					</footer>
					
				</article> <!-- END .widget -->
				
			
			</aside> <!-- END .sidebar .right -->
		
		
		</div> <!-- END .wrapper -->
		
	</div> <!-- END #container -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
</body>
</html>